<?php

// PAGES
add_action( 'admin_init', 'wpj_import_pages_action' );
function wpj_import_pages_action() {
	global $pagenow;
	
	if ( is_admin() && ( 'admin.php' == $pagenow || 'edit.php' == $pagenow ) && ( isset( $_GET['import-pages'] ) || isset( $_GET['reset-pages'] ) ) ) {
		// Rename current pages
		if ( isset( $_GET['import-pages'] ) ) {
			if ( get_pages() ) {
				foreach ( get_pages() as $key => $page ) {
					wp_update_post( [
						'ID'         => $page->ID,
						'post_title' => '[OLD] ' . $page->post_title,
						'post_name'  => $page->post_name . '-old'
					] );
				}
			}
		}

		// Delete current pages
		if ( isset( $_GET['reset-pages'] ) ) {
			$pages = get_posts( [
				'post_type'      => 'page',
				'posts_per_page' => -1,
				'post_status'    => array_keys( get_post_statuses() ),
				'post__in'       => wpj_get_page_ids()
			] );

			if ( $pages ) {
				foreach ( $pages as $page ) {
					wp_delete_post( $page->ID );
				}
			}
		}

		// Import the new pages
		if ( wpj_get_page_names() ) {
			activate_plugin( 'redux-framework/redux-framework.php' );

			foreach ( wpj_get_page_names() as $key => $page ) {
				if ( class_exists( 'Redux' ) ) Redux::set_option( 'jobster_settings', $key, '' );
				else update_option( $key, '' );

				$parent = 0; $page_template = '';
				if ( in_array( $key, [
					'wpjobster_my_account_all_notifications_page_id',
					'wpjobster_email_settings_page_id',
					'wpjobster_my_account_payments_page_id',
					'wpjobster_my_account_priv_mess_page_id',
					'wpjobster_my_account_reviews_page_id',
					'wpjobster_my_account_sales_page_id',
					'wpjobster_my_account_personal_info_page_id',
					'wpjobster_my_account_shopping_page_id',
					'wpjobster_my_favorites_page_id',
					'wpjobster_my_requests_page_id',
					'wpjobster_all_proposals_page_id',
					'wpjobster_subscriptions_page_id'
				] ) ) {
					$parent        = wpj_get_option( 'wpjobster_my_account_page_id' );
					$page_template = 'page-user-dashboard.php';
				}

				if ( $key == 'wpjobster_my_account_page_id' )
					$page_template = 'page-user-dashboard.php';

				if ( in_array( $key, [
					'main_page_url',
					'wpjobster_how_it_works_page_id',
					'wpjobster_levels_page_id',
					'wpjobster_post_new_page_id',
					'wpjobster_new_request_page_id'
				] ) ) $page_template = 'page-full-width.php';

				if ( in_array( $key, [
					'wpjobster_my_account_priv_mess_page_id',
					'wpjobster_subscriptions_page_id',
					'wpjobster_my_account_all_notifications_page_id'
				] ) ) $page_template = '';

				$page_id = wpj_insert_page( $key, str_replace( 'Single ', '', trim( $page ) ), wpj_reset_page_action( '', $page, false ), $parent, $page_template );

				if ( $key == 'main_page_url' )
					update_option( 'page_on_front', $page_id );

				if ( $key == 'wpjobster_all_blog_posts_page_id' )
					update_option( 'page_for_posts', $page_id );
			}
		}

		// Set homepage to page
		update_option( 'show_on_front', 'page' );

		// Set permalink to postname
		global $wp_rewrite;
		$wp_rewrite->set_permalink_structure( '/%postname%/' );
		update_option( 'rewrite_rules', FALSE );
		$wp_rewrite->flush_rules( true );

		// Pages imported
		update_option( 'pages_imported', 'done' );

		// Redirect to pages
		wp_redirect( admin_url( 'edit.php?post_type=page' ) );

	}

}

// MENUS
add_action( 'admin_init', 'wpj_import_menus_action' );
function wpj_import_menus_action() {

	global $pagenow;
	if ( is_admin() && ( 'admin.php' == $pagenow || 'nav-menus.php' == $pagenow ) && ( isset( $_GET['import-menus'] ) || isset( $_GET['reset-menus'] ) ) ) {

		if ( isset( $_GET['import-menus'] ) ) {
			// Reset locations
			$locations = get_theme_mod( 'nav_menu_locations' );

			$locations['wpjobster_header_main_menu']               = 0;
			$locations['wpjobster_responsive_left_menu']           = 0;
			$locations['wpjobster_responsive_left_loggedin_menu']  = 0;
			$locations['wpjobster_responsive_right_menu']          = 0;
			$locations['wpjobster_responsive_right_loggedin_menu'] = 0;
			$locations['wpjobster_header_user_account_menu']       = 0;
			$locations['wpjobster_header_user_dropdown_menu']      = 0;
			$locations['wpjobster_user_account_sidebar_menu']      = 0;
			$locations['wpjobster_header_secondary_menu']          = 0;
			$locations['wpjobster_header_secondary_loggedin_menu'] = 0;

			set_theme_mod( 'nav_menu_locations', $locations );

			// Delete current menus
			wp_delete_nav_menu( 'Authentication Menu' );
			wp_delete_nav_menu( 'C1 Footer Menu' );
			wp_delete_nav_menu( 'C1 Footer Menu - Logged In' );
			wp_delete_nav_menu( 'C2 Footer Menu' );
			wp_delete_nav_menu( 'C2 Footer Menu - Logged In' );
			wp_delete_nav_menu( 'C3 Footer Useful Links' );
			wp_delete_nav_menu( 'C4 Footer Useful Links' );
			wp_delete_nav_menu( 'C5 Footer Social' );
			wp_delete_nav_menu( 'Header Main Menu' );
			wp_delete_nav_menu( 'Header User Dropdown Extra' );
			wp_delete_nav_menu( 'Header User Account Menu' );
			wp_delete_nav_menu( 'Social Media Menu' );
			wp_delete_nav_menu( 'Custom Links Menu Test' );
		}

		// C1
		$c1_footer_menu_id        = wpj_get_menu_id_by_slug( 'c1-footer-menu' ) ? wpj_get_menu_id_by_slug( 'c1-footer-menu' ) : wp_create_nav_menu( 'C1 Footer Menu' );
		$c1_logged_footer_menu_id = wpj_get_menu_id_by_slug( 'c1-footer-menu' ) ? wpj_get_menu_id_by_slug( 'c1-footer-menu-logged-in' ) : wp_create_nav_menu( 'C1 Footer Menu - Logged In' );

		if ( isset( $_GET['reset-menus'] ) ) {
			$c1_footer_menu_items = get_objects_in_term( $c1_footer_menu_id, 'nav_menu' );
			if ( ! empty( $c1_footer_menu_items ) ) { foreach ( $c1_footer_menu_items as $c1_footer_menu_item ) { wp_delete_post( $c1_footer_menu_item ); } }

			$c1_logged_footer_menu_items = get_objects_in_term( $c1_logged_footer_menu_id, 'nav_menu' );
			if ( ! empty( $c1_logged_footer_menu_items ) ) { foreach ( $c1_logged_footer_menu_items as $c1_logged_footer_menu_item ) { wp_delete_post( $c1_logged_footer_menu_item ); } }
		}

		$categories = get_categories( [ 'taxonomy' => 'job_cat', 'parent' => 0, 'hide_empty' => false ] );
		if ( $categories ) {
			foreach ( $categories as $key => $category ) {
				wp_update_nav_menu_item( $c1_footer_menu_id, 0, [
					'menu-item-object-id' => $category->term_id,
					'menu-item-title'     => $category->name,
					'menu-item-type'      => 'taxonomy',
					'menu-item-object'    => 'job_cat',
					'menu-item-status'    => 'publish'
				] );

				wp_update_nav_menu_item( $c1_logged_footer_menu_id, 0, [
					'menu-item-object-id' => $category->term_id,
					'menu-item-title'     => $category->name,
					'menu-item-type'      => 'taxonomy',
					'menu-item-object'    => 'job_cat',
					'menu-item-status'    => 'publish'
				] );
			}
		}

		// C2
		$c2_footer_menu_id        = wpj_get_menu_id_by_slug( 'c2-footer-menu' ) ? wpj_get_menu_id_by_slug( 'c2-footer-menu' ) : wp_create_nav_menu( 'C2 Footer Menu' );
		$c2_logged_footer_menu_id = wpj_get_menu_id_by_slug( 'c2-footer-menu' ) ? wpj_get_menu_id_by_slug( 'c2-footer-menu-logged-in' ) : wp_create_nav_menu( 'C2 Footer Menu - Logged In' );

		if ( isset( $_GET['reset-menus'] ) ) {
			$c2_footer_menu_items = get_objects_in_term( $c2_footer_menu_id, 'nav_menu' );
			if ( ! empty( $c2_footer_menu_items ) ) { foreach ( $c2_footer_menu_items as $c2_footer_menu_item ) { wp_delete_post( $c2_footer_menu_item ); } }

			$c2_logged_footer_menu_items = get_objects_in_term( $c2_logged_footer_menu_id, 'nav_menu' );
			if ( ! empty( $c2_logged_footer_menu_items ) ) { foreach ( $c2_logged_footer_menu_items as $c2_logged_footer_menu_item ) { wp_delete_post( $c2_logged_footer_menu_item ); } }
		}

		wp_update_nav_menu_item( $c2_footer_menu_id, 0, [
			'menu-item-title'   => 'Login',
			'menu-item-classes' => 'login-link',
			'menu-item-url'     => wpj_get_login_link(),
			'menu-item-status'  => 'publish'
		] );

		wp_update_nav_menu_item( $c2_footer_menu_id, 0, [
			'menu-item-title'   => 'Register',
			'menu-item-classes' => 'register-link',
			'menu-item-url'     => wpj_get_register_link(),
			'menu-item-status'  => 'publish'
		] );

		wp_update_nav_menu_item( $c2_footer_menu_id, 0, [
			'menu-item-title'   => 'Forgot Password',
			'menu-item-classes' => 'lostpassword-link',
			'menu-item-url'     => wpj_get_lostpassword_link(),
			'menu-item-status'  => 'publish'
		] );

		$c2_logged_footer_pages_id = [ 'wpjobster_post_new_page_id', 'wpjobster_my_account_page_id', 'wpjobster_my_favorites_page_id', 'wpjobster_my_account_sales_page_id', 'wpjobster_my_account_shopping_page_id', 'wpjobster_my_account_payments_page_id', 'wpjobster_my_account_reviews_page_id' ];

		foreach ( $c2_logged_footer_pages_id as $key => $page_id ) {
			wp_update_nav_menu_item( $c2_logged_footer_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( $page_id ),
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );
		}

		// C3
		$c3_footer_menu_id        = wpj_get_menu_id_by_slug( 'c3-footer-menu' ) ? wpj_get_menu_id_by_slug( 'c3-footer-menu' ) : wp_create_nav_menu( 'C3 Footer Menu' );
		$c3_logged_footer_menu_id = wpj_get_menu_id_by_slug( 'c3-footer-menu' ) ? wpj_get_menu_id_by_slug( 'c3-footer-menu-logged-in' ) : wp_create_nav_menu( 'C3 Footer Menu - Logged In' );

		if ( isset( $_GET['reset-menus'] ) ) {
			$c3_footer_menu_items = get_objects_in_term( $c3_footer_menu_id, 'nav_menu' );
			if ( ! empty( $c3_footer_menu_items ) ) { foreach ( $c3_footer_menu_items as $c3_footer_menu_item ) { wp_delete_post( $c3_footer_menu_item ); } }

			$c3_logged_footer_menu_items = get_objects_in_term( $c3_logged_footer_menu_id, 'nav_menu' );
			if ( ! empty( $c3_logged_footer_menu_items ) ) { foreach ( $c3_logged_footer_menu_items as $c3_logged_footer_menu_item ) { wp_delete_post( $c3_logged_footer_menu_item ); } }
		}

		$c3_footer_pages_id = [ 'wpjobster_advanced_search_id', 'wpjobster_advanced_search_request_page_id', 'wpjobster_search_user_page_id' ];

		foreach ( $c3_footer_pages_id as $key => $page_id ) {
			wp_update_nav_menu_item( $c3_footer_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( $page_id ),
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );
		}

		$c3_logged_footer_pages_id = [ 'wpjobster_new_request_page_id', 'wpjobster_my_requests_page_id', 'wpjobster_all_requests_page_id', 'wpjobster_advanced_search_request_page_id', 'wpjobster_all_proposals_page_id' ];

		foreach ( $c3_logged_footer_pages_id as $key => $page_id ) {
			wp_update_nav_menu_item( $c3_logged_footer_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( $page_id ),
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );
		}

		// C4
		$c4_footer_menu_id        = wpj_get_menu_id_by_slug( 'c4-footer-menu' ) ? wpj_get_menu_id_by_slug( 'c4-footer-menu' ) : wp_create_nav_menu( 'C4 Footer Menu' );
		$c4_logged_footer_menu_id = wpj_get_menu_id_by_slug( 'c4-footer-menu' ) ? wpj_get_menu_id_by_slug( 'c4-footer-menu-logged-in' ) : wp_create_nav_menu( 'C4 Footer Menu - Logged In' );

		if ( isset( $_GET['reset-menus'] ) ) {
			$c4_footer_menu_items = get_objects_in_term( $c4_footer_menu_id, 'nav_menu' );
			if ( ! empty( $c4_footer_menu_items ) ) { foreach ( $c4_footer_menu_items as $c4_footer_menu_item ) { wp_delete_post( $c4_footer_menu_item ); } }

			$c4_logged_footer_menu_items = get_objects_in_term( $c4_logged_footer_menu_id, 'nav_menu' );
			if ( ! empty( $c4_logged_footer_menu_items ) ) { foreach ( $c4_logged_footer_menu_items as $c4_logged_footer_menu_item ) { wp_delete_post( $c4_logged_footer_menu_item ); } }
		}

		$c4_footer_pages_id = [ 'wpjobster_all_categories_page_id', 'wpjobster_all_news_page_id', 'wpjobster_levels_page_id' ];

		foreach ( $c4_footer_pages_id as $key => $page_id ) {
			wp_update_nav_menu_item( $c4_footer_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( $page_id ),
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );
		}

		$c4_logged_footer_pages_id = [ 'wpjobster_all_news_page_id', 'wpjobster_all_categories_page_id', 'wpjobster_levels_page_id', 'wpjobster_subscriptions_page_id' ];

		foreach ( $c4_logged_footer_pages_id as $key => $page_id ) {
			wp_update_nav_menu_item( $c4_logged_footer_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( $page_id ),
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );
		}

		// C5
		$c5_footer_menu_id        = wpj_get_menu_id_by_slug( 'c5-footer-menu' ) ? wpj_get_menu_id_by_slug( 'c5-footer-menu' ) : wp_create_nav_menu( 'C5 Footer Menu' );
		$c5_logged_footer_menu_id = wpj_get_menu_id_by_slug( 'c5-footer-menu' ) ? wpj_get_menu_id_by_slug( 'c5-footer-menu-logged-in' ) : wp_create_nav_menu( 'C5 Footer Menu - Logged In' );

		if ( isset( $_GET['reset-menus'] ) ) {
			$c5_footer_menu_items = get_objects_in_term( $c5_footer_menu_id, 'nav_menu' );
			if ( ! empty( $c5_footer_menu_items ) ) { foreach ( $c5_footer_menu_items as $c5_footer_menu_item ) { wp_delete_post( $c5_footer_menu_item ); } }

			$c5_logged_footer_menu_items = get_objects_in_term( $c5_logged_footer_menu_id, 'nav_menu' );
			if ( ! empty( $c5_logged_footer_menu_items ) ) { foreach ( $c5_logged_footer_menu_items as $c5_logged_footer_menu_item ) { wp_delete_post( $c5_logged_footer_menu_item ); } }
		}

		$c5_footer_pages_id = [ 'wpjobster_terms_of_service_page_id', 'wpjobster_privacy_policy_page_id', 'wpjobster_how_it_works_page_id' ];

		foreach ( $c5_footer_pages_id as $key => $page_id ) {
			wp_update_nav_menu_item( $c5_footer_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( $page_id ),
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );
		}

		$c5_logged_footer_pages_id = [ 'wpjobster_terms_of_service_page_id', 'wpjobster_privacy_policy_page_id', 'wpjobster_how_it_works_page_id' ];

		foreach ( $c5_logged_footer_pages_id as $key => $page_id ) {
			wp_update_nav_menu_item( $c5_logged_footer_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( $page_id ),
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );
		}

		// Secondary
		$secondary_header_menu_id        = wpj_get_menu_id_by_slug( 'header-secondary-menu' ) ? wpj_get_menu_id_by_slug( 'header-secondary-menu' ) : wp_create_nav_menu( 'Header Secondary Menu' );
		$secondary_logged_header_menu_id = wpj_get_menu_id_by_slug( 'header-secondary-logged-in-menu' ) ? wpj_get_menu_id_by_slug( 'header-secondary-logged-in-menu' ) : wp_create_nav_menu( 'Header Secondary Logged In Menu' );

		if ( isset( $_GET['reset-menus'] ) ) {
			$secondary_header_menu_items = get_objects_in_term( $secondary_header_menu_id, 'nav_menu' );
			if ( ! empty( $secondary_header_menu_items ) ) { foreach ( $secondary_header_menu_items as $secondary_header_menu_item ) { wp_delete_post( $secondary_header_menu_item ); } }

			$secondary_logged_header_menu_items = get_objects_in_term( $secondary_logged_header_menu_id, 'nav_menu' );
			if ( ! empty( $secondary_logged_header_menu_items ) ) { foreach ( $secondary_logged_header_menu_items as $secondary_logged_header_menu_item ) { wp_delete_post( $secondary_logged_header_menu_item ); } }
		}

		wp_update_nav_menu_item( $secondary_header_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_advanced_search_id' ),
			'menu-item-title'     => 'Explore Jobs',
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $secondary_header_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_advanced_search_request_page_id' ),
			'menu-item-title'     => 'Explore Requests',
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $secondary_header_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_search_user_page_id' ),
			'menu-item-title'     => 'Explore Users',
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $secondary_logged_header_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_page_id' ),
			'menu-item-title'     => 'My Jobs',
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $secondary_logged_header_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_sales_page_id' ),
			'menu-item-title'     => 'My Sales',
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $secondary_logged_header_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_post_new_page_id' ),
			'menu-item-title'     => 'Post New',
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		// Main menu
		$main_menu_id = wpj_get_menu_id_by_slug( 'header-main-menu' ) ? wpj_get_menu_id_by_slug( 'header-main-menu' ) : wp_create_nav_menu( 'Header Main Menu' );

		if ( isset( $_GET['reset-menus'] ) ) {
			$main_menu_items = get_objects_in_term( $main_menu_id, 'nav_menu' );
			if ( ! empty( $main_menu_items ) ) { foreach ( $main_menu_items as $main_menu_item ) { wp_delete_post( $main_menu_item ); } }
		}

		$categories = get_categories( [ 'taxonomy' => 'job_cat', 'parent' => 0, 'hide_empty' => false ] );
		if ( $categories ) {
			foreach ( $categories as $category ) {
				$parent = wp_update_nav_menu_item( $main_menu_id, 0, [
					'menu-item-object-id' => $category->term_id,
					'menu-item-object'    => 'job_cat',
					'menu-item-type'      => 'taxonomy',
					'menu-item-title'     => $category->name,
					'menu-item-status'    => 'publish'
				] );

				$subcategories = get_terms( 'job_cat', 'parent=' . $category->term_id . '&hide_empty=0' );
				if ( $subcategories ) {
					foreach ( $subcategories as $subcategory ) {
						wp_update_nav_menu_item( $main_menu_id, 0, [
							'menu-item-object-id' => $subcategory->term_id,
							'menu-item-parent-id' => $parent,
							'menu-item-object'    => 'job_cat',
							'menu-item-type'      => 'taxonomy',
							'menu-item-title'     => $subcategory->name,
							'menu-item-status'    => 'publish'
						] );
					}
				}
			}
		}

		// Dropdown
		$dropdown_menu_id = wpj_get_menu_id_by_slug( 'header-user-dropdown-menu' ) ? wpj_get_menu_id_by_slug( 'header-user-dropdown-menu' ) : wp_create_nav_menu( 'Header User Dropdown Menu' );

		if ( isset( $_GET['reset-menus'] ) ) {
			$dropdown_menu_items = get_objects_in_term( $dropdown_menu_id, 'nav_menu' );
			if ( ! empty( $dropdown_menu_items ) ) { foreach ( $dropdown_menu_items as $dropdown_menu_item ) { wp_delete_post( $dropdown_menu_item ); } }
		}

		$jobs_parent = wp_update_nav_menu_item( $dropdown_menu_id, 0, [
			'menu-item-title'   => 'Jobs',
			'menu-item-url'     => '#',
			'menu-item-status'  => 'publish'
		] );

			wp_update_nav_menu_item( $dropdown_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( 'wpjobster_post_new_page_id' ),
				'menu-item-parent-id' => $jobs_parent,
				'menu-item-title'     => 'Post New',
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );

			wp_update_nav_menu_item( $dropdown_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_page_id' ),
				'menu-item-parent-id' => $jobs_parent,
				'menu-item-title'     => 'My Jobs',
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );

		wp_update_nav_menu_item( $dropdown_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_sales_page_id' ),
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $dropdown_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_shopping_page_id' ),
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		$requests_parent = wp_update_nav_menu_item( $dropdown_menu_id, 0, [
			'menu-item-title'   => 'Requests',
			'menu-item-url'     => '#',
			'menu-item-status'  => 'publish'
		] );

			wp_update_nav_menu_item( $dropdown_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( 'wpjobster_new_request_page_id' ),
				'menu-item-parent-id' => $requests_parent,
				'menu-item-title'     => 'Post New',
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );

			wp_update_nav_menu_item( $dropdown_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( 'wpjobster_my_requests_page_id' ),
				'menu-item-parent-id' => $requests_parent,
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );

			wp_update_nav_menu_item( $dropdown_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( 'wpjobster_all_requests_page_id' ),
				'menu-item-parent-id' => $requests_parent,
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );

			wp_update_nav_menu_item( $dropdown_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( 'wpjobster_all_proposals_page_id' ),
				'menu-item-parent-id' => $requests_parent,
				'menu-item-title'     => 'Proposals',
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );

		wp_update_nav_menu_item( $dropdown_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_my_favorites_page_id' ),
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $dropdown_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_payments_page_id' ),
			'menu-item-title'     => 'Payments',
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		$profile_parent = wp_update_nav_menu_item( $dropdown_menu_id, 0, [
			'menu-item-title'   => 'Profile',
			'menu-item-url'     => '#',
			'menu-item-status'  => 'publish'
		] );

			wp_update_nav_menu_item( $dropdown_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( 'wpjobster_user_profile_page_id' ),
				'menu-item-parent-id' => $profile_parent,
				'menu-item-title'     => 'Public Profile',
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );

			wp_update_nav_menu_item( $dropdown_menu_id, 0, [
				'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_personal_info_page_id' ),
				'menu-item-parent-id' => $profile_parent,
				'menu-item-title'     => 'Settings',
				'menu-item-type'      => 'post_type',
				'menu-item-object'    => 'page',
				'menu-item-status'    => 'publish'
			] );

		wp_update_nav_menu_item( $dropdown_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_subscriptions_page_id' ),
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $dropdown_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_reviews_page_id' ),
			'menu-item-title'     => 'Reviews/Feedback',
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		// User account
		$user_account_menu_id = wpj_get_menu_id_by_slug( 'header-user-account-menu' ) ? wpj_get_menu_id_by_slug( 'header-user-account-menu' ) : wp_create_nav_menu( 'Header User Account Menu' );

		if ( isset( $_GET['reset-menus'] ) ) {
			$user_account_menu_items = get_objects_in_term( $user_account_menu_id, 'nav_menu' );
			if ( ! empty( $user_account_menu_items ) ) { foreach ( $user_account_menu_items as $user_account_menu_item ) { wp_delete_post( $user_account_menu_item ); } }
		}

		wp_update_nav_menu_item( $user_account_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_page_id' ),
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $user_account_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_shopping_page_id' ),
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $user_account_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_sales_page_id' ),
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $user_account_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_payments_page_id' ),
			'menu-item-title'     => 'Payments',
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $user_account_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_priv_mess_page_id' ),
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $user_account_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_personal_info_page_id' ),
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $user_account_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_my_account_reviews_page_id' ),
			'menu-item-title'     => 'Reviews/Feedback',
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		// Authentication menu
		$authentication_menu_id = wpj_get_menu_id_by_slug( 'authentication-menu' ) ? wpj_get_menu_id_by_slug( 'authentication-menu' ) : wp_create_nav_menu( 'Authentication Menu' );

		if ( isset( $_GET['reset-menus'] ) ) {
			$authentication_menu_items = get_objects_in_term( $authentication_menu_id, 'nav_menu' );
			if ( ! empty( $authentication_menu_items ) ) { foreach ( $authentication_menu_items as $authentication_menu_item ) { wp_delete_post( $authentication_menu_item ); } }
		}

		wp_update_nav_menu_item( $authentication_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_login_page_id' ),
			'menu-item-title'     => 'Login',
			'menu-item-classes'   => 'login-link',
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		wp_update_nav_menu_item( $authentication_menu_id, 0, [
			'menu-item-object-id' => wpj_get_option( 'wpjobster_register_page_id' ),
			'menu-item-title'     => 'Register',
			'menu-item-classes'   => 'register-link',
			'menu-item-type'      => 'post_type',
			'menu-item-object'    => 'page',
			'menu-item-status'    => 'publish'
		] );

		// Set locations
		$locations = get_theme_mod( 'nav_menu_locations' );

		$locations['wpjobster_header_main_menu']               = $main_menu_id;
		$locations['wpjobster_responsive_left_menu']           = $authentication_menu_id;
		$locations['wpjobster_responsive_right_menu']          = $main_menu_id;
		$locations['wpjobster_responsive_left_loggedin_menu']  = $dropdown_menu_id;
		$locations['wpjobster_responsive_right_loggedin_menu'] = $main_menu_id;
		$locations['wpjobster_header_user_account_menu']       = $user_account_menu_id;
		$locations['wpjobster_header_user_dropdown_menu']      = $dropdown_menu_id;
		$locations['wpjobster_user_account_sidebar_menu']      = $dropdown_menu_id;
		$locations['wpjobster_header_secondary_menu']          = $secondary_header_menu_id;
		$locations['wpjobster_header_secondary_loggedin_menu'] = $secondary_logged_header_menu_id;

		set_theme_mod( 'nav_menu_locations', $locations );

		// Menus imported
		update_option( 'menus_imported', 'done' );

		// Redirect to menus
		wp_redirect( admin_url( 'nav-menus.php' ) );

	}

}

// WIDGETS
add_action( 'admin_init', 'wpj_import_widgets_action' );
function wpj_import_widgets_action() {

	global $pagenow;
	if ( ( is_admin() && 'admin.php' == $pagenow && isset( $_GET['import-widgets'] ) ) || isset( $_GET['reset-widgets'] ) ) {

		// Delete old footer widgets
		$sidebars_widgets = get_option( 'sidebars_widgets', [] );

		$sidebars_widgets['footer-widget-1']           = [];
		$sidebars_widgets['footer-widget-1-logged-in'] = [];
		$sidebars_widgets['footer-widget-2']           = [];
		$sidebars_widgets['footer-widget-2-logged-in'] = [];
		$sidebars_widgets['footer-widget-3']           = [];
		$sidebars_widgets['footer-widget-3-logged-in'] = [];
		$sidebars_widgets['footer-widget-4']           = [];
		$sidebars_widgets['footer-widget-4-logged-in'] = [];
		$sidebars_widgets['footer-widget-5']           = [];
		$sidebars_widgets['footer-widget-5-logged-in'] = [];

		update_option( 'sidebars_widgets', $sidebars_widgets );

		// Insert new widgets
		wpj_insert_widget( 'nav_menu', [ 'title' => 'Categories',     'nav_menu' => wpj_get_menu_id_by_slug( 'c1-footer-menu' ) ], 'footer-widget-1' );
		wpj_insert_widget( 'nav_menu', [ 'title' => 'Categories',     'nav_menu' => wpj_get_menu_id_by_slug( 'c1-footer-menu-logged-in' ) ], 'footer-widget-1-logged-in' );

		wpj_insert_widget( 'nav_menu', [ 'title' => 'Authentication', 'nav_menu' => wpj_get_menu_id_by_slug( 'c2-footer-menu' ) ], 'footer-widget-2' );
		wpj_insert_widget( 'nav_menu', [ 'title' => 'User Menu',      'nav_menu' => wpj_get_menu_id_by_slug( 'c2-footer-menu-logged-in' ) ], 'footer-widget-2-logged-in' );

		wpj_insert_widget( 'nav_menu', [ 'title' => 'Search',         'nav_menu' => wpj_get_menu_id_by_slug( 'c3-footer-menu' ) ], 'footer-widget-3' );
		wpj_insert_widget( 'nav_menu', [ 'title' => 'Requests',       'nav_menu' => wpj_get_menu_id_by_slug( 'c3-footer-menu-logged-in' ) ], 'footer-widget-3-logged-in' );

		wpj_insert_widget( 'nav_menu', [ 'title' => 'Useful Links',   'nav_menu' => wpj_get_menu_id_by_slug( 'c4-footer-menu' ) ], 'footer-widget-4' );
		wpj_insert_widget( 'nav_menu', [ 'title' => 'Useful Links',   'nav_menu' => wpj_get_menu_id_by_slug( 'c4-footer-menu-logged-in' ) ], 'footer-widget-4-logged-in' );

		wpj_insert_widget( 'nav_menu', [ 'title' => 'Legal',          'nav_menu' => wpj_get_menu_id_by_slug( 'c5-footer-menu' ) ], 'footer-widget-5' );
		wpj_insert_widget( 'nav_menu', [ 'title' => 'Legal',          'nav_menu' => wpj_get_menu_id_by_slug( 'c5-footer-menu-logged-in' ) ], 'footer-widget-5-logged-in' );

		// Widgets imported
		update_option( 'widgets_imported', 'done' );

		// Redirect to widgets
		wp_redirect( admin_url( 'widgets.php' ) );

	}

}
