<?php
add_filter( 'merlin_generate_child_functions_php', 'wpj_generate_child_theme_functions_php_content', 10, 2 );
function wpj_generate_child_theme_functions_php_content( $output, $slug ) {

	$output = "
		<?php
		/**
		* Jobster functions and definitions
		*
		* @author WPJobster <support@wpjobster.com>
		* @copyright Copyright (c) 2021 WPJobster. All rights reserved.
		*
		* @link http://wpjobster.com/
		* @link http://wpjobster.com/terms-of-service/
		* @link http://wpjobster.com/privacy-policy/
		*
		* @package WPJobster
		* @subpackage Jobster
		* @since Jobster v1.0.0
		*/

		add_action( 'wp_enqueue_scripts', 'wpjobster_load_stylesheets', 12 );
		function wpjobster_load_stylesheets() {

			tab-// enqueue parent styles
			tab-wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css', [], wpjobster_VERSION );

			tab-// enqueue child styles
			tab-wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', [ 'parent-style' ], wpjobster_VERSION );

			tab-// enqueue child rtl styles
			tab-if ( is_rtl() ) { wp_enqueue_style( 'child-style-rtl', get_stylesheet_directory_uri() . '/rtl.css', [ 'parent-style' ], wpjobster_VERSION ); }

			tab-// enqueue child scripts
			tab-wp_enqueue_script( 'child-script', get_stylesheet_directory_uri() . '/script.js', [ 'jquery' ], wpjobster_VERSION, true );
		}


		add_action( 'after_setup_theme', 'wpjobster_load_child_textdomain' );
		function wpjobster_load_child_textdomain() {
			tab-load_child_theme_textdomain( 'wpjobster-child', get_stylesheet_directory() . '/languages' );
		}

		/*************** ADD CUSTOM THEME FUNCTIONS BELOW ***************/
	";

	$output = trim( preg_replace( '/\t+/', '', $output ) );
	$output = str_replace( 'tab-', "\t", $output );

	return $output . "\n";
}

add_filter( 'merlin_generate_child_style_css', 'wpj_generate_child_theme_style_css_content', 10, 4 );
function wpj_generate_child_theme_style_css_content( $output, $slug, $parent, $version ) {

	$output = "
		/*
		Theme Name: Jobster Child Theme
		Theme URI: http://wpjobster.com/
		Author: WPJobster
		Author URI: http://wpjobster.com/
		Description: This is a child theme for Jobster
		Version: 0.0.9
		Template: wpjobster
		*/

		/*************** ADD CUSTOM CSS BELOW ***************/
	";

	$output = trim( preg_replace( '/\t+/', '', $output ) );

	return $output . "\n";
}

function wpj_generate_child_theme_rtl_style_css_content() {

	$output = "
		/*
		Jobster Theme RTL CSS Fixes

		(c) WPJobster
		URL: http://wpjobster.com/
		*/

		/*************** ADD CUSTOM CSS BELOW ***************/
	";

	$output = trim( preg_replace( '/\t+/', '', $output ) );

	return $output . "\n";
}

function wpj_generate_child_theme_script_js_content() {

	$output = "
		/*
		Jobster Theme Scripts

		(c) WPJobster
		URL: http://wpjobster.com/
		*/

		/*************** ADD CUSTOM JS BELOW ***************/
	";

	$output = trim( preg_replace( '/\t+/', '', $output ) );

	return $output . "\n";
}