<?php
add_filter( 'merlin_import_files', function() {
	return [
		array(
			'import_file_name'           => 'Jobster Demo Content Import',
			'import_file_url'            => 'https://democontent.wpjobster.com/v6/jobster_content_gutenberg.xml',
			'import_widget_file_url'     => 'https://democontent.wpjobster.com/v6/jobster_widgets.wie',
			'import_customizer_file_url' => 'https://democontent.wpjobster.com/v6/jobster_customizer.dat',
			'import_redux'        => array(
				array(
					'file_url'    => 'https://democontent.wpjobster.com/v6/jobster_settings.json',
					'option_name' => 'jobster_settings',
				),
				array(
					'file_url'    => 'https://democontent.wpjobster.com/v6/jobster_design.json',
					'option_name' => 'jobster_design',
				),
			),
			'import_preview_image_url' => get_template_directory_uri() . '/assets/images/admin/demo-preview.webp',
			'import_notice'            => __( 'After you import this demo, you will have to setup the settings and design separately.', 'wpjobster' ),
			'preview_url'              => 'https://demo.wpjobster,com',
		)
	];
});

add_action( 'merlin_after_all_import', function() {

	// Done database update
	update_option( 'wpj_batch_update_6_metas', 'done' );
	update_option( 'wpj_batch_update_user_2fa_meta', 'done' );
	update_option( 'wpj_batch_update_job_reviews_meta', 'done' );

	update_option( 'wpj_add_auth_menu_v615', 'done' );
	update_option( 'wpj_change_load_more_button_colour', 'done' );
	update_option( 'wpj_add_emails_content_for_badges_v614', 'done' );
	update_option( 'wpj_add_sms_content_for_badges_v614', 'done' );
	update_option( 'wpj_add_emails_content_for_notifications_v613', 'done' );
	update_option( 'wpj_add_sms_content_for_notifications_v613', 'done' );
	update_option( 'wpj_change_register_button_colour', 'done' );
	update_option( 'wpj_add_authentication_pages', 'done' );

	// Skip migration
	update_option( 'wpjobster_skip_migration', 1 );

	// Set menus location
	$main_menu               = get_term_by( 'name', 'Header Main Menu', 'nav_menu' );
	$dropdown_menu           = get_term_by( 'name', 'Header User Dropdown Menu', 'nav_menu' );
	$user_acc_menu           = get_term_by( 'name', 'Header User Account Menu', 'nav_menu' );
	$auth_menu               = get_term_by( 'name', 'Authentication Menu', 'nav_menu' );
	$secondary_menu          = get_term_by( 'name', 'Header Secondary Menu', 'nav_menu' );
	$secondary_loggedin_menu = get_term_by( 'name', 'Header Secondary Logged In Menu', 'nav_menu' );

	set_theme_mod( 'nav_menu_locations', [
		'wpjobster_header_main_menu'               => isset( $main_menu->term_id ) ? $main_menu->term_id : '',

		'wpjobster_responsive_left_menu'           => isset( $auth_menu->term_id ) ? $auth_menu->term_id : '',
		'wpjobster_responsive_left_loggedin_menu'  => isset( $dropdown_menu->term_id ) ? $dropdown_menu->term_id : '',
		'wpjobster_responsive_right_menu'          => isset( $main_menu->term_id ) ? $main_menu->term_id : '',
		'wpjobster_responsive_right_loggedin_menu' => isset( $main_menu->term_id ) ? $main_menu->term_id : '',

		'wpjobster_header_user_account_menu'       => isset( $user_acc_menu->term_id ) ? $user_acc_menu->term_id : '',
		'wpjobster_header_user_dropdown_menu'      => isset( $dropdown_menu->term_id ) ? $dropdown_menu->term_id : '',
		'wpjobster_user_account_sidebar_menu'      => isset( $dropdown_menu->term_id ) ? $dropdown_menu->term_id : '',

		'wpjobster_header_secondary_menu'          => isset( $secondary_menu->term_id ) ? $secondary_menu->term_id : '',
		'wpjobster_header_secondary_loggedin_menu' => isset( $secondary_loggedin_menu->term_id ) ? $secondary_loggedin_menu->term_id : ''
	] );

	// Set tagline
	update_option( 'blogdescription', 'The most sophisticated and feature rich WordPress theme for service marketplace' );

	// Set permalink to postname
	global $wp_rewrite;
	$wp_rewrite->set_permalink_structure( '/%postname%/' );
	update_option( 'rewrite_rules', FALSE );
	$wp_rewrite->flush_rules( true );

	// WP settings
	update_option( 'users_can_register', 1 );
	update_option( 'posts_per_page', 12 );
	update_option( 'posts_per_rss', 12 );

	// Update license
	$jobster_settings = get_option( 'jobster_settings' );
	if ( is_array( $jobster_settings ) ) {
		$jobster_settings['wpjobster_license_key'] = get_option( 'theme_key_temp' );
		update_option( 'jobster_settings', $jobster_settings );

	} else {
		update_option( 'jobster_settings', [ 'wpjobster_license_key' => get_option( 'theme_key_temp' ) ] );

	}
	delete_option( 'theme_key_temp' );

	// Set homepage type
	update_option( 'show_on_front', 'page' );

	// Set homepage and blog page
	$front_page_id = wpj_get_page_by_title( 'Homepage' );
	update_option( 'page_on_front', $front_page_id->ID );

	$blog_page_id = wpj_get_page_by_title( 'Blog Posts' );
	update_option( 'page_for_posts', $blog_page_id->ID );

	// Set image size
	update_option( 'thumb_picture_size_w', 300 );
	update_option( 'thumb_picture_size_h', 207 );
	update_option( 'thumb_picture_crop', 'on' );

	update_option( 'job_cover_image_size_w', 1170 );
	update_option( 'job_cover_image_size_h', 215 );
	update_option( 'job_cover_image_crop', 'on' );

	update_option( 'job_slider_image_size_w', 720 );
	update_option( 'job_slider_image_size_h', 405 );

	update_option( 'blog_thumbnail_big_size_w', 980 );
	update_option( 'blog_thumbnail_big_size_h', 405 );
	update_option( 'blog_thumbnail_big_crop', 'on' );

	update_option( 'news_slider_size_w', 486 );
	update_option( 'news_slider_size_h', 220 );
	update_option( 'news_slider_crop', 'on' );

	update_option( 'square_150_size_w', 150 );
	update_option( 'square_150_size_h', 150 );
	update_option( 'square_150_crop', 'on' );

	update_option( 'square_180_size_w', 180 );
	update_option( 'square_180_size_h', 180 );
	update_option( 'square_180_crop', 'on' );

	// qTranslate-X default options
	update_option( 'qtranslate_post_type_excluded', [ 'acf-field-group', 'acf-field', 'job', 'offer', 'request' ] );
	update_option( 'qtranslate_qtrans_compatibility', '1' );

	// Remove dashboard access
	update_option( 'rda_enable_profile', '' );

	// Easy social share buttons 3
	$essb_args = wp_parse_args( [
		'style'                        => 6,
		'button_style'                 => 'icon',
		'hide_social_name'             => 1,
		'target_link'                  => 1,
		'display_where'                => 'nowhere',
		'buttons_pos'                  => 'right',
		'force_hide_buttons_on_mobile' => 'true',
		'display_in_types'             => array( 'post', 'news' ),
		'networks'                     => array( 'facebook', 'twitter', 'google', 'pinterest', 'linkedin', 'whatsapp' ),
	], get_option( 'easy-social-share-buttons3', [] ) );
	update_option( 'easy-social-share-buttons3', $essb_args );

	// WP social login
	update_option( 'wsl_settings_Facebook_enabled', 1 );
	update_option( 'wsl_settings_Google_enabled',   1 );
	update_option( 'wsl_settings_Twitter_enabled',  1 );
	update_option( 'wsl_settings_social_icon_set',  'none' );
	update_option( 'wsl_settings_users_avatars',    0 );
	update_option( 'wsl_settings_use_popup',        1 );
	update_option( 'wsl_settings_widget_display',   4 );
	update_option( 'wsl_settings_bouncer_profile_completion_require_email', 1 );
	update_option( 'wsl_settings_bouncer_profile_completion_change_username', 1 );

	// Theme installed date
	update_option( 'wpjobster_installed_date', current_time( 'timestamp', 1 ) );

});
