<?php add_action( 'admin_head', function() {

	$loader_url = get_template_directory_uri() . '/assets/images/loader/loader-green.svg'; ?>

	<script>

		jQuery( document ).ready( function( $ ) {
			if ( $( '.merlin__wrapper' )[0] ) {

				$( '.merlin__wrapper .merlin__content .merlin__content--transition .icon:not(.icon--checkmark)' ).css({ 'width': '160px', 'margin-bottom': 0 });

				$( '\
					<div class="merlin__content--license-type">\
						<div class="merlin__content--license-type-wrapper merlin__select-control-wrapper" style="max-width: 245px;">\
							<img src="<?php echo $loader_url; ?>" style="position:absolute;right:10px;bottom:5px;display:none;" class="license-loader">\
							<select class="merlin__select-control js-license-type" style="background: #fff; height: 40px; line-height:2; border-color: #8c8f94;">\
								<option value="">Select License Type</option>\
								<option value="Entrepreneur">Entrepreneur</option>\
								<option value="Developer">Developer</option>\
								<option value="Webmaster">Webmaster</option>\
								<option value="Beginner">Beginner</option>\
							</select>\
						</div>\
					</div>\
				' ).insertBefore( '.merlin__content--license-key' );

				$( '.merlin__content--license-key' ).hide();

				$( '.js-license-type' ).on( 'change', function() {
					if ( $( this ).val() ) {
						$( '.merlin__content--license-key' ).hide();
						$( '.license-loader' ).show();

						$.ajax({
							type: "POST",
							url : '<?php echo admin_url( 'admin-ajax.php' ); ?>',
							data: {
								action      : 'theme_license_type_action',
								license_type: $( this ).val()
							},
							success: function( msg ) {
								$( '.merlin__content--license-key' ).show();
								$( '.license-loader' ).hide();
							}
						});

					} else {
						$( '.merlin__content--license-key' ).hide();

					}
				});

				$( '.js-license-key' ).on( 'input', function() {
					$.ajax({
						type: "POST",
						url : '<?php echo admin_url( 'admin-ajax.php' ); ?>',
						data: {
							action      : 'theme_license_key_action',
							license_key: $( this ).val()
						},
						success: function( msg ) {}
					});
				});

			}
		});

	</script>

<?php });

add_action( 'wp_ajax_theme_license_type_action', function() {
	if ( isset( $_POST['license_type'] ) )
		update_option( 'theme_license_type', $_POST['license_type'] );
});

add_action( 'wp_ajax_theme_license_key_action', function() {
	if ( isset( $_POST['license_key'] ) ) {
		update_option( 'theme_key_temp', $_POST['license_key'] );
	}
});

if ( wpj_get_option( 'wpjobster_license_key' ) == '' ) add_action( 'admin_notices', 'wpj_license_key_missing_notice' );
function wpj_license_key_missing_notice() {
	if ( wpj_get_option( 'wpjobster_installed_date', false )
		&& ( current_time( 'timestamp', 1 ) - wpj_get_option( 'wpjobster_installed_date', false ) ) > ( 86400 * 7 ) // 7 days
	) { ?>

		<div class="notice notice-error is-dismissible">
			<h2><?php _e( "WARNING! You're using an unlicensed version of Jobster Theme.", 'wpjobster'); ?></h2>

			<p><?php _e( "Please consider buying a license to benefit from the latest security updates and all of the newest features.", 'wpjobster' ); ?></p>

			<p>
				<a class="button button-primary" href="https://wpjobster.com/buy/?utm_source=missing-license-notice" target="_blank"><?php _e( 'I want support and updates', 'wpjobster' ); ?></a>
				&nbsp; <a class="" href="<?php echo admin_url( 'admin.php?page=jobster-settings' ); ?>"><?php _e( 'I already have a license key', 'wpjobster' ); ?></a>
			</p>
		</div>

	<?php } elseif ( wpj_get_option( 'wpjobster_installed_date' ) ) { ?>

		<div class="notice notice-warning is-dismissible">
			<p>
				<?php _e( 'Please fill your WPJobster License Key!', 'wpjobster' ); ?>
				&nbsp; <a class="" href="<?php echo admin_url( 'admin.php?page=jobster-settings' ); ?>"><?php _e( 'General Settings', 'wpjobster' ); ?></a>
			</p>
		</div>

	<?php }
}

if ( wpj_get_option( 'wpjobster_license_key_status' ) == 'disabled' ) add_action( 'admin_notices', 'wpj_license_key_disabled_notice' );
function wpj_license_key_disabled_notice() { ?>

	<div class="notice notice-error is-dismissible">
		<h2><?php _e( "WARNING! You're using a disabled license.", 'wpjobster'); ?></h2>

		<p><?php _e( "Please consider buying a license to benefit from the latest security updates and all of the newest features.", 'wpjobster' ); ?></p>

		<p>
			<a class="button button-primary" href="https://wpjobster.com/buy/?utm_source=disabled-license-notice" target="_blank"><?php _e( 'I want support and updates', 'wpjobster' ); ?></a>
		</p>
	</div>

<?php }