<?php

// WPJ BUNDLED PLUGINS //

add_action( 'tgmpa_register', 'wpj_register_required_plugins' );
function wpj_register_required_plugins() {

	/*
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = [

		// Required

		array(
			'name'         => 'Redux',
			'slug'         => 'redux-framework',
			'required'     => true,
			'has_notices'  => false,
		),

		array(
			'name'         => 'Kadence Blocks',
			'slug'         => 'kadence-blocks',
			'required'     => true,
		),

		array(
			'name'         => 'Kadence Blocks Pro',
			'slug'         => 'kadence-blocks-pro',
			'required'     => true,
			'version'      => '2.6.1',
			'source'       => 'https://plugins.wpjobster.com/kadence-blocks-pro.zip',
			'external_url' => 'https://www.kadencewp.com/kadence-blocks/pro/',
		),

		// Recommended

		array(
			'name'         => 'WPJobster 1Updater',
			'slug'         => 'wpjobster-1updater',
			'required'     => false,
			'version'      => '3.0.1',
			'source'       => 'https://plugins.wpjobster.com/wpjobster-1updater.zip',
		),

		array(
			'name'         => 'User Bookmarks',
			'slug'         => 'user-bookmarks',
			'required'     => false,
			'version'      => '1.0.9',
			'source'       => 'https://plugins.wpjobster.com/user-bookmarks.zip',
		),

		// Optional

		array(
			'name'         => 'Easy Social Share Buttons',
			'slug'         => 'easy-social-share-buttons3',
			'required'     => false,
			'has_notices'  => false,
			'version'      => '9.6',
			'source'       => 'https://plugins.wpjobster.com/easy-social-share-buttons3.zip',
			'external_url' => 'https://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476',
		),

		array(
			'name'         => 'Advanced Custom Fields',
			'slug'         => 'advanced-custom-fields-pro',
			'required'     => false,
			'has_notices'  => false,
			'version'      => '6.3.4',
			'source'       => 'https://plugins.wpjobster.com/advanced-custom-fields-pro.zip',
			'external_url' => 'https://wordpress.org/plugins/advanced-custom-fields/',
		),

		array(
			'name'         => 'Slider Revolution',
			'slug'         => 'revslider',
			'required'     => false,
			'has_notices'  => false,
			'version'      => '6.7.7',
			'source'       => 'https://plugins.wpjobster.com/revslider.zip',
			'external_url' => 'https://codecanyon.net/item/slider-revolution-responsive-wordpress-plugin/2751380',
		),

		array(
			'name'         => 'Loco Translate',
			'slug'         => 'loco-translate',
			'required'     => false,
			'has_notices'  => false,
		),

		array(
			'name'         => 'Menu Icons',
			'slug'         => 'menu-icons',
			'required'     => false,
			'has_notices'  => false,
		),

		array(
			'name'         => 'Remove Dashboard Access',
			'slug'         => 'remove-dashboard-access-for-non-admins',
			'version'      => '1.1.3',
			'required'     => false,
			'has_notices'  => false,
		),

		array(
			'name'         => 'Image Watermark',
			'slug'         => 'image-watermark',
			'required'     => false,
			'has_notices'  => false,
			'source'       => 'https://plugins.wpjobster.com/image-watermark.zip',
		),

		array(
			'name'         => 'Advanced Access Manager',
			'slug'         => 'advanced-access-manager',
			'required'     => false,
			'has_notices'  => false,
		),

		array(
			'name'         => 'WP Better Emails',
			'slug'         => 'wp-better-emails',
			'required'     => false,
			'has_notices'  => false,
			'version'      => '0.4.1-wpj',
			'source'       => 'https://plugins.wpjobster.com/wp-better-emails.zip',
			'external_url' => 'https://wordpress.org/plugins/wp-better-emails/',
		),

		array(
			'name'         => 'WordPress Social Login',
			'slug'         => 'wordpress-social-login',
			'required'     => false,
			'has_notices'  => false,
			'version'      => '3.0.8-wpj',
			'source'       => 'https://plugins.wpjobster.com/wordpress-social-login.zip',
			'external_url' => 'http://miled.github.io/wordpress-social-login/',
		),

		array(
			'name'         => 'Yoast SEO',
			'slug'         => 'wordpress-seo',
			'required'     => false,
			'has_notices'  => false,
			'is_callable'  => 'wpseo_init',
		),

		array(
			'name'         => 'Ads Pro',
			'slug'         => 'bsa-plugin-pro-scripteo',
			'required'     => false,
			'has_notices'  => false,
			'version'      => '4.8',
			'source'       => 'https://plugins.wpjobster.com/bsa-plugin-pro-scripteo.zip',
			'external_url' => 'https://codecanyon.net/item/ads-pro-addon-wordpress-marketing-agency/10665901',
		),

		array(
			'name'         => 'AIO Support Center',
			'slug'         => 'di-aiosc',
			'required'     => false,
			'has_notices'  => false,
			'version'      => '2.22',
			'source'       => 'https://plugins.wpjobster.com/di-aiosc.zip',
			'external_url' => 'https://codecanyon.net/item/aio-support-center-wordpress-ticketing-system/8283822',
		),

		array(
			'name'         => 'Newsletter',
			'slug'         => 'newsletter',
			'required'     => false,
			'has_notices'  => false,
		),

		array(
			'name'         => 'Usernoise Pro',
			'slug'         => 'usernoise',
			'required'     => false,
			'has_notices'  => false,
			'version'      => '5.2.9',
			'source'       => 'https://plugins.wpjobster.com/usernoise.zip',
			'external_url' => 'https://codecanyon.net/item/usernoise-pro-modal-feedback-contact-form/1420436',
		),

		array(
			'name'         => 'User Switching',
			'slug'         => 'user-switching',
			'required'     => false,
			'has_notices'  => false,
		),

		array(
			'name'         => 'WP Crontrol',
			'slug'         => 'wp-crontrol',
			'required'     => false,
			'has_notices'  => false,
		),
	];


	$plugins_multi_language = [

		// Optional Multi-Language

		array(
			'name'         => 'TranslatePress',
			'slug'         => 'translatepress-multilingual',
			'required'     => false,
			'has_notices'  => false,
			//'version'      => '2.2.3',
			//'source'       => 'https://plugins.wpjobster.com/translatepress.zip',
			//'external_url' => 'https://wordpress.org/plugins/translatepress-multilingual/'
		)

	];

	if ( wpj_is_allowed( 'multi_language' ) ) {
		$plugins = array_merge( $plugins, $plugins_multi_language );
	}


	/*
	 * Array of configuration settings. Amend each line as needed.
	 *
	 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
	 * strings available, please help us make TGMPA even better by giving us access to these translations or by
	 * sending in a pull-request with .po file(s) with the translations.
	 *
	 * Only uncomment the strings in the config array if you want to customize the strings.
	 */
	$config = [
		'id'           => 'wpjobster',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'parent_slug'  => 'plugins.php',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.


		'strings'      => array(
			'page_title'                      => __( 'Install plugins compatible with WPJobster', 'wpjobster' ),
			'menu_title'                      => __( 'Compatible Plugins', 'wpjobster' ),
			/* translators: %s: plugin name. */
			'installing'                      => __( 'Installing Plugin: %s', 'wpjobster' ),
			/* translators: %s: plugin name. */
			'updating'                        => __( 'Updating Plugin: %s', 'wpjobster' ),
			'oops'                            => __( 'Something went wrong with the plugin API.', 'wpjobster' ),
			'notice_can_install_required'     => _n_noop(
				/* translators: 1: plugin name(s). */
				'This theme <span class="tgmpa-required">requires</span> the following plugin: %1$s.',
				'This theme <span class="tgmpa-required">requires</span> the following plugins: %1$s.',
				'wpjobster'
			),
			'notice_can_install_recommended'  => _n_noop(
				/* translators: 1: plugin name(s). */
				'This theme recommends the following plugin: %1$s.',
				'This theme recommends the following plugins: %1$s.',
				'wpjobster'
			),
			'notice_ask_to_update'            => _n_noop(
				/* translators: 1: plugin name(s). */
				'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.',
				'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.',
				'wpjobster'
			),
			'notice_ask_to_update_maybe'      => _n_noop(
				/* translators: 1: plugin name(s). */
				'There is an update available for: %1$s.',
				'There are updates available for the following plugins: %1$s.',
				'wpjobster'
			),
			'notice_can_activate_required'    => _n_noop(
				/* translators: 1: plugin name(s). */
				'The following <span class="tgmpa-required">required</span> plugin is currently inactive: %1$s.',
				'The following <span class="tgmpa-required">required</span> plugins are currently inactive: %1$s.',
				'wpjobster'
			),
			'notice_can_activate_recommended' => _n_noop(
				/* translators: 1: plugin name(s). */
				'The following recommended plugin is currently inactive: %1$s.',
				'The following recommended plugins are currently inactive: %1$s.',
				'wpjobster'
			),
			'install_link'                    => _n_noop(
				'Begin installing plugin',
				'Begin installing plugins',
				'wpjobster'
			),
			'update_link' 					  => _n_noop(
				'Begin updating plugin',
				'Begin updating plugins',
				'wpjobster'
			),
			'activate_link'                   => _n_noop(
				'Begin activating plugin',
				'Begin activating plugins',
				'wpjobster'
			),
			'return'                          => __( 'Return to Required Plugins Installer', 'wpjobster' ),
			'plugin_activated'                => __( 'Plugin activated successfully.', 'wpjobster' ),
			'activated_successfully'          => __( 'The following plugin was activated successfully:', 'wpjobster' ),
			/* translators: 1: plugin name. */
			'plugin_already_active'           => __( 'No action taken. Plugin %1$s was already active.', 'wpjobster' ),
			/* translators: 1: plugin name. */
			'plugin_needs_higher_version'     => __( 'Plugin not activated. A higher version of %s is needed for this theme. Please update the plugin.', 'wpjobster' ),
			/* translators: 1: dashboard link. */
			'complete'                        => __( 'All plugins installed and activated successfully. %1$s', 'wpjobster' ),
			'dismiss'                         => __( 'Dismiss this notice', 'wpjobster' ),
			'notice_cannot_install_activate'  => __( 'There are one or more required or recommended plugins to install, update or activate.', 'wpjobster' ),
			'contact_admin'                   => __( 'Please contact the administrator of this site for help.', 'wpjobster' ),

			'nag_type'                        => '', // Determines admin notice type - can only be one of the typical WP notice classes, such as 'updated', 'update-nag', 'notice-warning', 'notice-info' or 'error'. Some of which may not work as expected in older WP versions.
		),
	];

	tgmpa( $plugins, $config );
}

add_action( 'admin_head', function() { ?>

	<script>

		jQuery( document ).ready( function( $ ) {
			$( '.merlin__drawer--install-plugins' ).find( 'label' ).each( function() {
				if ( ! $( this ).find( '.badge' )[0] ) {
					$( this ).siblings( 'input' ).removeAttr( 'checked' );
				}
			})
		});

	</script>

<?php });