<?php

// Theme updated
function wpj_database_updated_notice() { ?>

	<div class="updated notice is-dismissible">
		<p><?php _e( 'Jobster Database was successfully updated!', 'wpjobster' ); ?></p>
	</div>

<?php }

// Theme setup
if ( ! get_option( 'wpjobster_installed_date' ) ) {

	add_action( 'admin_notices', 'wpj_setup_theme_notice' );
	function wpj_setup_theme_notice() {
		if ( ! wpj_get_option( 'pages_imported' ) ) { ?>

			<div class="notice notice-error">
				<p><?php _e( 'The theme has been successfully installed but is not yet configured.', 'wpjobster' ); ?></p>
				<p><?php _e( 'This step is required for the theme to work properly.', 'wpjobster' ); ?></p>
				<p><a class="button action" href="<?php echo admin_url( 'themes.php?page=wpjobster-install' ); ?>"><?php _e( 'Configure the theme', 'wpjobster' ); ?></a></p>
			</div>

		<?php }
	}

}

// Migration from v5 to v6
if ( ! get_option( 'wpjobster_skip_migration' ) && get_option( 'wpjobster_installed_date' ) ) {

	add_action( 'admin_notices', 'wpj_import_pages_notice' );
	function wpj_import_pages_notice() {
		if ( ! wpj_get_option( 'pages_imported' ) ) { ?>

			<div class="notice notice-error">
				<p><?php _e( 'You are using older version of the pages. For this version to work properly, you must import the new pages.', 'wpjobster' ); ?></p>
				<p><?php _e( 'Because this version is a major change, we strongly recommend you to make a backup before continuing the migration.', 'wpjobster' ); ?></p>
				<p><a class="button action" href="<?php echo admin_url( 'admin.php?import-pages=true' ); ?>"><?php _e( 'Import new pages', 'wpjobster' ); ?></a></p>
			</div>

		<?php }
	}

	add_action( 'admin_notices', 'wpj_import_menus_notice' );
	function wpj_import_menus_notice() {
		if ( wpj_get_option( 'pages_imported' ) && ! wpj_get_option( 'menus_imported' ) ) { ?>

			<div class="notice notice-error">
				<p><?php _e( 'You are using older version of the menus. For this version to work properly, you must import the new menus.', 'wpjobster' ); ?></p>
				<p><?php _e( 'Current menus will be rewritten / deleted.', 'wpjobster' ); ?></p>
				<p><a class="button action" href="<?php echo admin_url( 'admin.php?import-menus=true' ); ?>"><?php _e( 'Import new menus', 'wpjobster' ); ?></a></p>
			</div>

		<?php }
	}

	add_action( 'admin_notices', 'wpj_import_widgets_notice' );
	function wpj_import_widgets_notice() {
		if ( wpj_get_option( 'pages_imported' ) && wpj_get_option( 'menus_imported' ) && ! wpj_get_option( 'widgets_imported' ) ) { ?>

			<div class="notice notice-error">
				<p><?php _e( 'You are using older version of the widgets. For this version to work properly, you must import the new widgets.', 'wpjobster' ); ?></p>
				<p><?php _e( 'Current footer widgets will be rewritten / deleted.', 'wpjobster' ); ?></p>
				<p><a class="button action" href="<?php echo admin_url( 'admin.php?import-widgets=true' ); ?>"><?php _e( 'Import new widgets', 'wpjobster' ); ?></a></p>
			</div>

		<?php }
	}

}

add_action( 'admin_notices', 'wpj_openexchangerates_appid_required_notice' );
function wpj_openexchangerates_appid_required_notice() {
	if ( wpj_get_option( 'wpjobster_enable_open_exchange_api_rate' ) == 'yes' && ! wpj_get_option( 'openexchangerates_appid' ) ) { ?>

		<div class="notice notice-warning is-dismissible">
			<p><?php echo sprintf( __( 'Please access %s and fill in the \'OpenExchange app ID\' field with your own key.', 'wpjobster' ), '<a href="' . admin_url( 'admin.php?page=jobster-settings&tab=' . wpj_get_settings_tab_number_by_field_id( 'general-main-settings' ) ) . '">this link</a>' ); ?></p>
		</div>

	<?php }
}

add_action( 'admin_notices', 'wpj_deprecated_plugins_notice' );
function wpj_deprecated_plugins_notice() {
	if ( is_plugin_active( 'acf-qtranslate/acf-qtranslate.php' ) || is_plugin_active( 'brizy/brizy.php' ) || is_plugin_active( 'revslider/revslider.php' ) ) { ?>

		<div class="notice notice-warning is-dismissible">
			<p><?php _e( 'The new version of the theme no longer uses plugins like Advanced Custom Fields: qTranslate, Brizy or Slider Revolution.', 'wpjobster' ); ?></p>
			<p><?php _e( 'For better theme performance, you can disable/delete these plugins.', 'wpjobster' ); ?></p>
		</div>

	<?php }
}

add_action( 'admin_notices', 'wpj_qtranslate_notice' );
function wpj_qtranslate_notice() {
	if ( function_exists( 'qtranxf_generateLanguageSelectCode' ) ) { ?>

		<div class="notice notice-warning is-dismissible">
			<p><?php _e( 'The qTranslate X plugin is deprecated and no longer works with Gutenberg and the v6 version of the theme.', 'wpjobster' ); ?></p>
			<p><?php _e( 'Please install the TranslatePress plugin from the Plugins > Required Plugins menu of the theme.', 'wpjobster' ); ?></p>
			<p><a class="button action" href="<?php echo admin_url( 'plugins.php?page=tgmpa-install-plugins' ); ?>"><?php _e( 'Go to Required Plugins', 'wpjobster' ); ?></a></p>
		</div>

	<?php }
}

add_action( 'admin_notices', 'wpj_redux_notices' );
function wpj_redux_notices() {
	$screen = get_current_screen();

	if ( isset( $screen->base ) ) {
		if ( 'toplevel_page_jobster-settings' !== $screen->base && 'toplevel_page_jobster-design' !== $screen->base && 'options' !== $screen->base ) {
			if ( is_plugin_active( 'redux-framework/redux-framework.php' ) ) { ?>

				<div class="notice notice-warning is-dismissible">
					<p><?php _e( 'Redux is a plugin used by the theme to edit settings. If you are not editing the settings now, please disable this plugin because it reduces the performance of the site and we recommend activating it only when you edit the options settings or the design settings.', 'wpjobster' ); ?></p>
					<p><a class="button action" href="<?php echo admin_url( 'plugins.php' ); ?>"><?php _e( 'Go to Plugins', 'wpjobster' ); ?></a></p>
				</div>

			<?php }
		}
	}

	$path_plugin_url = WP_PLUGIN_DIR . '/redux-framework/redux-framework.php';

	if ( ! file_exists( $path_plugin_url ) ) { ?>

		<div class="notice notice-error is-dismissible">
			<p><?php _e( 'Redux is a plugin used by the theme to edit settings. Please install it and keep it disabled because it will automatically activate when you are in the settings editing pages and will automatically deactivate when you leave the settings editing pages.', 'wpjobster' ); ?></p>
			<p><a class="button action" href="<?php echo admin_url( 'plugins.php?page=tgmpa-install-plugins' ); ?>"><?php _e( 'Go to Required Plugins', 'wpjobster' ); ?></a></p>
		</div>

	<?php }

	if ( isset( $_GET['skip_redux_activation'] ) ) { ?>

		<div class="notice notice-error is-dismissible">
			<p><?php _e( 'Redux is a plugin used by the theme to edit settings. This plugin reduces site performance and pages will have a harder time loading. Please install it and keep it disabled because it will automatically activate when you are in the settings editing pages and will automatically deactivate when you leave the settings editing pages.', 'wpjobster' ); ?></p>
		</div>

	<?php }
}

// Black Friday 2024 Notice
add_action( 'admin_notices', 'wpj_bf2024_notice' );
function wpj_bf2024_notice() {
	if ( new DateTime() < new DateTime( "2024-12-02 23:59:00" ) ) { ?>
		<div class="notice notice-info is-dismissible"
		     style="background: #03ed96; border-left-color: #000; color: #000; font-size: 16px;">
			<img style="float: left; margin: 10px 8px 10px 0px; padding: 3px; max-height: 24px; background: #000; border-radius: 3px;"
			     src="<?php echo get_template_directory_uri() . '/assets/images/logo/logo-white.png'; ?>"/>
			<p style="font-size: 16px;"><strong>Black Friday &amp; Cyber Monday SALE!</strong> Save 35% on all new
				license purchases, upgrades and renewals. Discount <strong>automatically</strong> applied at checkout.
				<a class="button"
				   style="background: #000; color: #fff; border-color: #000; margin-left: 8px; font-size: 16px; line-height: 1.7;"
				   href="https://wpjobster.com/buy/?utm_source=wpdashboard&utm_medium=clientsite&utm_campaign=BF-2024"
				   target="_blank">Go!</a></p>
		</div>
	<?php }
}
