<?php

$design_structure = [
	'last_tab'                                                      => '-',
	'site_width'                                                    => 'dimensions',
	'site_page_transition'                                          => 'select',
	'site_page_transition_effect'                                   => 'select',
	'site_page_transition_effect_direction'                         => 'select',
	'site_page_transition_effect_color'                             => 'color',
	'loading_bar_style'                                             => 'border',
	'site_primary_color'                                            => 'color',
	'site_secondary_color'                                          => 'color',
	'site_tertiary_color'                                           => 'color',
	'text_selection_color'                                          => 'color',
	'text_selection_bgcolor'                                        => 'color',
	'header_style'                                                  => 'select',
	'header_in_grid'                                                => 'switch',
	'header_on_homepage'                                            => 'switch',
	'header_middle_border'                                          => 'switch',
	'header_middle_border_colour'                                   => 'border',
	'header_middle_border_front'                                    => 'switch',
	'header_middle_border_front_colour'                             => 'border',
	'header_bottom_border'                                          => 'switch',
	'header_bottom_border_colour'                                   => 'border',
	'header_bottom_border_front'                                    => 'switch',
	'header_bottom_border_front_colour'                             => 'border',
	'header_background_type'                                        => 'select',
	'header_background_image'                                       => 'media',
	'header_background_image_overlay'                               => 'box_shadow',
	'header_top_background'                                         => 'color',
	'header_bottom_background'                                      => 'color',
	'site_logo'                                                     => 'media',
	'site_logo_white'                                               => 'media',
	'logo_height'                                                   => 'dimensions',
	'logo_spacing'                                                  => 'spacing',
	'header_search_icon_name'                                       => 'text',
	'header_search_icon_colour'                                     => 'color',
	'header_search_placeholder_colour'                              => 'color',
	'header_search_text_colour'                                     => 'color',
	'header_search_bgcolour'                                        => 'color',
	'header_search_button_text_colour'                              => 'color',
	'header_search_button_text_hover_colour'                        => 'color',
	'header_search_button_bgcolour'                                 => 'color',
	'header_search_button_hover_bgcolour'                           => 'color',
	'header_search_border'                                          => 'border',
	'header_language_icon_name'                                     => 'text',
	'header_language_icon_colour'                                   => 'color',
	'header_language_icon_colour_hover'                             => 'color',
	'header_language_text_colour'                                   => 'color',
	'header_language_text_colour_hover'                             => 'color',
	'header_language_bg_colour'                                     => 'color',
	'header_language_bg_colour_hover'                               => 'color',
	'header_currency_icon_name'                                     => 'text',
	'header_currency_icon_colour'                                   => 'color',
	'header_currency_icon_colour_hover'                             => 'color',
	'header_currency_text_colour'                                   => 'color',
	'header_currency_text_colour_hover'                             => 'color',
	'header_currency_bg_colour'                                     => 'color',
	'header_currency_bg_colour_hover'                               => 'color',
	'header_message_icon_name'                                      => 'text',
	'header_message_icon_colour'                                    => 'color',
	'header_message_count_bg_colour'                                => 'color',
	'header_message_count_text_colour'                              => 'color',
	'header_notification_icon_name'                                 => 'text',
	'header_notification_icon_colour'                               => 'color',
	'header_notification_count_bg_colour'                           => 'color',
	'header_notification_count_text_colour'                         => 'color',
	'message_preview_panel_bg_colour'                               => 'color',
	'message_preview_panel_separator_colour'                        => 'color',
	'message_preview_panel_read_bg_colour'                          => 'color',
	'message_preview_panel_read_username_text_colour'               => 'color',
	'message_preview_panel_read_text_colour'                        => 'color',
	'message_preview_panel_read_date_text_colour'                   => 'color',
	'message_preview_panel_unread_bg_colour'                        => 'color',
	'message_preview_panel_unread_username_text_colour'             => 'color',
	'message_preview_panel_unread_text_colour'                      => 'color',
	'message_preview_panel_unread_date_text_colour'                 => 'color',
	'notification_preview_panel_bg_colour'                          => 'color',
	'notification_preview_panel_separator_colour'                   => 'color',
	'notification_preview_panel_read_bg_colour'                     => 'color',
	'notification_preview_panel_read_text_colour'                   => 'color',
	'notification_preview_panel_read_date_text_colour'              => 'color',
	'notification_preview_panel_unread_bg_colour'                   => 'color',
	'notification_preview_panel_unread_text_colour'                 => 'color',
	'notification_preview_panel_unread_date_text_colour'            => 'color',
	'balance_colour_options_header'                                 => 'color',
	'balance_hover_colour_options_header'                           => 'color',
	'balance_bg_colour_options_header'                              => 'color',
	'balance_bg_hover_colour_options_header'                        => 'color',
	'balance_border_header'                                         => 'border',
	'balance_border_radius_header'                                  => 'spacing',
	'balance_font_header'                                           => 'typography',
	'balance_padding_header'                                        => 'spacing',
	'enable_long_menu_arrows'                                       => 'switch',
	'enable_categories_menu_not_loggedin'                           => 'switch',
	'enable_categories_menu_not_loggedin_front_page'                => 'switch',
	'mainmenu_links_color'                                          => 'link_color',
	'mainmenu_links_color_front_page'                               => 'link_color',
	'menu_style'                                                    => 'select',
	'main_menu_submenu_items_alignment'                             => 'select',
	'mainmenu_submenu_bg_colour'                                    => 'color',
	'mainmenu_submenu_border'                                       => 'border',
	'mainmenu_submenu_box_shadow'                                   => 'box_shadow',
	'mainmenu_submenu_links_color'                                  => 'link_color',
	'dropdown_menu_style'                                           => 'select',
	'dropdown_bg_colour'                                            => 'color',
	'dropdown_border_colour'                                        => 'color',
	'dropdown_links_color'                                          => 'link_color',
	'dropdown_submenu_bg_colour'                                    => 'color',
	'dropdown_submenu_border'                                       => 'border',
	'dropdown_submenu_box_shadow'                                   => 'box_shadow',
	'dropdown_submenu_links_color'                                  => 'link_color',
	'secondarymenu_links_color'                                     => 'link_color',
	'secondarymenu_front_links_color'                               => 'link_color',
	'secondarymenu_style'                                           => 'select',
	'secondarymenu_submenu_bg_colour'                               => 'color',
	'secondarymenu_submenu_border'                                  => 'border',
	'secondarymenu_submenu_box_shadow'                              => 'box_shadow',
	'secondarymenu_submenu_links_color'                             => 'link_color',
	'enable_language_left_menu_not_loggedin'                        => 'switch',
	'enable_language_left_menu_loggedin'                            => 'switch',
	'enable_currency_left_menu_not_loggedin'                        => 'switch',
	'enable_currency_left_menu_loggedin'                            => 'switch',
	'enable_logout_left_menu_loggedin'                              => 'switch',
	'left_mobile_menu_image_options_header'                         => 'media',
	'left_mobile_menu_icon_options_header'                          => 'text',
	'left_mobile_menu_colour_icon_options_header'                   => 'color',
	'left_mobile_menu_front_colour_icon_options_header'             => 'color',
	'left_mobile_menu_bg_colour'                                    => 'color',
	'left_mobile_menu_links_color'                                  => 'link_color',
	'left_mobile_submenu_bg_colour'                                 => 'color',
	'left_mobile_submenu_links_color'                               => 'link_color',
	'enable_language_right_menu_not_loggedin'                       => 'switch',
	'enable_language_right_menu_loggedin'                           => 'switch',
	'enable_currency_right_menu_not_loggedin'                       => 'switch',
	'enable_currency_right_menu_loggedin'                           => 'switch',
	'enable_logout_right_menu_loggedin'                             => 'switch',
	'right_mobile_menu_image_options_header'                        => 'media',
	'right_mobile_menu_icon_options_header'                         => 'text',
	'right_mobile_menu_colour_icon_options_header'                  => 'color',
	'right_mobile_menu_front_colour_icon_options_header'            => 'color',
	'right_mobile_menu_bg_colour'                                   => 'color',
	'right_mobile_menu_links_color'                                 => 'link_color',
	'right_mobile_submenu_bg_colour'                                => 'color',
	'right_mobile_submenu_links_color'                              => 'link_color',
	'right_mobile_search_text_color'                                => 'color',
	'right_mobile_search_icon_color'                                => 'color',
	'right_mobile_search_border_bottom_color'                       => 'color',
	'login_colour_options_header'                                   => 'color',
	'login_hover_colour_options_header'                             => 'color',
	'login_bg_colour_options_header'                                => 'color',
	'login_bg_hover_colour_options_header'                          => 'color',
	'login_border_header'                                           => 'border',
	'login_border_radius_header'                                    => 'spacing',
	'login_padding_header'                                          => 'spacing',
	'login_margin_header'                                           => 'spacing',
	'login_front_colour_options_header'                             => 'color',
	'login_front_hover_colour_options_header'                       => 'color',
	'login_front_bg_colour_options_header'                          => 'color',
	'login_front_bg_hover_colour_options_header'                    => 'color',
	'login_front_border_header'                                     => 'border',
	'login_front_border_radius_header'                              => 'spacing',
	'login_front_padding_header'                                    => 'spacing',
	'login_front_margin_header'                                     => 'spacing',
	'register_colour_options_header'                                => 'color',
	'register_hover_colour_options_header'                          => 'color',
	'register_bg_colour_options_header'                             => 'color',
	'register_bg_hover_colour_options_header'                       => 'color',
	'register_border_header'                                        => 'border',
	'register_border_radius_header'                                 => 'spacing',
	'register_padding_header'                                       => 'spacing',
	'register_margin_header'                                        => 'spacing',
	'register_front_colour_options_header'                          => 'color',
	'register_front_hover_colour_options_header'                    => 'color',
	'register_front_bg_colour_options_header'                       => 'color',
	'register_front_bg_hover_colour_options_header'                 => 'color',
	'register_front_border_header'                                  => 'border',
	'register_front_border_radius_header'                           => 'spacing',
	'register_front_padding_header'                                 => 'spacing',
	'register_front_margin_header'                                  => 'spacing',
	'footer_in_grid'                                                => 'switch',
	'select_number_cols'                                            => 'select',
	'footer_columns_same_row'                                       => 'switch',
	'copyright_text'                                                => 'text',
	'android_app_image'                                             => 'media',
	'android_app_link'                                              => 'text',
	'iphone_app_image'                                              => 'media',
	'iphone_app_link'                                               => 'text',
	'footer_top_border'                                             => 'switch',
	'footer_top_border_colour'                                      => 'border',
	'footer_bottom_border_colour'                                   => 'border',
	'footer_background_type'                                        => 'select',
	'footer_background_image'                                       => 'media',
	'footer_background_image_overlay'                               => 'box_shadow',
	'footer_top_background'                                         => 'color',
	'footer_bottom_background'                                      => 'color',
	'footer_logo_image'                                             => 'media',
	'footer_logo_height'                                            => 'dimensions',
	'footer_logo_spacing'                                           => 'spacing',
	'logo_grayscale_enable'                                         => 'switch',
	'disable_footer_cards'                                          => 'switch',
	'image_demo'                                                    => 'repeater',
	'social_media_list'                                             => 'repeater',
	'social_media_colour_options_footer'                            => 'color',
	'social_media_hover_colour_options_footer'                      => 'color',
	'social_media_bg_colour_options_footer'                         => 'color',
	'social_media_bg_hover_colour_options_footer'                   => 'color',
	'social_media_border_footer'                                    => 'border',
	'footer_currency_icon_name'                                     => 'text',
	'footer_currency_icon_colour'                                   => 'color',
	'footer_currency_icon_colour_hover'                             => 'color',
	'footer_currency_text_colour'                                   => 'color',
	'footer_currency_text_colour_hover'                             => 'color',
	'footer_currency_bg_colour'                                     => 'color',
	'footer_currency_bg_colour_hover'                               => 'color',
	'currency_select_border_footer'                                 => 'border',
	'scroll_to_top_enable'                                          => 'switch',
	'scroll_to_top_background'                                      => 'color',
	'scroll_icon_color'                                             => 'link_color',
	'scroll_to_top_border'                                          => 'border',
	'site-font-family-settings'                                     => 'typography',
	'links-colour'                                                  => 'link_color',
	'h1-font-settings'                                              => 'typography',
	'h2-font-settings'                                              => 'typography',
	'h3-font-settings'                                              => 'typography',
	'h4-font-settings'                                              => 'typography',
	'h5-font-settings'                                              => 'typography',
	'h6-font-settings'                                              => 'typography',
	'header-font-settings'                                          => 'typography',
	'header-menus-settings'                                         => 'typography',
	'footer_links_color'                                            => 'link_color',
	'footer-font-settings'                                          => 'typography',
	'footer-titles-settings'                                        => 'typography',
	'footer-menus-settings'                                         => 'typography',
	'upload_button_bg_colour'                                       => 'color',
	'upload_button_border_colour'                                   => 'color',
	'upload_button_text_colour'                                     => 'color',
	'upload_button_icon_name'                                       => 'media',
	'upload_button_icon_bg_colour'                                  => 'color',
	'user_account_load_more_button_image'                           => 'media',
	'user_account_load_more_button_bg_colour'                       => 'color',
	'user_account_load_more_button_hover_bg_colour'                 => 'color',
	'user_account_load_more_button_text_colour'                     => 'color',
	'user_account_load_more_button_text_hover_colour'               => 'color',
	'user_account_load_more_button_border'                          => 'border',
	'user_account_load_more_button_border_radius'                   => 'spacing',
	'user_account_load_more_button_font'                            => 'typography',
	'user_account_load_more_button_padding'                         => 'spacing',
	'user_account_load_more_button_margin'                          => 'spacing',
	'user_account_pagination_page_numbers_font'                     => 'typography',
	'user_account_pagination_page_numbers_dimensions'               => 'dimensions',
	'user_account_pagination_prev_next_padding'                     => 'spacing',
	'user_account_pagination_page_numbers_border_radius'            => 'spacing',
	'user_account_pagination_prev_next_border_radius'               => 'spacing',
	'user_account_pagination_page_numbers_bg_colour'                => 'color',
	'user_account_pagination_page_numbers_hover_bg_colour'          => 'color',
	'user_account_pagination_page_numbers_text_colour'              => 'color',
	'user_account_pagination_page_numbers_text_hover_colour'        => 'color',
	'user_account_pagination_page_numbers_border'                   => 'border',
	'user_account_pagination_prev_page_number_bg_colour'            => 'color',
	'user_account_pagination_prev_page_number_hover_bg_colour'      => 'color',
	'user_account_pagination_prev_page_number_text_colour'          => 'color',
	'user_account_pagination_prev_page_number_text_hover_colour'    => 'color',
	'user_account_pagination_prev_page_number_border'               => 'border',
	'user_account_pagination_current_page_number_bg_colour'         => 'color',
	'user_account_pagination_current_page_number_hover_bg_colour'   => 'color',
	'user_account_pagination_current_page_number_text_colour'       => 'color',
	'user_account_pagination_current_page_number_text_hover_colour' => 'color',
	'user_account_pagination_current_page_number_border'            => 'border',
	'user_account_pagination_next_page_number_bg_colour'            => 'color',
	'user_account_pagination_next_page_number_hover_bg_colour'      => 'color',
	'user_account_pagination_next_page_number_text_colour'          => 'color',
	'user_account_pagination_next_page_number_text_hover_colour'    => 'color',
	'user_account_pagination_next_page_number_border'               => 'border',
	'no_image_icon_options_blog'                                    => 'media',
	'no_image_icon_options_news'                                    => 'media',
	'blog_date_bg_colour'                                           => 'color',
	'blog_date_hover_bg_colour'                                     => 'color',
	'blog_date_text_colour'                                         => 'color',
	'blog_date_text_hover_colour'                                   => 'color',
	'blog_date_border'                                              => 'border',
	'blog_date_border_radius'                                       => 'spacing',
	'blog_date_font'                                                => 'typography',
	'blog_date_padding'                                             => 'spacing',
	'blog_date_margin'                                              => 'spacing',
	'blog_tags_bg_colour'                                           => 'color',
	'blog_tags_hover_bg_colour'                                     => 'color',
	'blog_tags_text_colour'                                         => 'color',
	'blog_tags_text_hover_colour'                                   => 'color',
	'blog_tags_border'                                              => 'border',
	'blog_tags_border_radius'                                       => 'spacing',
	'blog_tags_font'                                                => 'typography',
	'blog_tags_padding'                                             => 'spacing',
	'blog_tags_margin'                                              => 'spacing',
	'blog_categories_bg_colour'                                     => 'color',
	'blog_categories_hover_bg_colour'                               => 'color',
	'blog_categories_text_colour'                                   => 'color',
	'blog_categories_text_hover_colour'                             => 'color',
	'blog_categories_border'                                        => 'border',
	'blog_categories_border_radius'                                 => 'spacing',
	'blog_categories_font'                                          => 'typography',
	'blog_categories_padding'                                       => 'spacing',
	'blog_categories_margin'                                        => 'spacing',
	'blog_share_bg_colour'                                          => 'color',
	'blog_share_hover_bg_colour'                                    => 'color',
	'blog_share_icon_colour'                                        => 'color',
	'blog_share_icon_hover_colour'                                  => 'color',
	'blog_share_icon_size'                                          => 'typography',
	'blog_share_border'                                             => 'border',
	'blog_share_border_radius'                                      => 'spacing',
	'blog_share_padding'                                            => 'spacing',
	'blog_share_margin'                                             => 'spacing',
	'messages_scroll_down_enable'                                   => 'switch',
	'messages_scroll_down_button_icon'                              => 'text',
	'messages_scroll_down_button_icon_bg_colour'                    => 'color',
	'messages_scroll_down_button_icon_bg_hover_colour'              => 'color',
	'messages_scroll_down_button_icon_colour_colour'                => 'color',
	'messages_scroll_down_button_icon_hover_colour_colour'          => 'color',
	'messages_scroll_down_button_icon_border'                       => 'border',
	'messages_scroll_down_button_icon_border_radius'                => 'spacing',
	'messages_scroll_down_button_icon_font'                         => 'typography',
	'messages_scroll_down_button_icon_dimensions'                   => 'dimensions',
	'no_image_icon_options_job'                                     => 'media',
	'enable_video_icon_cards'                                       => 'switch',
	'enable_rating_count_cards'                                     => 'switch',
	'cards_style'                                                   => 'select',
	'border_over_box_shadow'                                        => 'switch',
	'featured_simple_icon_options_job'                              => 'media',
	'lets_meet_simple_icon_options_job'                             => 'media',
	'instant_delivery_simple_icon_options_job'                      => 'media',
	'lets_meet_rich_icon_options_job'                               => 'text',
	'instant_delivery_rich_icon_options_job'                        => 'text',
	'wpjobster_user_level_for_thumbnails'                           => 'switch',
	'rating_slider_after_title'                                     => 'switch',
	'level1_card_icon_options_user'                                 => 'media',
	'level2_card_icon_options_user'                                 => 'media',
	'level3_card_icon_options_user'                                 => 'media',
	'distance_slider_icon_options_job'                              => 'text',
	'lets_meet_slider_icon_options_job'                             => 'text',
	'instant_delivery_slider_icon_options_job'                      => 'text',
	'featured_slider_icon_options_job'                              => 'text',
	'favorites_slider_icon_options_job'                             => 'text',
	'job_popular_categories_bg_colour'                              => 'color',
	'job_popular_categories_hover_bg_colour'                        => 'color',
	'job_popular_categories_text_colour'                            => 'color',
	'job_popular_categories_text_hover_colour'                      => 'color',
	'job_popular_categories_border'                                 => 'border',
	'job_popular_categories_border_radius'                          => 'spacing',
	'job_popular_categories_font'                                   => 'typography',
	'job_popular_categories_padding'                                => 'spacing',
	'job_popular_categories_margin'                                 => 'spacing',
	'job-description-typography-settings'                           => 'typography',
	'job_instructions_bg_colour'                                    => 'color',
	'job_instructions_border_colour'                                => 'color',
	'job_instructions_arrow_colour'                                 => 'box_shadow',
	'job_instructions_text_colour'                                  => 'color',
	'job_instructions_box_spacing'                                  => 'spacing',
	'job_instructions_box_icon'                                     => 'media',
	'job_subcategories_bg_colour'                                   => 'color',
	'job_subcategories_hover_bg_colour'                             => 'color',
	'job_subcategories_text_colour'                                 => 'color',
	'job_subcategories_text_hover_colour'                           => 'color',
	'job_subcategories_border'                                      => 'border',
	'job_subcategories_border_radius'                               => 'spacing',
	'job_subcategories_font'                                        => 'typography',
	'job_subcategories_padding'                                     => 'spacing',
	'job_subcategories_margin'                                      => 'spacing',
	'lets_meet_rich_icon_options_request'                           => 'media',
	'request_instructions_bg_colour'                                => 'color',
	'request_instructions_border_colour'                            => 'color',
	'request_instructions_arrow_colour'                             => 'box_shadow',
	'request_instructions_text_colour'                              => 'color',
	'request_instructions_box_spacing'                              => 'spacing',
	'request_instructions_box_icon'                                 => 'media',
	'request_subcategories_bg_colour'                               => 'color',
	'request_subcategories_hover_bg_colour'                         => 'color',
	'request_subcategories_text_colour'                             => 'color',
	'request_subcategories_text_hover_colour'                       => 'color',
	'request_subcategories_border'                                  => 'border',
	'request_subcategories_border_radius'                           => 'spacing',
	'request_subcategories_font'                                    => 'typography',
	'request_subcategories_padding'                                 => 'spacing',
	'request_subcategories_margin'                                  => 'spacing',
	'no_image_icon_options_user'                                    => 'media',
	'email_verified_icon_options_user'                              => 'text',
	'level0_icon_options_user'                                      => 'media',
	'level1_icon_options_user'                                      => 'media',
	'level2_icon_options_user'                                      => 'media',
	'level3_icon_options_user'                                      => 'media',
	'user_account_graph_bg_colour'                                  => 'color',
	'user_account_graph_border'                                     => 'border',
	'user_account_labels_font'                                      => 'typography',
	'user_account_numbers_font'                                     => 'typography',
	'user_account_icon_name'                                        => 'text',
	'user_account_icon_font_size'                                   => 'typography',
	'user_account_icon_colour'                                      => 'link_color',
	'user_account_sidebar_style'                                    => 'select',
	'user_account_sidebar_bg_colour'                                => 'color',
	'user_account_sidebar_border'                                   => 'border',
	'user_account_sidebar_separators'                               => 'border',
	'user_account_sidebar_border_radius'                            => 'spacing',
	'user_account_sidebar_header_spacing'                           => 'spacing',
	'user_account_sidebar_header_username_font'                     => 'typography',
	'user_account_sidebar_header_rating_font'                       => 'typography',
	'user_account_sidebar_body_spacing'                             => 'spacing',
	'user_account_sidebar_body_items_spacing'                       => 'spacing',
	'user_account_sidebar_body_items_title_font'                    => 'typography',
	'user_account_sidebar_body_items_value_font'                    => 'typography',
	'user_account_sidebar_progress_bar_colour'                      => 'color',
	'user_account_sidebar_progress_bar_active_colour'               => 'color',
	'chat_sidebar_icon_border_style'                                => 'border',
	'chat_sidebar_icon_bg_color'                                    => 'color',
	'chat_sidebar_icon_bg_hover_color'                              => 'color',
	'chat_sidebar_icon_dimensions'                                  => 'dimensions',
	'chat_sidebar_icon_name'                                        => 'text',
	'chat_sidebar_icon_color'                                       => 'color',
	'chat_sidebar_icon_hover_color'                                 => 'color',
	'chat_sidebar_icon_spacing'                                     => 'spacing',
	'chat_responsive_sidebar_head_bg_color'                         => 'color',
	'chat_responsive_sidebar_head_bg_hover_color'                   => 'color',
	'chat_responsive_sidebar_head_text_color'                       => 'link_color',
	'chat_sidebar_style'                                            => 'select',
	'chat_sidebar_bg_colour'                                        => 'color',
	'chat_sidebar_bg_item_color'                                    => 'color',
	'chat_sidebar_bg_item_hover_color'                              => 'color',
	'chat_sidebar_text_color'                                       => 'link_color',
	'chat_header_search_icon_name'                                  => 'text',
	'chat_search_input_bgcolor'                                     => 'color',
	'chat_search_input_bgcolor_hover'                               => 'color',
	'chat_search_input_color'                                       => 'color',
	'chat_box_head_bg_colour'                                       => 'color',
	'chat_box_head_bg_hover_color'                                  => 'color',
	'chat_box_head_unread_bg_color'                                 => 'color',
	'chat_box_head_unread_text_color'                               => 'color',
	'chat_box_head_unread_button_color_hover'                       => 'color',
	'chat_box_head_buttons_color'                                   => 'link_color',
	'chat_box_head_user_name_color'                                 => 'color',
	'chat_box_head_user_status_color'                               => 'color',
	'chat_box_body_bg_color'                                        => 'color',
	'chat_box_body_send_bg_color'                                   => 'color',
	'chat_box_body_send_text_color'                                 => 'color',
	'chat_box_body_received_bg_color'                               => 'color',
	'chat_box_body_received_text_color'                             => 'color',
	'chat_box_footer_bg_color'                                      => 'color',
	'chat_box_footer_text_color'                                    => 'color',
	'chat_box_footer_textarea_bg_color'                             => 'color',
	'chat_box_footer_buttons_color'                                 => 'link_color',
	'chat_box_footer_message_option_bg_color'                       => 'color',
	'chat_box_footer_message_option_btn_bg_color'                   => 'color',
	'chat_box_footer_message_option_btn_bg_hover_color'             => 'color',
	'chat_box_footer_message_option_btn_text_color'                 => 'link_color',
	'enable_lazy_loading'                                           => 'switch',
	'enable_js_defer'                                               => 'switch',
	'enable_css_preload'                                            => 'switch'
];

update_option( 'jobster_design_structure', $design_structure );

$settings_structure = [
	'last_tab'                                           => '-',
	'wpjobster_enable_beta_versions'                     => 'switch',
	'wpjobster_license_key'                              => 'text',
	'openexchangerates_appid'                            => 'text',
	'wpjobster_google_maps_api_key'                      => 'text',
	'wpjobster_tomtom_search_api_key'                    => 'text',
	'wpjobster_ip_key_db'                                => 'text',
	'wpjobster_recaptcha_api_key'                        => 'text',
	'wpjobster_recaptcha_api_secret'                     => 'text',
	'wpjobster_jobs_order'                               => 'select',
	'wpjobster_default_sort_by_job'                      => 'select',
	'wpjobster_default_sort_by_request'                  => 'select',
	'wpjobster_default_sort_by_user'                     => 'select',
	'wpj_posts_load_type'                                => 'select',
	'wpjobster_enable_auto-load'                         => 'switch',
	'wpjobster_max_attachment_upload_size'               => 'text',
	'wpjobster_allowed_mime_types'                       => 'textarea',
	'wpjobster_html5_geolocation_enable'                 => 'switch',
	'wpj_locations_radius_default'                       => 'text',
	'wpjobster_locations_unit'                           => 'select',
	'wpjobster_location_api_provider'                    => 'select',
	'wpjobster_location_restrict_type'                   => 'select',
	'wpjobster_location_restrict_country'                => 'text',
	'wpjobster_location_fields'                          => 'text',
	'wpjobster_admin_approve_job'                        => 'switch',
	'wpjobster_preferred_image_uploader'                 => 'select',
	'wpjobster_checkout_extra_enabled'                   => 'switch',
	'wpjobster_job_attachments_enabled'                  => 'switch',
	'wpjobster_enable_job_views'                         => 'switch',
	'wpjobster_job_view_interval_number'                 => 'text',
	'wpjobster_job_view_interval_type'                   => 'select',
	'wpjobster_enable_review_work_samples'               => 'switch',
	'wpjobster_max_review_work_samples'                  => 'text',
	'wpjobster_job_share_promt_enabled'                  => 'switch',
	'wpjobster_display_job_empty_categories'             => 'switch',
	'wpjobster_display_job_category_description'         => 'select',
	'wpjobster_enable_job_cover'                         => 'switch',
	'wpjobster_max_job_cover_upload_size'                => 'text',
	'wpjobster_min_cover_img_upload_width'               => 'text',
	'wpjobster_min_cover_img_upload_height'              => 'text',
	'wpjobster_mandatory_pics_for_jbs'                   => 'switch',
	'wpjobster_default_nr_of_pics'                       => 'text',
	'wpjobster_max_img_upload_size'                      => 'text',
	'wpjobster_min_img_upload_width'                     => 'text',
	'wpjobster_min_img_upload_height'                    => 'text',
	'wpjobster_audio'                                    => 'switch',
	'wpjobster_mandatory_audio_for_jbs'                  => 'switch',
	'wpjobster_max_uploads_audio'                        => 'text',
	'wpjobster_max_audio_upload_size'                    => 'text',
	'wpjobster_lets_meet'                                => 'switch',
	'wpjobster_location'                                 => 'switch',
	'wpjobster_location_distance'                        => 'switch',
	'wpjobster_location_display_map'                     => 'switch',
	'wpjobster_location_display_map_user_choice'         => 'switch',
	'wpjobster_enable_delivery_time'                     => 'switch',
	'wpjobster_job_max_delivery_days'                    => 'text',
	'wpjobster_enable_instant_delivery'                  => 'switch',
	'wpjobster_enable_shipping'                          => 'switch',
	'wpjobster_job_description_type'                     => 'select',
	'wpjobster_view_more_description_enabled'            => 'switch',
	'wpjobster_buyer_instructions_job_enabled'           => 'switch',
	'wpjobster_job_instructions_responsive_enabled'      => 'switch',
	'wpjobster_tos_type'                                 => 'select',
	'wpjobster_job_min_rating'                           => 'text',
	'wpjobster_job_author_reviews_number'                => 'text',
	'wpjobster_admin_approve_request'                    => 'switch',
	'wpjobster_request_instructions_responsive_enabled'  => 'switch',
	'wpjobster_display_request_empty_categories'         => 'switch',
	'wpjobster_display_request_multiple_categories'      => 'switch',
	'wpjobster_display_request_category_description'     => 'select',
	'wpjobster_request_budget'                           => 'switch',
	'wpjobster_request_max_deliv'                        => 'switch',
	'wpjobster_request_max_delivery_days'                => 'text',
	'wpjobster_request_deadline'                         => 'switch',
	'wpjobster_request_date'                             => 'switch',
	'wpjobster_request_lets_meet'                        => 'switch',
	'wpjobster_request_location'                         => 'switch',
	'wpjobster_request_pick_up_location'                 => 'switch',
	'wpjobster_request_drop_off_location'                => 'switch',
	'wpjobster_request_location_display_map'             => 'switch',
	'wpjobster_request_file_upload'                      => 'switch',
	'wpjobster_display_name_publicly'                    => 'select',
	'wpjobster_wysiwyg_for_profile'                      => 'switch',
	'wpjobster_enable_last_seen'                         => 'switch',
	'wpjobster_enable_user_social_media'                 => 'switch',
	'wpjobster_enable_jobs_section_on_user_profile'      => 'switch',
	'wpjobster_enable_user_vat_id'                       => 'switch',
	'wpjobster_enable_user_transactions_export'          => 'switch',
	'wpjobster_en_user_online_status'                    => 'select',
	'wpjobster_enable_user_cover'                        => 'switch',
	'wpjobster_max_user_cover_upload_size'               => 'text',
	'wpjobster_max_user_avatar_upload_size'              => 'text',
	'wpjobster_max_user_skill_upload_size'               => 'text',
	'wpjobster_enable_user_profile_portfolio'            => 'switch',
	'wpjobster_enable_portfolio_video_upload'            => 'switch',
	'wpjobster_profile_default_nr_of_pics'               => 'text',
	'wpjobster_profile_max_img_upload_size'              => 'text',
	'wpjobster_profile_min_img_upload_width'             => 'text',
	'wpjobster_profile_min_img_upload_height'            => 'text',
	'wpjobster_en_country_flags'                         => 'switch',
	'wpjobster_phone_country_select'                     => 'select',
	'wpjobster_enable_country_select'                    => 'switch',
	'wpjobster_user_time_zone'                           => 'select',
	'wpjobster_enable_user_stats'                        => 'switch',
	'wpjobster_enable_user_charts'                       => 'switch',
	'wpjobster_enable_phone_number'                      => 'switch',
	'wpjobster_phone_number_mandatory'                   => 'switch',
	'wpjobster_enable_user_company'                      => 'switch',
	'wpjobster_enable_user_register_reCaptcha'           => 'switch',
	'wpjobster_enable_user_login_reCaptcha'              => 'switch',
	'wpjobster_enable_user_2fa'                          => 'switch',
	'wpjobster_enable_login_hints'                       => 'switch',
	'wpjobster_register_tos_and_privacy'                 => 'select',
	'wpjobster_user_min_rating'                          => 'text',
	'wpjobster_enable_custom_extras'                     => 'switch',
	'wpjobster_enable_custom_offers'                     => 'switch',
	'wpjobster_active_job_cutom_offer'                   => 'switch',
	'wpjobster_seller_order_rejection_enable'            => 'switch',
	'wpjobster_seller_order_unresponsive_label'          => 'switch',
	'wpjobster_seller_order_rejection_number'            => 'text',
	'wpjobster_pending_jobs_days'                        => 'text',
	'wpjobster_max_time_to_wait'                         => 'text',
	'wpjobster_clearing_period'                          => 'text',
	'wpjobster_number_of_modifications'                  => 'text',
	'wpjobster_number_of_cancellations'                  => 'text',
	'wpjobster_set_time_direction'                       => 'select',
	'wpjobster_stop_transaction_clock'                   => 'select',
	'wpjobster_enable_user_account_search'               => 'switch',
	'wpjobster_default_advanced_search'                  => 'select',
	'wpjobster_enable_jobs_for_advanced_search'          => 'switch',
	'wpjobster_include_job_undefined_delivery'           => 'select',
	'wpjobster_enable_requests_for_advanced_search'      => 'switch',
	'wpjobster_enable_search_request_date'               => 'switch',
	'wpjobster_include_request_undefined_date'           => 'select',
	'wpjobster_include_request_undefined_budget'         => 'select',
	'wpjobster_include_request_undefined_delivery'       => 'select',
	'wpjobster_enable_users_for_advanced_search'         => 'switch',
	'wpjobster_enable_search_user_location'              => 'switch',
	'wpjobster_default_level_nr'                         => 'text',
	'wpjobster_auto_upgrade_user_level'                  => 'switch',
	'wpjobster_auto_downgrade_user_level'                => 'switch',
	'wpjobster_level0_recheck_interval'                  => 'text',
	'wpjobster_level1_recheck_interval'                  => 'text',
	'wpjobster_level2_recheck_interval'                  => 'text',
	'wpjobster_level1_min'                               => 'text',
	'wpjobster_level2_min'                               => 'text',
	'wpjobster_level1_upgrade_rating'                    => 'text',
	'wpjobster_level2_upgrade_rating'                    => 'text',
	'wpjobster_allow_comments_on_blog_news_pages'        => 'switch',
	'wpjobster_report_jobs_enabled'                      => 'switch',
	'wpjobster_report_requests_enabled'                  => 'switch',
	'wpjobster_report_users_enabled'                     => 'switch',
	'wpjobster_report_messages_enabled'                  => 'switch',
	'wpjobster_disable_filters'                          => 'switch',
	'wpjobster_blacklisted_words_pm'                     => 'textarea',
	'wpj_filter_words1'                                  => 'select',
	'wpjobster_blacklisted_words_pm_err'                 => 'textarea',
	'wpjobster_blacklisted_words2_pm'                    => 'textarea',
	'wpj_filter_words2'                                  => 'select',
	'wpjobster_blacklisted_words2_pm_err'                => 'textarea',
	'wpjobster_blacklisted_words3_pm'                    => 'textarea',
	'wpj_filter_words3'                                  => 'select',
	'wpjobster_blacklisted_words3_pm_err'                => 'textarea',
	'wpjobster_blacklisted_email'                        => 'textarea',
	'wpj_filter_emails'                                  => 'select',
	'wpjobster_blacklisted_prefixes_pm'                  => 'textarea',
	'wpj_filter_phone_numbers'                           => 'select',
	'wpjobster_blacklisted_phone'                        => 'textarea',
	'wpj_job_title_character_limits'                     => 'slider',
	'wpj_job_description_character_limits'               => 'slider',
	'wpj_job_package_title_character_limits'             => 'slider',
	'wpj_job_package_description_character_limits'       => 'slider',
	'wpj_job_instructions_character_limits'              => 'slider',
	'wpj_job_extra_description_character_limits'         => 'slider',
	'wpj_request_title_character_limits'                 => 'slider',
	'wpj_request_description_character_limits'           => 'slider',
	'wpj_feedback_message_character_limits'              => 'slider',
	'wpj_custom_extra_character_limits'                  => 'slider',
	'wpj_private_message_character_limits'               => 'slider',
	'wpjobster_fees_for_subscriber_enabled'              => 'switch',
	'wpjobster_subscription_fees_level0'                 => 'text',
	'wpjobster_subscription_fees_level1'                 => 'text',
	'wpjobster_subscription_fees_level2'                 => 'text',
	'wpjobster_subscription_fees_level3'                 => 'text',
	'wpjobster_get_level0_packages'                      => 'switch',
	'wpjobster_get_level1_packages'                      => 'switch',
	'wpjobster_get_level2_packages'                      => 'switch',
	'wpjobster_get_level3_packages'                      => 'switch',
	'wpjobster_subscription_packages_level0'             => 'switch',
	'wpjobster_subscription_packages_level1'             => 'switch',
	'wpjobster_subscription_packages_level2'             => 'switch',
	'wpjobster_subscription_packages_level3'             => 'switch',
	'wpjobster_tips_enabled'                             => 'switch',
	'wpjobster_get_level0_tips'                          => 'switch',
	'wpjobster_get_level1_tips'                          => 'switch',
	'wpjobster_get_level2_tips'                          => 'switch',
	'wpjobster_get_level3_tips'                          => 'switch',
	'wpjobster_subscription_tips_level0'                 => 'switch',
	'wpjobster_subscription_tips_level1'                 => 'switch',
	'wpjobster_subscription_tips_level2'                 => 'switch',
	'wpjobster_subscription_tips_level3'                 => 'switch',
	'wpjobster_enable_extra'                             => 'switch',
	'wpjobster_get_level0_extras'                        => 'text',
	'wpjobster_get_level1_extras'                        => 'text',
	'wpjobster_get_level2_extras'                        => 'text',
	'wpjobster_get_level3_extras'                        => 'text',
	'wpjobster_subscription_noof_extras_enabled'         => 'switch',
	'wpjobster_subscription_noof_extras_level0'          => 'text',
	'wpjobster_subscription_noof_extras_level1'          => 'text',
	'wpjobster_subscription_noof_extras_level2'          => 'text',
	'wpjobster_subscription_noof_extras_level3'          => 'text',
	'wpjobster_enable_extra_fast_delivery'               => 'switch',
	'wpjobster_get_level0_fast_delivery_multiples'       => 'text',
	'wpjobster_get_level1_fast_delivery_multiples'       => 'text',
	'wpjobster_get_level2_fast_delivery_multiples'       => 'text',
	'wpjobster_get_level3_fast_delivery_multiples'       => 'text',
	'wpjobster_subscription_ex_fast_delivery_enabled'    => 'switch',
	'wpjobster_subscription_fast_del_multiples_level0'   => 'text',
	'wpjobster_subscription_fast_del_multiples_level1'   => 'text',
	'wpjobster_subscription_fast_del_multiples_level2'   => 'text',
	'wpjobster_subscription_fast_del_multiples_level3'   => 'text',
	'wpjobster_enable_active_jobs'                       => 'switch',
	'wpjobster_get_level0_active_jobs'                   => 'text',
	'wpjobster_get_level1_active_jobs'                   => 'text',
	'wpjobster_get_level2_active_jobs'                   => 'text',
	'wpjobster_get_level3_active_jobs'                   => 'text',
	'wpjobster_subscription_active_jobs_enabled'         => 'switch',
	'wpjobster_subscription_active_jobs_level0'          => 'text',
	'wpjobster_subscription_active_jobs_level1'          => 'text',
	'wpjobster_subscription_active_jobs_level2'          => 'text',
	'wpjobster_subscription_active_jobs_level3'          => 'text',
	'wpjobster_enable_extra_additional_revision'         => 'switch',
	'wpjobster_get_level0_add_rev_multiples'             => 'text',
	'wpjobster_get_level1_add_rev_multiples'             => 'text',
	'wpjobster_get_level2_add_rev_multiples'             => 'text',
	'wpjobster_get_level3_add_rev_multiples'             => 'text',
	'wpjobster_subscription_additional_revision_enabled' => 'switch',
	'wpjobster_subscription_add_rev_multiples_level0'    => 'text',
	'wpjobster_subscription_add_rev_multiples_level1'    => 'text',
	'wpjobster_subscription_add_rev_multiples_level2'    => 'text',
	'wpjobster_subscription_add_rev_multiples_level3'    => 'text',
	'wpjobster_enable_multiples'                         => 'switch',
	'wpjobster_get_level0_jobmultiples'                  => 'text',
	'wpjobster_get_level1_jobmultiples'                  => 'text',
	'wpjobster_get_level2_jobmultiples'                  => 'text',
	'wpjobster_get_level3_jobmultiples'                  => 'text',
	'wpjobster_subscription_job_multiples_enabled'       => 'switch',
	'wpjobster_subscription_job_multiples_level0'        => 'text',
	'wpjobster_subscription_job_multiples_level1'        => 'text',
	'wpjobster_subscription_job_multiples_level2'        => 'text',
	'wpjobster_subscription_job_multiples_level3'        => 'text',
	'wpjobster_enable_extra_multiples'                   => 'switch',
	'wpjobster_get_level0_extramultiples'                => 'text',
	'wpjobster_get_level1_extramultiples'                => 'text',
	'wpjobster_get_level2_extramultiples'                => 'text',
	'wpjobster_get_level3_extramultiples'                => 'text',
	'wpjobster_subscription_extra_multiples_enabled'     => 'switch',
	'wpjobster_subscription_extra_multiples_level0'      => 'text',
	'wpjobster_subscription_extra_multiples_level1'      => 'text',
	'wpjobster_subscription_extra_multiples_level2'      => 'text',
	'wpjobster_subscription_extra_multiples_level3'      => 'text',
	'wpjobster_enable_video_multiples'                   => 'switch',
	'wpjobster_get_level0_vds'                           => 'text',
	'wpjobster_get_level1_vds'                           => 'text',
	'wpjobster_get_level2_vds'                           => 'text',
	'wpjobster_get_level3_vds'                           => 'text',
	'wpjobster_subscription_video_multiples_enabled'     => 'switch',
	'wpjobster_subscription_video_multiples_level0'      => 'text',
	'wpjobster_subscription_video_multiples_level1'      => 'text',
	'wpjobster_subscription_video_multiples_level2'      => 'text',
	'wpjobster_subscription_video_multiples_level3'      => 'text',
	'wpjobster_subscription_profile_label_enabled'       => 'switch',
	'wpjobster_subscription_profile_label_level0'        => 'text',
	'wpjobster_subscription_profile_label_level1'        => 'text',
	'wpjobster_subscription_profile_label_level2'        => 'text',
	'wpjobster_subscription_profile_label_level3'        => 'text',
	'wpjobster_subscription_icon_url_enabled'            => 'switch',
	'wpjobster_subscription_icon_url_level0'             => 'text',
	'wpjobster_subscription_icon_url_level1'             => 'text',
	'wpjobster_subscription_icon_url_level2'             => 'text',
	'wpjobster_subscription_icon_url_level3'             => 'text',
	'wpjobster_credits_enable'                           => 'switch',
	'wpjobster_currency_position'                        => 'select',
	'wpjobster_currency_symbol_space'                    => 'select',
	'wpjobster_decimals'                                 => 'select',
	'wpjobster_decimal_sum_separator'                    => 'select',
	'wpjobster_thousands_sum_separator'                  => 'select',
	'wpjobster_replace_zero_with_free'                   => 'select',
	'add-new-currency'                                   => 'repeater',
	'wpjobster_enable_open_exchange_api_rate'            => 'switch',
	'wpjobster_exchange_drop_percent'                    => 'text',
	'wpjobster_enable_site_fee'                          => 'select',
	'wpjobster_percent_fee_taken'                        => 'text',
	'wpjobster_solid_fee_taken'                          => 'text',
	'flexible-fee-settings'                              => 'repeater',
	'wpjobster_enable_buyer_processing_fees'             => 'select',
	'wpjobster_buyer_processing_fees_percent'            => 'text',
	'wpjobster_buyer_processing_fees'                    => 'text',
	'wpjobster_enable_refund_buyer_processing_fees'      => 'switch',
	'wpjobster_enable_site_tax'                          => 'switch',
	'wpjobster_tax_percent'                              => 'text',
	'wpjobster_tax_over'                                 => 'select',
	'wpjobster_enable_refund_tax'                        => 'switch',
	'country-tax-settings'                               => 'repeater',
	'category-tax-settings'                              => 'repeater',
	'wpj_package_amount_price_limits'                    => 'slider',
	'wpj_custom_offer_amount_price_limits'               => 'slider',
	'wpj_job_price_limits_level0'                        => 'slider',
	'wpj_job_price_limits_level1'                        => 'slider',
	'wpj_job_price_limits_level2'                        => 'slider',
	'wpj_job_price_limits_level3'                        => 'slider',
	'wpj_job_extra_price_limits_level0'                  => 'slider',
	'wpj_job_extra_price_limits_level1'                  => 'slider',
	'wpj_job_extra_price_limits_level2'                  => 'slider',
	'wpj_job_extra_price_limits_level3'                  => 'slider',
	'wpj_custom_extra_price_limits_level0'               => 'slider',
	'wpj_custom_extra_price_limits_level1'               => 'slider',
	'wpj_custom_extra_price_limits_level2'               => 'slider',
	'wpj_custom_extra_price_limits_level3'               => 'slider',
	'wpj_job_price_limits_subscription_level0'           => 'slider',
	'wpj_job_price_limits_subscription_level1'           => 'slider',
	'wpj_job_price_limits_subscription_level2'           => 'slider',
	'wpj_job_price_limits_subscription_level3'           => 'slider',
	'wpj_job_extra_price_limits_subscription_level0'     => 'slider',
	'wpj_job_extra_price_limits_subscription_level1'     => 'slider',
	'wpj_job_extra_price_limits_subscription_level2'     => 'slider',
	'wpj_job_extra_price_limits_subscription_level3'     => 'slider',
	'wpj_custom_extra_price_limits_subscription_level0'  => 'slider',
	'wpj_custom_extra_price_limits_subscription_level1'  => 'slider',
	'wpj_custom_extra_price_limits_subscription_level2'  => 'slider',
	'wpj_custom_extra_price_limits_subscription_level3'  => 'slider',
	'wpjobster_not_found_page_id'                        => 'select',
	'wpjobster_all_categories_page_id'                   => 'select',
	'wpjobster_all_news_page_id'                         => 'select',
	'wpjobster_all_proposals_page_id'                    => 'select',
	'wpjobster_all_requests_page_id'                     => 'select',
	'wpjobster_badges_page_id'                           => 'select',
	'wpjobster_all_blog_posts_page_id'                   => 'select',
	'wpjobster_checkout_page_id'                         => 'select',
	'wpjobster_feature_page_id'                          => 'select',
	'wpjobster_forgot_password_page_id'                  => 'select',
	'main_page_url'                                      => 'select',
	'main_page_url_user'                                 => 'select',
	'wpjobster_jobs_map_overview_page_id'                => 'select',
	'wpjobster_how_it_works_page_id'                     => 'select',
	'wpjobster_levels_page_id'                           => 'select',
	'wpjobster_login_page_id'                            => 'select',
	'wpjobster_my_account_page_id'                       => 'select',
	'wpjobster_my_account_all_notifications_page_id'     => 'select',
	'wpjobster_email_settings_page_id'                   => 'select',
	'wpjobster_my_favorites_page_id'                     => 'select',
	'wpjobster_my_requests_page_id'                      => 'select',
	'wpjobster_my_account_payments_page_id'              => 'select',
	'wpjobster_my_account_priv_mess_page_id'             => 'select',
	'wpjobster_my_account_reviews_page_id'               => 'select',
	'wpjobster_my_account_sales_page_id'                 => 'select',
	'wpjobster_my_account_personal_info_page_id'         => 'select',
	'wpjobster_my_account_shopping_page_id'              => 'select',
	'wpjobster_subscriptions_page_id'                    => 'select',
	'wpjobster_order_page_id'                            => 'select',
	'wpjobster_post_new_page_id'                         => 'select',
	'wpjobster_new_request_page_id'                      => 'select',
	'wpjobster_privacy_policy_page_id'                   => 'select',
	'wpjobster_register_page_id'                         => 'select',
	'wpjobster_advanced_search_id'                       => 'select',
	'wpjobster_advanced_search_request_page_id'          => 'select',
	'wpjobster_search_user_page_id'                      => 'select',
	'wpjobster_single_blog_page_id'                      => 'select',
	'wpjobster_single_job_page_id'                       => 'select',
	'wpjobster_single_news_page_id'                      => 'select',
	'wpjobster_single_request_page_id'                   => 'select',
	'wpjobster_terms_of_service_page_id'                 => 'select',
	'wpjobster_topup_order_page_id'                      => 'select',
	'wpjobster_user_profile_page_id'                     => 'select',
	'wpjobster_verify_email_page_id'                     => 'select',
	'wpjobster_verify_phone_page_id'                     => 'select',
	'wpjobster_jobs_permalink_slug_type'                 => 'select',
	'wpjobster_category_permalink'                       => 'text',
	'wpjobster_requests_permalink_slug_type'             => 'select',
	'wpjobster_requests_category_permalink'              => 'text',
	'wpjobster_news_permalink_slug_type'                 => 'select',
	'wpjobster_news_category_permalink'                  => 'text',
	'wpjobster_login_redirection_page'                   => 'select',
	'wpjobster_register_redirection_page'                => 'select',
	'wpjobster_post_new_job_redirection_page'            => 'select',
	'wpjobster_post_new_request_redirection_page'        => 'select',
	'wpjobster_enable_live_notifications'                => 'switch',
	'wpjobster_chat_enable'                              => 'switch',
	'wpjobster_all_users_to_sidebar'                     => 'switch',
	'wpjobster_message_attachments_enable'               => 'switch',
	'wpjobster_message_scroll_down_enable'               => 'switch',
	'wpjobster_message_image_attachments_enable'         => 'switch',
	'wpjobster_message_default_nr_of_pics'               => 'text',
	'wpjobster_message_max_img_upload_size'              => 'text',
	'wpjobster_message_search_results_number'            => 'text',
	'wpjobster_pm_emoji_enable'                          => 'switch',
	'wpjobster_chat_emoji_enable'                        => 'switch',
	'wpjobster_transaction_emoji_enable'                 => 'switch',
	'wpjobster_email_name_from'                          => 'text',
	'wpjobster_email_addr_from'                          => 'text',
	'wpjobster_allow_html_emails'                        => 'switch',
	'wpjobster_verify_email'                             => 'switch',
	'wpjobster_lock_verify_email_address'                => 'switch',
	'wpj_buyer_cart_notify_number'                       => 'text',
	'wpjobster_sms_admin_numb_from'                      => 'text',
	'wpj_resend_sms_time'                                => 'slider',
	'wpjobster_verify_phone_numbers'                     => 'switch',
	'wpjobster_lock_verify_phone_numbers'                => 'switch',
	'wpjobster_language_1'                               => 'select',
	'wpjobster_language_2'                               => 'select',
	'wpjobster_language_3'                               => 'select',
	'wpjobster_language_4'                               => 'select',
	'wpjobster_language_5'                               => 'select',
	'wpjobster_language_6'                               => 'select',
	'wpjobster_language_7'                               => 'select',
	'wpjobster_language_8'                               => 'select',
	'wpjobster_language_9'                               => 'select',
	'wpjobster_language_10'                              => 'select',
	'wpjobster_sms_gateways_enable'                      => 'select',
	'wpjobster_theme_accountsid'                         => 'text',
	'wpjobster_theme_authtoken'                          => 'text',
	'wpjobster_sms_numb_twilio_from'                     => 'text',
	'wpjobster_theme_cafe_userid'                        => 'text',
	'wpjobster_theme_cafe_secure'                        => 'text',
	'wpjobster_sms_numb_cafe_from'                       => 'text',
	'wpjobster_price_type'                               => 'select',
	'wpjobster_enable_fixed_rate'                        => 'switch',
	'wpjobster_enable_hourly_rate'                       => 'switch',
	'wpjobster_enable_daily_rate'                        => 'switch',
	'wpjobster_enable_weekly_rate'                       => 'switch',
	'wpjobster_enable_monthly_rate'                      => 'switch',
	'wpjobster_packages_enabled'                         => 'switch',
	'wpjobster_package_selected_page_load'               => 'text',
	'wpjobster_enable_custom_rate'                       => 'switch',
	'wpjobster_job_fixed_amount'                         => 'text',
	'newcost'                                            => 'multi_text',
	'wpjobster_featured_enable'                          => 'switch',
	'wpjobster_featured_interval'                        => 'text',
	'wpjobster_homepage_featured_enable'                 => 'switch',
	'wpjobster_featured_homepage'                        => 'text',
	'wpjobster_featured_price_homepage'                  => 'text',
	'wpjobster_category_featured_enable'                 => 'switch',
	'wpjobster_featured_category'                        => 'text',
	'wpjobster_featured_price_category'                  => 'text',
	'wpjobster_subcategory_featured_enable'              => 'switch',
	'wpjobster_featured_subcategory'                     => 'text',
	'wpjobster_featured_price_subcategory'               => 'text',
	'wpjobster_enable_topup'                             => 'switch',
	'topup-packages-settings'                            => 'repeater',
	'wpjobster_withdraw_limit'                           => 'text',
	'wpjobster_enable_withdraw_email_verification'       => 'switch',
	'wpjobster_payoneer_enable_withdraw'                 => 'switch',
	'wpjobster_enable_badges_sale'                       => 'switch',
	'badge-list-settings'                                => 'repeater',
	'wpjobster_subscription_enabled'                     => 'switch',
	'wpjobster_subscription_prior_notification'          => 'select',
	'wpjobster_subscription_name_level0'                 => 'text',
	'wpjobster_subscription_name_level1'                 => 'text',
	'wpjobster_subscription_weekly_amount_level1'        => 'text',
	'wpjobster_subscription_monthly_amount_level1'       => 'text',
	'wpjobster_subscription_quarterly_amount_level1'     => 'text',
	'wpjobster_subscription_yearly_amount_level1'        => 'text',
	'wpjobster_subscription_lifetime_amount_level1'      => 'text',
	'wpjobster_subscription_level_2_enabled'             => 'switch',
	'wpjobster_subscription_name_level2'                 => 'text',
	'wpjobster_subscription_weekly_amount_level2'        => 'text',
	'wpjobster_subscription_monthly_amount_level2'       => 'text',
	'wpjobster_subscription_quarterly_amount_level2'     => 'text',
	'wpjobster_subscription_yearly_amount_level2'        => 'text',
	'wpjobster_subscription_lifetime_amount_level2'      => 'text',
	'wpjobster_subscription_level_3_enabled'             => 'switch',
	'wpjobster_subscription_name_level3'                 => 'text',
	'wpjobster_subscription_weekly_amount_level3'        => 'text',
	'wpjobster_subscription_monthly_amount_level3'       => 'text',
	'wpjobster_subscription_quarterly_amount_level3'     => 'text',
	'wpjobster_subscription_yearly_amount_level3'        => 'text',
	'wpjobster_subscription_lifetime_amount_level3'      => 'text',
	'wpjobster_subscription_eligibility_enabled'         => 'switch',
	'wpjobster_subscription_eligibility_amount_level1'   => 'text',
	'wpjobster_subscription_eligibility_amount_level2'   => 'text',
	'wpjobster_subscription_eligibility_amount_level3'   => 'text',
	'wpjobster_paypal_enable'                            => 'switch',
	'wpjobster_paypal_enable_sandbox'                    => 'switch',
	'wpjobster_paypal_enable_job_purchase'               => 'switch',
	'wpjobster_paypal_enable_topup'                      => 'switch',
	'wpjobster_paypal_enable_featured'                   => 'switch',
	'wpjobster_paypal_enable_withdraw'                   => 'switch',
	'wpjobster_paypal_enable_custom_extra'               => 'switch',
	'wpjobster_paypal_enable_tips'                       => 'switch',
	'wpjobster_paypal_enable_subscription'               => 'switch',
	'wpjobster_paypal_enable_badge'                      => 'switch',
	'wpjobster_paypal_enable_secure'                     => 'switch',
	'wpjobster_paypal_email'                             => 'text',
	'wpjobster_paypal_button_caption'                    => 'text',
	'wpjobster_paypal_success_page'                      => 'select',
	'wpjobster_paypal_failure_page'                      => 'select',
	'wpjobster_theme_appid'                              => 'text',
	'wpjobster_theme_appsecret'                          => 'text',
	'paypal-withdrawal-info-link'                        => 'switch',
	'wpjobster_theme_apiusername'                        => 'text',
	'wpjobster_theme_apipassword'                        => 'text',
	'wpjobster_theme_apisignature'                       => 'text',
	'paypal-subscription-info-link'                      => 'switch',
	'wpjobster_cod_enable'                               => 'switch',
	'wpjobster_cod_enable_job_purchase'                  => 'switch',
	'wpjobster_cod_enable_badge'                         => 'switch',
	'wpjobster_cod_button_caption'                       => 'text',
	'wpjobster_cod_success_page'                         => 'select',
	'wpjobster_cod_failure_page'                         => 'select',
	'wpjobster_banktransfer_enable'                      => 'switch',
	'wpjobster_banktransfer_enable_job_purchase'         => 'switch',
	'wpjobster_banktransfer_enable_topup'                => 'switch',
	'wpjobster_banktransfer_enable_featured'             => 'switch',
	'wpjobster_banktransfer_enable_withdraw'             => 'switch',
	'wpjobster_banktransfer_enable_custom_extra'         => 'switch',
	'wpjobster_banktransfer_enable_tips'                 => 'switch',
	'wpjobster_banktransfer_enable_subscription'         => 'switch',
	'wpjobster_banktransfer_enable_badge'                => 'switch',
	'wpjobster_bank_details'                             => 'textarea',
	'wpjobster_bank_currency'                            => 'select',
	'wpjobster_banktransfer_button_caption'              => 'text',
	'wpjobster_banktransfer_success_page'                => 'select',
	'wpjobster_banktransfer_failure_page'                => 'select',
	'wpjobster_enable_google_analytics'                  => 'switch',
	'wpjobster_analytics_code'                           => 'textarea',
	'wpjobster_enable_other_tracking'                    => 'switch',
	'wpjobster_other_tracking_code'                      => 'textarea'
];

update_option( 'jobster_settings_structure', $settings_structure );