<?php /* Box Footer */

Redux::setSection( $opt_name, array(
	'title'    => esc_html__( 'MessageBox Footer', 'wpjobster' ),
	'id'         => 'chat-message-box-footer-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'          => 'chat_box_footer_bg_color',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.message-box-container .message-box-wrapper,
					.message-box-container .message-box-footer .message-box-input-content,
					.message-box-footer
				',
			),
			'title'       => esc_html__( 'Background colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'chat_box_footer_text_color',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.message-box-footer,
					.message-box-footer .message-box-placeholder-content,
					.message-box-container .message-box-footer .message-box-input-content,
					.message-box-container .message-box-footer .message-box-input-content::placeholder,
					.message-box-container.emoji-enabled .message-box-footer .message-box-input-wrapper .emojionearea .emojionearea-editor,
					.message-box-container.emoji-enabled .message-box-footer .message-box-input-wrapper .emojionearea .emojionearea-editor:empty:before
				',
			),
			'title'       => esc_html__( 'Text colour', 'wpjobster' ),
			'default'     => '#333435',
			'color_alpha' => true,
		),
		array(
			'id'          => 'chat_box_footer_textarea_bg_color',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.message-box-container.emoji-enabled .message-box-footer .message-box-input-wrapper .emojionearea .emojionearea-editor
				',
			),
			'title'       => esc_html__( 'Textarea background colour', 'wpjobster' ),
			'default'     => '#F0F2F5',
			'color_alpha' => true,
		),
		array(
			'id'      => 'chat_box_footer_buttons_color',
			'type'    => 'link_color',
			'title'   => __( 'Buttons colour', 'wpjobster' ),
			'active'  => false,
			'visited' => false,
			'default' => array(
				'regular' => '#90949c',
				'hover'   => '#20c497',
			),
			'compiler'    => array(
				'.message-box-container .message-box-footer .message-box-footer-buttons .message-options-icon',
				'.message-box-container .message-box-footer .message-box-footer-textarea .emojionearea-button *',
				'.message-box-container .message-box-footer .message-box-footer-send-button .icons'
			),
		),
		array(
			'id'       => 'message-options-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Message options', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'chat_box_footer_message_option_bg_color',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.message-box-container .message-box-footer .message-box-footer-options',
			),
			'title'       => esc_html__( 'Background colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'chat_box_footer_message_option_btn_bg_color',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.message-box-container .message-box-footer .message-box-footer-options .option-wrapper',
			),
			'title'       => esc_html__( 'Button background colour', 'wpjobster' ),
			'default'     => '#f1eff0',
			'color_alpha' => true,
		),
		array(
			'id'          => 'chat_box_footer_message_option_btn_bg_hover_color',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.message-box-container .message-box-footer .message-box-footer-options .option-wrapper:hover',
			),
			'title'       => esc_html__( 'Button background colour (hover)', 'wpjobster' ),
			'default'     => 'rgba(0, 0, 0, 0.05)',
			'color_alpha' => true,
		),
		array(
			'id'      => 'chat_box_footer_message_option_btn_text_color',
			'type'    => 'link_color',
			'title'   => __( 'Button colour', 'wpjobster' ),
			'active'  => false,
			'visited' => false,
			'default' => array(
				'regular' => '#000000',
				'hover'   => '#000000',
			),
			'compiler'  => array(
				'.message-box-container .message-box-footer .message-box-footer-options .option-wrapper .message-box-quick-response-icon',
				'.message-box-container .message-box-footer .message-box-footer-options .option-wrapper .message-box-image-attachment-icon',
				'.message-box-container .message-box-footer .message-box-footer-options .option-wrapper > i',
				'.message-box-container .message-box-footer .message-box-footer-options .option-wrapper > a > i',
				'.message-box-container .message-box-footer .message-box-footer-options .option-wrapper > div > i'
			),
		),
	)
) );