<?php /* Box Head */

Redux::setSection( $opt_name, array(
	'title'    => esc_html__( 'MessageBox Head', 'wpjobster' ),
	'id'         => 'chat-message-box-head-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'          => 'chat_box_head_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.message-box-container .message-box-wrapper .message-box-head',
			),
			'title'       => esc_html__( 'Background colour', 'wpjobster' ),
			'default'     => '#426195',
			'color_alpha' => true,
		),
		array(
			'id'          => 'chat_box_head_bg_hover_color',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.message-box-container .message-box-wrapper .message-box-head:hover',
			),
			'title'       => esc_html__( 'Background colour (hover)', 'wpjobster' ),
			'default'     => '#314368',
			'color_alpha' => true,
		),
		array(
			'id'          => 'chat_box_head_unread_bg_color',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.message-box-container .message-box-wrapper.unread .message-box-head',
			),
			'title'       => esc_html__( 'Message unread background colour', 'wpjobster' ),
			'default'     => '#4ac396',
			'color_alpha' => true,
		),
		array(
			'id'          => 'chat_box_head_unread_text_color',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.message-box-container .message-box-wrapper.unread .message-box-head .message-box-head-content .message-box-head-user .message-box-user-info .message-box-user-info-title, .message-box-container .message-box-wrapper.unread .message-box-head .message-box-head-content .message-box-head-user .message-box-user-info .message-box-user-info-status',
			),
			'title'       => esc_html__( 'Message unread text colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'chat_box_head_unread_button_color_hover',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '',
				'color'            => '',
			),
			'title'       => esc_html__( 'Message unread button colour (hover)', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'      => 'chat_box_head_buttons_color',
			'type'    => 'link_color',
			'title'   => __( 'Buttons colour', 'wpjobster' ),
			'active'  => false,
			'visited' => false,
			'focus'   => true,
			'default' => array(
				'regular' => '#ffffff',
				'hover'   => '#ffffff',
				'focus'   => '#ffffff'
			),
			'compiler'    => array( '.message-box-container .message-box-wrapper .message-box-head .message-box-head-content .message-box-head-user .message-box-head-buttons *' ),
		),
		array(
			'id'          => 'chat_box_head_user_name_color',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.message-box-container .message-box-wrapper .message-box-head .message-box-head-content .message-box-head-user .message-box-user-info .message-box-user-info-title-container *',
			),
			'title'       => esc_html__( 'Username colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'chat_box_head_user_status_color',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.message-box-container .message-box-wrapper .message-box-head .message-box-head-content .message-box-head-user .message-box-user-info .message-box-user-info-status *',
			),
			'title'       => esc_html__( 'Username status colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
	)
) );