<?php /* Sidebar Anchor */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Anchor', 'wpjobster' ),
	'id'         => 'chat-sidebar-anchor-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'      => 'chat_sidebar_icon_border_style',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.chat-sidebar-container .chat-sidebar-anchor-icon' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#ffffff',
				'border-style'  => 'solid',
				'border-width'  => '1px'
			)
		),
		array(
			'id'          => 'chat_sidebar_icon_bg_color',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.chat-sidebar-container .chat-sidebar-anchor-icon',
			),
			'title'       => esc_html__( 'Background colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'chat_sidebar_icon_bg_hover_color',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.chat-sidebar-container .chat-sidebar-anchor-icon:hover',
			),
			'title'       => esc_html__( 'Background colour (hover)', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'            => 'chat_sidebar_icon_dimensions',
			'type'          => 'dimensions',
			'title'         => esc_html__( 'Dimensions', 'wpjobster' ),
			'units'         => 'px',
			'width'         => 'false',
			'default'       => array(
				'height'  => 64,
				'width'   => 40,
			),
			'compiler'         => array( '.chat-sidebar-container .chat-sidebar-anchor-icon' )
		),
		array(
			'id'       => 'chat_sidebar_icon_name',
			'type'     => 'text',
			'title'    => __( 'Icon name', 'wpjobster' ),
			'default'  => 'comments',
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' )
		),
		array(
			'id'          => 'chat_sidebar_icon_color',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.chat-sidebar-container .chat-sidebar-anchor-icon i',
			),
			'title'       => esc_html__( 'Icon colour', 'wpjobster' ),
			'default'     => '#5a5a5a',
			'color_alpha' => true,
		),
		array(
			'id'          => 'chat_sidebar_icon_hover_color',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.chat-sidebar-container .chat-sidebar-anchor-icon:hover i',
			),
			'title'       => esc_html__( 'Icon colour (hover)', 'wpjobster' ),
			'default'     => '#5a5a5a',
			'color_alpha' => true,
		),
		array(
			'id'             => 'chat_sidebar_icon_spacing',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => 'px',
			'display_units'  => false,
			'title'          => __( 'Icon spacing', 'wpjobster' ),
			'subtitle'       => __( 'For spacing you can use only px', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '20',
				'padding-right'  => '5',
				'padding-bottom' => '20',
				'padding-left'   => '2',
				'units'          => 'px',
			),
			'compiler'         => array( '.chat-sidebar-container .chat-sidebar-anchor-icon' ),
		),
	)
) );