<?php /* Sidebar Body */

Redux::setSection( $opt_name, array(
	'title'    => esc_html__( 'Sidebar', 'wpjobster' ),
	'id'         => 'chat-sidebar-body-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'chat_sidebar_style',
			'type'     => 'select',
			'title'    => esc_html__( 'Sidebar style', 'wpjobster' ),
			'options'  => array(
				'1' => esc_attr__( 'Extended', 'wpjobster' ),
				'2' => esc_attr__( 'Minimalist', 'wpjobster' )
			),
			'default'  => '2',
		),
		array(
			'id'          => 'chat_sidebar_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.chat-sidebar-container .chat-sidebar-users-list,
					.is-chat-active .chat-sidebar-minimal-wrapper,
					.is-chat-active .chat-sidebar-minimal-container .chat-sidebar-users-list,
					.is-chat-active .chat-sidebar-minimal-container .ui.placeholder .image:not(:first-child):before
				',
			),
			'title'       => esc_html__( 'Background colour', 'wpjobster' ),
			'default'     => '#f7f8f9',
			'color_alpha' => true,
		),
		array(
			'id'          => 'chat_sidebar_bg_item_color',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.is-chat-active .chat-sidebar-container .chat-sidebar-users-list .chat-sidebar-user-box,
					.is-chat-active .chat-sidebar-minimal-container .chat-sidebar-users-list .chat-sidebar-user-box,
					.is-chat-active .chat-sidebar-notifications,
					.is-chat-active .chat-sidebar-minimal-container .ui.placeholder
				',
			),
			'title'       => esc_html__( 'Item (user) background colour', 'wpjobster' ),
			'default'     => '#f7f8f9',
			'color_alpha' => true,
		),
		array(
			'id'          => 'chat_sidebar_bg_item_hover_color',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.is-chat-active .chat-sidebar-container .chat-sidebar-users-list .chat-sidebar-user-box:hover,
					.is-chat-active .chat-sidebar-minimal-container .chat-sidebar-users-list .chat-sidebar-user-box:hover,
					.is-chat-active .chat-sidebar-notifications:hover
				',
			),
			'title'       => esc_html__( 'Item (user) background colour (hover)', 'wpjobster' ),
			'default'     => '#dddfe2',
			'color_alpha' => true,
		),
		array(
			'id'          => 'chat_sidebar_text_color',
			'type'        => 'link_color',
			'title'       => __( 'Item (user) text colour', 'wpjobster' ),
			'active'      => false,
			'visited'     => false,
			'color_alpha' => true,
			'default'     => array(
				'regular' => '#000000',
				'hover'   => '#000000',
			),
			'compiler'    => array( '.chat-sidebar-container .chat-sidebar-users-list .chat-sidebar-user-box, .chat-sidebar-notifications' ),
		),
	)
) );