<?php /* Blog */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Blog', 'wpjobster' ),
	'id'         => 'blog-design-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'           => 'no_image_icon_options_blog',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Blog - no image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),
		array(
			'id'           => 'no_image_icon_options_news',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'News - no image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),

/* DATE */
		array(
			'id'       => 'blog-date-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Date', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'blog_date_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.article-date'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#e8ebf6',
			'color_alpha' => true,
		),
		array(
			'id'          => 'blog_date_hover_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.article-date:hover'
			),
			'title'       => __( 'Hover background colour', 'wpjobster' ),
			'default'     => '#e8ebf6',
			'color_alpha' => true,
		),
		array(
			'id'          => 'blog_date_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.article-date'
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => '#898eb4',
			'color_alpha' => true,
		),
		array(
			'id'          => 'blog_date_text_hover_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.article-date:hover'
			),
			'title'       => __( 'Hover text colour', 'wpjobster' ),
			'default'     => '#898eb4',
			'color_alpha' => true,
		),
		array(
			'id'      => 'blog_date_border',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.article-date' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#e8ebf6',
				'border-style'  => 'solid',
				'border-width'  => '0px'
			),
		),
		array(
			'id'             => 'blog_date_border_radius',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '6',
				'units' => 'px',
			)
		),
		array(
			'id'             => 'blog_date_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => false,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => true,
			'text-shadow'    => true,
			'default'        => array(
				'font-family'       => 'Poppins',
				'font-size'         => '12px',
				'font-weight'       => 600,
				'line-height'       => '21px',
				'text-transform'    => 'none',
				'shadow-color'      => '#abb0d1',
				'shadow-horizontal' => 0,
				'shadow-vertical'   => 0,
				'shadow-blur'       => 0,
			),
			'compiler' => array( '.article-date' ),
		),
		array(
			'id'             => 'blog_date_padding',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Padding', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '8',
				'padding-right'  => '12',
				'padding-bottom' => '8',
				'padding-left'   => '12',
				'units'          => 'px',
			),
			'compiler'         => array( '.article-date' ),
		),
		array(
			'id'             => 'blog_date_margin',
			'type'           => 'spacing',
			'mode'           => 'margin',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Margin', 'wpjobster' ),
			'default'        => array(
				'margin-top'    => '0',
				'margin-right'  => '5',
				'margin-bottom' => '6',
				'margin-left'   => '0',
				'units'          => 'px',
			),
			'compiler'         => array( '.article-date' ),
		),

/* TAGS */

		array(
			'id'       => 'blog-tags-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Tags', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'blog_tags_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.blog-tags ul li a'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'blog_tags_hover_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.blog-tags ul li a:hover'
			),
			'title'       => __( 'Hover background colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'blog_tags_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.blog-tags ul li a, .blog-tags ul li a:visited, .blog-tags ul li a:focus'
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => '#abb0d1',
			'color_alpha' => true,
		),
		array(
			'id'          => 'blog_tags_text_hover_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.blog-tags ul li a:hover'
			),
			'title'       => __( 'Hover text colour', 'wpjobster' ),
			'default'     => '#abb0d1',
			'color_alpha' => true,
		),
		array(
			'id'      => 'blog_tags_border',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.blog-tags ul li a' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#bfc3e0',
				'border-style'  => 'solid',
				'border-width'  => '2px'
			),
		),
		array(
			'id'             => 'blog_tags_border_radius',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '6',
				'units' => 'px',
			)
		),
		array(
			'id'             => 'blog_tags_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => false,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => true,
			'text-shadow'    => true,
			'default'        => array(
				'font-family'       => 'Poppins',
				'font-size'         => '14px',
				'font-weight'       => 600,
				'line-height'       => '21px',
				'text-transform'    => 'none',
				'shadow-color'      => '#abb0d1',
				'shadow-horizontal' => 0,
				'shadow-vertical'   => 0,
				'shadow-blur'       => 0,
			),
			'compiler' => array( '.blog-tags ul li a' ),
		),
		array(
			'id'             => 'blog_tags_padding',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Padding', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '6',
				'padding-right'  => '10',
				'padding-bottom' => '6',
				'padding-left'   => '10',
				'units'          => 'px',
			),
			'compiler'         => array( '.blog-tags.small ul li a' ),
		),
		array(
			'id'             => 'blog_tags_margin',
			'type'           => 'spacing',
			'mode'           => 'margin',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Margin', 'wpjobster' ),
			'default'        => array(
				'margin-top'    => '0',
				'margin-right'  => '6',
				'margin-bottom' => '6',
				'margin-left'   => '0',
				'units'          => 'px',
			),
			'compiler'         => array( '.blog-tags.small ul li' ),
		),

/* CATEGORIES */

		array(
			'id'       => 'blog-categories-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Categories', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'blog_categories_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.blog-categories ul li a'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'blog_categories_hover_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.blog-categories ul li a:hover'
			),
			'title'       => __( 'Hover background colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'blog_categories_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.blog-categories ul li a, .blog-categories ul li a:visited, .blog-categories ul li a:focus'
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => '#abb0d1',
			'color_alpha' => true,
		),
		array(
			'id'          => 'blog_categories_text_hover_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.blog-categories ul li a:hover'
			),
			'title'       => __( 'Hover text colour', 'wpjobster' ),
			'default'     => '#abb0d1',
			'color_alpha' => true,
		),
		array(
			'id'      => 'blog_categories_border',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.blog-categories ul li a' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#bfc3e0',
				'border-style'  => 'solid',
				'border-width'  => '2px'
			),
		),
		array(
			'id'             => 'blog_categories_border_radius',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '6',
				'units' => 'px',
			)
		),
		array(
			'id'             => 'blog_categories_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => false,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => true,
			'text-shadow'    => true,
			'default'        => array(
				'font-family'       => 'Poppins',
				'font-size'         => '14px',
				'font-weight'       => 600,
				'line-height'       => '21px',
				'text-transform'    => 'none',
				'shadow-color'      => '#abb0d1',
				'shadow-horizontal' => 0,
				'shadow-vertical'   => 0,
				'shadow-blur'       => 0,
			),
			'compiler' => array( '.blog-categories ul li a' ),
		),
		array(
			'id'             => 'blog_categories_padding',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Padding', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '6',
				'padding-right'  => '10',
				'padding-bottom' => '6',
				'padding-left'   => '10',
				'units'          => 'px',
			),
			'compiler'         => array( '.blog-categories.small ul li a' ),
		),
		array(
			'id'             => 'blog_categories_margin',
			'type'           => 'spacing',
			'mode'           => 'margin',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Margin', 'wpjobster' ),
			'default'        => array(
				'margin-top'    => '0',
				'margin-right'  => '6',
				'margin-bottom' => '6',
				'margin-left'   => '0',
				'units'          => 'px',
			),
			'compiler'         => array( '.blog-categories.small ul li' ),
		),

/* SHARE */

		array(
			'id'       => 'blog-share-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Share icons', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'blog_share_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.share-article a'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => 'rgba(0, 0, 0, 0)',
			'color_alpha' => true,
		),
		array(
			'id'          => 'blog_share_hover_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.share-article a:hover'
			),
			'title'       => __( 'Hover background colour', 'wpjobster' ),
			'default'     => 'rgba(0, 0, 0, 0)',
			'color_alpha' => true,
		),
		array(
			'id'          => 'blog_share_icon_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.share-article a'
			),
			'title'       => __( 'Icon colour', 'wpjobster' ),
			'default'     => '#898eb4',
			'color_alpha' => true,
		),
		array(
			'id'          => 'blog_share_icon_hover_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.share-article a:hover'
			),
			'title'       => __( 'Hover icon colour', 'wpjobster' ),
			'default'     => 'rgb(167,167,167)',
			'color_alpha' => true,
		),
		array(
			'id'             => 'blog_share_icon_size',
			'type'           => 'typography',
			'title'          => esc_html__( 'Icon size', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => false,
			'word-spacing'   => false,
			'letter-spacing' => false,
			'font-family'    => false,
			'font-style'     => false,
			'font-weight'    => false,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => false,
			'text-shadow'    => false,
			'default'        => array(
				'font-size'   => '14px',
				'line-height' => '14px'
			),
			'compiler' => array( '.share-article a' ),
		),
		array(
			'id'      => 'blog_share_border',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.share-article a' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color' => '#898eb4',
				'border-style' => 'solid',
				'border-width' => '2px'
			),
		),
		array(
			'id'             => 'blog_share_border_radius',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '8',
				'units' => 'px',
			)
		),
		array(
			'id'             => 'blog_share_padding',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Padding', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '6',
				'padding-right'  => '6',
				'padding-bottom' => '6',
				'padding-left'   => '6',
				'units'          => 'px',
			),
			'compiler'         => array( '.share-article a' ),
		),
		array(
			'id'             => 'blog_share_margin',
			'type'           => 'spacing',
			'mode'           => 'margin',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Margin', 'wpjobster' ),
			'default'        => array(
				'margin-top'    => '0',
				'margin-right'  => '8',
				'margin-bottom' => '0',
				'margin-left'   => '0',
				'units'          => 'px',
			),
			'compiler'         => array( '.share-article a' ),
		),
	)
) );