<?php /* Job */

Redux::setSection( $opt_name, apply_filters( 'wpj_admin_design_elements_job_items_filter', array(
	'title'      => __( 'Job', 'wpjobster' ),
	'id'         => 'job-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'           => 'no_image_icon_options_job',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Job - no image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),

/* JOB CARDS */

		array(
			'id'       => 'job-cards-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Job - Cards', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'enable_video_icon_cards',
			'type'     => 'switch',
			'title'    => __( 'Video icon on cards', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'enable_rating_count_cards',
			'type'     => 'switch',
			'title'    => __( 'Enable rating count on homepage cards', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'cards_style',
			'type'     => 'select',
			'title'    => esc_html__( 'Job cards style', 'wpjobster' ),
			'options'  => array(
				'1' => esc_attr__( 'Simple (sliding on hover)', 'wpjobster' ),
				'2' => esc_attr__( 'Rich (no hover)', 'wpjobster' ),
				'3' => esc_attr__( 'Slider', 'wpjobster' ),
				'4' => esc_attr__( 'Clean', 'wpjobster' ),
			),
			'default'  => '3',
		),
		array(
			'id'       => 'border_over_box_shadow',
			'type'     => 'switch',
			'title'    => __( 'Enable border instead of box shadow on job cards', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'rating_slider_after_title',
			'type'     => 'switch',
			'title'    => __( 'Move rating after title', 'wpjobster' ),
			'default'  => false,
			'required' => array(
				array( 'cards_style', '=', '3' )
			)
		),
		array(
			'id'       => 'wpjobster_user_level_for_thumbnails',
			'type'     => 'switch',
			'title'    => __( 'Display user level', 'wpjobster' ),
			'default'  => true
		),
		array(
			'id'           => 'level1_card_icon_options_user',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Level 1', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
			'required'     => array( 'cards_style', '=', array( '1', '2' ) )
		),
		array(
			'id'           => 'level2_card_icon_options_user',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Level 2', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
			'required'     => array( 'cards_style', '=', array( '1', '2' ) )
		),
		array(
			'id'           => 'level3_card_icon_options_user',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Level 3', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
			'required'     => array( 'cards_style', '=', array( '1', '2' ) )
		),
		array(
			'id'           => 'featured_simple_icon_options_job',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Featured icon image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
			'required'     => array( 'cards_style', '=', '1' )
		),
		array(
			'id'           => 'lets_meet_simple_icon_options_job',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Let\'s meet icon image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
			'required'    => array( 'cards_style', '=', '1' )
		),
		array(
			'id'           => 'instant_delivery_simple_icon_options_job',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Instant delivery icon image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
			'required'     => array( 'cards_style', '=', '1' )
		),
		array(
			'id'           => 'free_shipping_simple_icon_options_job',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Free shipping icon image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
			'required'     => array( 'cards_style', '=', '1' )
		),
		array(
			'id'       => 'lets_meet_rich_icon_options_job',
			'type'     => 'text',
			'title'    => __( 'Let\'s meet icon', 'wpjobster' ),
			'default'  => 'blue map marker',
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' ),
			'required' => array( 'cards_style', '=', '2' )
		),
		array(
			'id'       => 'instant_delivery_rich_icon_options_job',
			'type'     => 'text',
			'title'    => __( 'Instant delivery icon', 'wpjobster' ),
			'default'  => 'green arrow circle down',
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' ),
			'required' => array( 'cards_style', '=', '2' )
		),
		array(
			'id'       => 'distance_slider_icon_options_job',
			'type'     => 'text',
			'title'    => __( 'Distance icon', 'wpjobster' ),
			'desc'     => __( 'Leave the field blank if you want the default icon to appear.', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' ),
			'required' => array( 'cards_style', '=', array( '3', '4' ) )
		),
		array(
			'id'       => 'lets_meet_slider_icon_options_job',
			'type'     => 'text',
			'title'    => __( 'Let\'s meet icon', 'wpjobster' ),
			'desc'     => __( 'Leave the field blank if you want the default icon to appear.', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' ),
			'required' => array( 'cards_style', '=', array( '3', '4' ) )
		),
		array(
			'id'       => 'instant_delivery_slider_icon_options_job',
			'type'     => 'text',
			'title'    => __( 'Instant delivery icon', 'wpjobster' ),
			'desc'     => __( 'Leave the field blank if you want the default icon to appear.', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' ),
			'required' => array( 'cards_style', '=', array( '3', '4' ) )
		),
		array(
			'id'       => 'featured_slider_icon_options_job',
			'type'     => 'text',
			'title'    => __( 'Featured icon', 'wpjobster' ),
			'desc'     => __( 'Leave the field blank if you want the default icon to appear.', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' ),
			'required' => array( 'cards_style', '=', '3' )
		),
		array(
			'id'       => 'favorites_slider_icon_options_job',
			'type'     => 'text',
			'title'    => __( 'Favorites icon', 'wpjobster' ),
			'default'  => 'heart',
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' ),
			'required' => array( 'cards_style', '=', array( '3', '4' ) )
		),
		array(
			'id'       => 'free_shipping_slider_icon_options_job',
			'type'     => 'text',
			'title'    => __( 'Free shipping icon', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' ),
			'required' => array( 'cards_style', '=', array( '2', '3', '4' ) )
		),

/* POPULAR CATEGORIES */

		array(
			'id'       => 'job-popular-categories-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Job - Popular categories', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'job_popular_categories_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.most-popular-terms a'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'job_popular_categories_hover_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.most-popular-terms a:hover'
			),
			'title'       => __( 'Hover background colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'job_popular_categories_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.most-popular-terms a, .most-popular-terms a:visited, .most-popular-terms a:focus'
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => '#abb0d1',
			'color_alpha' => true,
		),
		array(
			'id'          => 'job_popular_categories_text_hover_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.most-popular-terms a:hover'
			),
			'title'       => __( 'Hover text colour', 'wpjobster' ),
			'default'     => '#abb0d1',
			'color_alpha' => true,
		),
		array(
			'id'      => 'job_popular_categories_border',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.most-popular-terms a' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#bfc3e0',
				'border-style'  => 'solid',
				'border-width'  => '2px'
			),
		),
		array(
			'id'             => 'job_popular_categories_border_radius',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '6',
				'units' => 'px',
			)
		),
		array(
			'id'             => 'job_popular_categories_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => false,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => true,
			'text-shadow'    => true,
			'default'        => array(
				'font-family'       => 'Poppins',
				'font-size'         => '14px',
				'font-weight'       => 600,
				'line-height'       => '21px',
				'text-transform'    => 'capitalize',
				'shadow-color'      => '#abb0d1',
				'shadow-horizontal' => 0,
				'shadow-vertical'   => 0,
				'shadow-blur'       => 0,
			),
			'compiler' => array( '.most-popular-terms a' ),
		),
		array(
			'id'             => 'job_popular_categories_padding',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Padding', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '10',
				'padding-right'  => '10',
				'padding-bottom' => '10',
				'padding-left'   => '10',
				'units'          => 'px',
			),
			'compiler'         => array( '.most-popular-terms a' ),
		),
		array(
			'id'             => 'job_popular_categories_margin',
			'type'           => 'spacing',
			'mode'           => 'margin',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Margin', 'wpjobster' ),
			'default'        => array(
				'margin-top'    => '0',
				'margin-right'  => '3',
				'margin-bottom' => '6',
				'margin-left'   => '0',
				'units'          => 'px',
			),
			'compiler'         => array( '.most-popular-terms a' ),
		),

/* DESCRIPTION */

		array(
			'id'       => 'job-presentation-description-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Job presentation - Description', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'             => 'job-description-typography-settings',
			'type'           => 'typography',
			'title'          => esc_html__( 'Font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => true,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => false,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'default'        => array(
				'font-family' => 'Poppins',
				'font-size'   => '14px',
				'color'       => '#898eb4',
				'line-height' => '22px'
			),
			'compiler' => array( '.post-job-description *, .single-job-job-description *' ),
		),

/* INSTRUCTIONS */

		array(
			'id'       => 'post-new-job-instructions-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Post new - Instructions', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'job_instructions_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.ui.form .post-new-wrapper.post-new-job-wrapper .ui.popup:not([class*="ui popup calendar"]),
					.ui.form .post-new-wrapper.post-new-job-form-row-wrapper .ui.popup:not([class*="ui popup calendar"]),
					.ui.form .post-new-wrapper.post-new-job-wrapper .ui.popup:not([class*="ui popup calendar"]):before,
					.ui.form .post-new-wrapper.post-new-job-form-row-wrapper .ui.popup:not([class*="ui popup calendar"]):before
				'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#c4ffef',
			'color_alpha' => true,
		),
		array(
			'id'          => 'job_instructions_border_colour',
			'type'        => 'color',
			'compiler'      => array(
				'border-color' => '
					.ui.form .post-new-wrapper.post-new-job-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input),
					.ui.form .post-new-wrapper.post-new-job-form-row-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input)
				'
			),
			'title'       => __( 'Border colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		),
		array(
			'id'            => 'job_instructions_arrow_colour',
			'type'          => 'box_shadow',
			'title'         => __( 'Arrow colour', 'wpjobster' ),
			'units'         => 'px',
			'display_units' => false,
			'preview'       => false,
			'opacity'       => true,
			'rgba'          => true,
			'default'       => array (
				'horizontal'   => '-2px',
				'vertical'     => '2px',
				'blur'         => '0px',
				'spread'       => '0px',
				'opacity'      => '1',
				'shadow-color' => '#20c497',
				'shadow-type'  => 'outside',
			),
			'compiler'        => array(
				'.ui.form .post-new-wrapper.post-new-job-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input):before',
				'.ui.form .post-new-wrapper.post-new-job-form-row-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input):before'
			),
		),
		array(
			'id'          => 'job_instructions_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.ui.form .post-new-wrapper.post-new-job-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input),
					.ui.form .post-new-wrapper.post-new-job-form-row-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input)
				'
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => 'rgba(0, 0, 0, 0.87)',
			'color_alpha' => true,
		),
		array(
			'id'             => 'job_instructions_box_spacing',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => 'px',
			'display_units'  => false,
			'title'          => __( 'Box spacing', 'wpjobster' ),
			'subtitle'       => __( 'For spacing you can use only px', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '30',
				'padding-right'  => '30',
				'padding-bottom' => '30',
				'padding-left'   => '30',
				'units'          => 'px',
			),
			'compiler'        => array(
				'.ui.form .post-new-wrapper.post-new-job-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input)',
				'.ui.form .post-new-wrapper.post-new-job-form-row-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input)'
			),
		),
		array(
			'id'           => 'job_instructions_box_icon',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Icon', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),

/* SUBCATEGORIES */

		array(
			'id'       => 'job-subcategories-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Subcategories listing', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'job_subcategories_slider',
			'type'     => 'switch',
			'title'    => __( 'Display as slider', 'wpjobster' ),
			'subtitle' => __( 'Present the subcategories as a slider within a single row when they exceed the row\'s capacity, rather than spreading them across multiple rows.', 'wpjobster' ),
			'default'  => false
		),
		array(
			'id'          => 'job_subcategories_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.job-subcategories.subcategory-listing ul li a'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'job_subcategories_hover_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.job-subcategories.subcategory-listing ul li a:hover'
			),
			'title'       => __( 'Hover background colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'job_subcategories_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.job-subcategories.subcategory-listing ul li a, .job-subcategories.subcategory-listing ul li a:visited, .job-subcategories.subcategory-listing ul li a:focus'
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => '#abb0d1',
			'color_alpha' => true,
		),
		array(
			'id'          => 'job_subcategories_text_hover_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.job-subcategories.subcategory-listing ul li a:hover'
			),
			'title'       => __( 'Hover text colour', 'wpjobster' ),
			'default'     => '#abb0d1',
			'color_alpha' => true,
		),
		array(
			'id'      => 'job_subcategories_border',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.job-subcategories.subcategory-listing ul li a' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#bfc3e0',
				'border-style'  => 'solid',
				'border-width'  => '2px'
			),
		),
		array(
			'id'             => 'job_subcategories_border_radius',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '6',
				'units' => 'px',
			)
		),
		array(
			'id'             => 'job_subcategories_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => false,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => true,
			'text-shadow'    => true,
			'default'        => array(
				'font-family'       => 'Poppins',
				'font-size'         => '14px',
				'font-weight'       => 600,
				'line-height'       => '21px',
				'text-transform'    => 'none',
				'shadow-color'      => '#abb0d1',
				'shadow-horizontal' => 0,
				'shadow-vertical'   => 0,
				'shadow-blur'       => 0,
			),
			'compiler' => array( '.job-subcategories.subcategory-listing ul li a' ),
		),
		array(
			'id'             => 'job_subcategories_padding',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Padding', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '8',
				'padding-right'  => '12',
				'padding-bottom' => '8',
				'padding-left'   => '12',
				'units'          => 'px',
			),
			'compiler'         => array( '.job-subcategories.subcategory-listing ul li a' ),
		),
		array(
			'id'             => 'job_subcategories_margin',
			'type'           => 'spacing',
			'mode'           => 'margin',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Margin', 'wpjobster' ),
			'default'        => array(
				'margin-top'    => '0',
				'margin-right'  => '6',
				'margin-bottom' => '6',
				'margin-left'   => '0',
				'units'          => 'px',
			),
			'compiler'         => array( '.job-subcategories.subcategory-listing ul li' ),
		),
	)
) ) );