<?php /* Load More */

$page_numbers_class        = '.pagination-wrapper .page-numbers:not(.prev):not(.current):not(.next)';
$prev_page_number_class    = '.pagination-wrapper .prev.page-numbers:not(.current):not(.next)';
$current_page_number_class = '.pagination-wrapper .current.page-numbers:not(.prev):not(.next)';
$next_page_number_class    = '.pagination-wrapper .next.page-numbers:not(.current):not(.prev)';

Redux::setSection( $opt_name, array(
	'title'      => __( 'Load More', 'wpjobster' ),
	'id'         => 'load-more-settings',
	'subsection' => true,
	'fields'     => array(

/* LOAD MORE BUTTON */

		array(
			'id'       => 'user-account-load-more-button-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Load more button', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'           => 'user_account_load_more_button_image',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),
		array(
			'id'          => 'user_account_load_more_button_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.load-more-button.text-button:not(.text-button-simple):not(.text-button-secondary-soft):not(.text-button-gray-outlined):not(.light)'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#20C497',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_load_more_button_hover_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.load-more-button.text-button:not(.text-button-simple):not(.text-button-secondary-soft):not(.text-button-gray-outlined):not(.light):hover'
			),
			'title'       => __( 'Hover background colour', 'wpjobster' ),
			'default'     => '#1BA57F',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_load_more_button_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.load-more-button.text-button'
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_load_more_button_text_hover_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.load-more-button.text-button:hover'
			),
			'title'       => __( 'Hover text colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true
		),
		array(
			'id'       => 'user_account_load_more_button_border',
			'type'     => 'border',
			'all'      => true,
			'compiler'   => array( '.load-more-button.text-button' ),
			'title'    => esc_html__( 'Border', 'wpjobster' ),
			'default'  => array(
				'border-color'  => '#20C497',
				'border-style'  => 'solid',
				'border-width'  => '0px'
			)
		),
		array(
			'id'             => 'user_account_load_more_button_border_radius',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '6',
				'units' => 'px',
			)
		),
		array(
			'id'             => 'user_account_load_more_button_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => false,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => true,
			'text-shadow'    => true,
			'default'        => array(
				'font-family'       => 'Poppins',
				'font-size'         => '14px',
				'font-weight'       => 600,
				'line-height'       => '21px',
				'text-transform'    => 'none',
				'shadow-color'      => '#20C497',
				'shadow-horizontal' => 0,
				'shadow-vertical'   => 0,
				'shadow-blur'       => 0,
			),
			'compiler'         => array( '.load-more-button.text-button' )
		),
		array(
			'id'             => 'user_account_load_more_button_padding',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Padding', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '8',
				'padding-right'  => '25',
				'padding-bottom' => '8',
				'padding-left'   => '25',
				'units'          => 'px',
			),
			'compiler'         => array( '.load-more-button.text-button' )
		),
		array(
			'id'             => 'user_account_load_more_button_margin',
			'type'           => 'spacing',
			'mode'           => 'margin',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Margin', 'wpjobster' ),
			'default'        => array(
				'margin-top'    => '50',
				'margin-right'  => 'auto',
				'margin-bottom' => '50',
				'margin-left'   => 'auto',
				'units'          => 'px',
			),
			'compiler'         => array( '.load-more-button.text-button' )
		),

/* PAGINATION */

		array(
			'id'       => 'user-account-pagination-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Pagination', 'wpjobster' ),
			'indent'   => true
		),
		array(
			'id'             => 'user_account_pagination_page_numbers_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => false,
			'word-spacing'   => false,
			'letter-spacing' => false,
			'font-style'     => false,
			'font-weight'    => true,
			'font-family'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'default'        => array(
				'font-family' => 'Poppins',
				'font-size'   => '14px',
				'font-weight' => '600',
				'line-height' => '38px',
			),
			'compiler' => array( '.pagination-wrapper *, .pagination-wrapper .page-numbers, .pagination-wrapper a.page-numbers .pagination-wrapper a, .pagination-wrapper span' ),
		),
		array(
			'id'             => 'user_account_pagination_page_numbers_dimensions',
			'type'           => 'dimensions',
			'units'          => array( 'px', '%' ),
			'title'          => esc_html__( 'Dimensions - page number', 'wpjobster' ),
			'default'        => array(
				'width'  => 40,
				'height' => 40,
				'units' => 'px',
			),
			'compiler'         => array( '.pagination-wrapper .page-numbers:not(.prev):not(.next)' )
		),
		array(
			'id'             => 'user_account_pagination_prev_next_padding',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Padding - prev & next', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '0',
				'padding-right'  => '25',
				'padding-bottom' => '0',
				'padding-left'   => '25',
				'units'          => 'px',
			),
			'compiler'         => array( '.pagination-wrapper .page-numbers.prev, .pagination-wrapper .page-numbers.next' )
		),
		array(
			'id'             => 'user_account_pagination_page_numbers_border_radius',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius - page numbers', 'wpjobster' ),
			'default'        => array(
				'top'   => '50',
				'units' => '%',
			)
		),
		array(
			'id'             => 'user_account_pagination_prev_next_border_radius',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius - prev & next', 'wpjobster' ),
			'default'        => array(
				'top'   => '40',
				'units' => 'px',
			)
		),

	/* PAGE NUMBERS */

		array(
			'id'       => 'user-account-pagination-page-numbers-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Pagination - page numbers', 'wpjobster' ),
			'indent'   => true
		),
		array(
			'id'          => 'user_account_pagination_page_numbers_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => $page_numbers_class
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#fff',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_pagination_page_numbers_hover_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => $page_numbers_class . ':hover'
			),
			'title'       => __( 'Hover background colour', 'wpjobster' ),
			'default'     => '#fff',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_pagination_page_numbers_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => $page_numbers_class
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => '#9a9a9b',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_pagination_page_numbers_text_hover_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => $page_numbers_class . ':hover'
			),
			'title'       => __( 'Hover text colour', 'wpjobster' ),
			'default'     => '#9a9a9b',
			'color_alpha' => true
		),
		array(
			'id'       => 'user_account_pagination_page_numbers_border',
			'type'     => 'border',
			'all'      => true,
			'compiler'   => array( $page_numbers_class ),
			'title'    => esc_html__( 'Border', 'wpjobster' ),
			'default'  => array(
				'border-color'  => '#edf1ef',
				'border-style'  => 'solid',
				'border-width'  => '2px'
			)
		),

	/* PREV PAGE NUMBER */

		array(
			'id'       => 'user-account-pagination-prev-page-number-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Pagination - prev page number', 'wpjobster' ),
			'indent'   => true
		),
		array(
			'id'          => 'user_account_pagination_prev_page_number_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => $prev_page_number_class
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#fff',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_pagination_prev_page_number_hover_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => $prev_page_number_class . ':hover'
			),
			'title'       => __( 'Hover background colour', 'wpjobster' ),
			'default'     => '#fff',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_pagination_prev_page_number_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => $prev_page_number_class
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_pagination_prev_page_number_text_hover_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => $prev_page_number_class . ':hover'
			),
			'title'       => __( 'Hover text colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true
		),
		array(
			'id'       => 'user_account_pagination_prev_page_number_border',
			'type'     => 'border',
			'all'      => true,
			'compiler'   => array( $prev_page_number_class ),
			'title'    => esc_html__( 'Border', 'wpjobster' ),
			'default'  => array(
				'border-color'  => '#20c497',
				'border-style'  => 'solid',
				'border-width'  => '2px'
			)
		),

	/* CURRENT PAGE NUMBER */

		array(
			'id'       => 'user-account-pagination-current-page-number-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Pagination - current page number', 'wpjobster' ),
			'indent'   => true
		),
		array(
			'id'          => 'user_account_pagination_current_page_number_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => $current_page_number_class
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_pagination_current_page_number_hover_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => $current_page_number_class . ':hover'
			),
			'title'       => __( 'Hover background colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_pagination_current_page_number_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => $current_page_number_class
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => '#fff',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_pagination_current_page_number_text_hover_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => $current_page_number_class . ':hover'
			),
			'title'       => __( 'Hover text colour', 'wpjobster' ),
			'default'     => '#fff',
			'color_alpha' => true
		),
		array(
			'id'       => 'user_account_pagination_current_page_number_border',
			'type'     => 'border',
			'all'      => true,
			'compiler'   => array( $current_page_number_class ),
			'title'    => esc_html__( 'Border', 'wpjobster' ),
			'default'  => array(
				'border-color'  => '#20c497',
				'border-style'  => 'solid',
				'border-width'  => '2px'
			)
		),

	/* NEXT PAGE NUMBER */

		array(
			'id'       => 'user-account-pagination-next-page-number-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Pagination - next page number', 'wpjobster' ),
			'indent'   => true
		),
		array(
			'id'          => 'user_account_pagination_next_page_number_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => $next_page_number_class
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#fff',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_pagination_next_page_number_hover_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => $next_page_number_class . ':hover'
			),
			'title'       => __( 'Hover background colour', 'wpjobster' ),
			'default'     => '#fff',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_pagination_next_page_number_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => $next_page_number_class
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true
		),
		array(
			'id'          => 'user_account_pagination_next_page_number_text_hover_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => $next_page_number_class . ':hover'
			),
			'title'       => __( 'Hover text colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true
		),
		array(
			'id'       => 'user_account_pagination_next_page_number_border',
			'type'     => 'border',
			'all'      => true,
			'compiler'   => array( $next_page_number_class ),
			'title'    => esc_html__( 'Border', 'wpjobster' ),
			'default'  => array(
				'border-color'  => '#20c497',
				'border-style'  => 'solid',
				'border-width'  => '2px'
			)
		)

	)
) );