<?php /* Notify */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Notify', 'wpjobster' ),
	'id'         => 'notify-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'notify-messages-scroll-down-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Messages - Scroll down icon', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'messages_scroll_down_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable button', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'messages_scroll_down_button_icon',
			'type'     => 'text',
			'title'    => __( 'Icon', 'wpjobster' ),
			'default'  => 'arrow down',
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' ),
		),
		array(
			'id'          => 'messages_scroll_down_button_icon_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.scroll-down-wrapper'
			),
			'title'       => __( 'Icon background colour', 'wpjobster' ),
			'default'     => '#466194',
			'color_alpha' => true,
			'required'    => array( 'messages_scroll_down_enable', '=', true )
		),
		array(
			'id'          => 'messages_scroll_down_button_icon_bg_hover_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.scroll-down-wrapper:hover'
			),
			'title'       => __( 'Icon background hover colour', 'wpjobster' ),
			'default'     => '#466194',
			'color_alpha' => true,
			'required'    => array( 'messages_scroll_down_enable', '=', true )
		),
		array(
			'id'          => 'messages_scroll_down_button_icon_colour_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.scroll-down-wrapper'
			),
			'title'       => __( 'Icon colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
			'required'    => array( 'messages_scroll_down_enable', '=', true )
		),
		array(
			'id'          => 'messages_scroll_down_button_icon_hover_colour_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.scroll-down-wrapper:hover'
			),
			'title'       => __( 'Icon hover colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
			'required'    => array( 'messages_scroll_down_enable', '=', true )
		),

		array(
			'id'      => 'messages_scroll_down_button_icon_border',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.scroll-down-wrapper' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color' => '#466194',
				'border-style' => 'solid',
				'border-width' => '0px'
			),
		),
		array(
			'id'             => 'messages_scroll_down_button_icon_border_radius',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '50',
				'units' => '%',
			)
		),
		array(
			'id'             => 'messages_scroll_down_button_icon_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => false,
			'word-spacing'   => false,
			'letter-spacing' => false,
			'font-style'     => false,
			'font-weight'    => false,
			'font-family'    => false,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => true,
			'default'        => array(
				'font-size'   => '18px',
				'line-height' => '35px',
				'text-align'  => 'center',
			),
			'compiler' => array( '.scroll-down-wrapper' ),
		),
		array(
			'id'             => 'messages_scroll_down_button_icon_dimensions',
			'type'           => 'dimensions',
			'units'          => array( 'px', '%' ),
			'title'          => esc_html__( 'Dimensions', 'wpjobster' ),
			'default'        => array(
				'width'  => 35,
				'height' => 35
			),
			'compiler'         => array( '.scroll-down-wrapper' )
		)
	)
) );