<?php /* Request */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Request', 'wpjobster' ),
	'id'         => 'request-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'           => 'lets_meet_rich_icon_options_request',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Let\'s meet image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),

/* DESCRIPTION */

		array(
			'id'       => 'request-presentation-description-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Request presentation - Description', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'             => 'request-description-typography-settings',
			'type'           => 'typography',
			'title'          => esc_html__( 'Font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => true,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => false,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'default'        => array(
				'font-family' => 'Poppins',
				'font-size'   => '14px',
				'color'       => '#898eb4',
				'line-height' => '22px'
			),
			'compiler' => array( '.request-description *, .single-request-description *' )
		),

/* INSTRUCTIONS */

		array(
			'id'       => 'post-new-request-instructions-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Post new - Instructions', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'request_instructions_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.ui.form .post-new-wrapper.post-new-request-wrapper .ui.popup:not([class*="ui popup calendar"]),
					.ui.form .post-new-wrapper.post-new-request-form-row-wrapper .ui.popup:not([class*="ui popup calendar"]),
					.ui.form .post-new-wrapper.post-new-request-wrapper .ui.popup:not([class*="ui popup calendar"]):before,
					.ui.form .post-new-wrapper.post-new-request-form-row-wrapper .ui.popup:not([class*="ui popup calendar"]):before
				'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#c4ffef',
			'color_alpha' => true,
		),
		array(
			'id'          => 'request_instructions_border_colour',
			'type'        => 'color',
			'compiler'      => array(
				'border-color' => '
					.ui.form .post-new-wrapper.post-new-request-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input),
					.ui.form .post-new-wrapper.post-new-request-form-row-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input)
				'
			),
			'title'       => __( 'Border colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		),
		array(
			'id'            => 'request_instructions_arrow_colour',
			'type'          => 'box_shadow',
			'title'         => __( 'Arrow colour', 'wpjobster' ),
			'units'         => 'px',
			'display_units' => false,
			'preview'       => false,
			'opacity'       => true,
			'rgba'          => true,
			'default'       => array (
				'horizontal'   => '-2px',
				'vertical'     => '2px',
				'blur'         => '0px',
				'spread'       => '0px',
				'opacity'      => '1',
				'shadow-color' => '#20c497',
				'shadow-type'  => 'outside',
			),
			'compiler'        => array(
				'.ui.form .post-new-wrapper.post-new-request-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input):before',
				'.ui.form .post-new-wrapper.post-new-request-form-row-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input):before'
			),
		),
		array(
			'id'          => 'request_instructions_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.ui.form .post-new-wrapper.post-new-request-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input),
					.ui.form .post-new-wrapper.post-new-request-form-row-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input)
				'
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => 'rgba(0, 0, 0, 0.87)',
			'color_alpha' => true,
		),
		array(
			'id'             => 'request_instructions_box_spacing',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => 'px',
			'display_units'  => false,
			'title'          => __( 'Box spacing', 'wpjobster' ),
			'subtitle'       => __( 'For spacing you can use only px', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '30',
				'padding-right'  => '30',
				'padding-bottom' => '30',
				'padding-left'   => '30',
				'units'          => 'px',
			),
			'compiler'        => array(
				'.ui.form .post-new-wrapper.post-new-request-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input)',
				'.ui.form .post-new-wrapper.post-new-request-form-row-wrapper .ui.popup:not([class*="ui popup calendar"]):not(.rejected-input)'
			),
		),
		array(
			'id'           => 'request_instructions_box_icon',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Icon', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),

/* SUBCATEGORIES */

		array(
			'id'       => 'request-subcategories-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Subcategories listing', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'request_subcategories_slider',
			'type'     => 'switch',
			'title'    => __( 'Display as slider', 'wpjobster' ),
			'subtitle' => __( 'Present the subcategories as a slider within a single row when they exceed the row\'s capacity, rather than spreading them across multiple rows.', 'wpjobster' ),
			'default'  => false
		),
		array(
			'id'          => 'request_subcategories_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.request-subcategories.subcategory-listing ul li a'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'request_subcategories_hover_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.request-subcategories.subcategory-listing ul li a:hover'
			),
			'title'       => __( 'Hover background colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'request_subcategories_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.request-subcategories.subcategory-listing ul li a, .request-subcategories.subcategory-listing ul li a:visited, .request-subcategories.subcategory-listing ul li a:focus'
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => '#abb0d1',
			'color_alpha' => true,
		),
		array(
			'id'          => 'request_subcategories_text_hover_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.request-subcategories.subcategory-listing ul li a:hover'
			),
			'title'       => __( 'Hover text colour', 'wpjobster' ),
			'default'     => '#abb0d1',
			'color_alpha' => true,
		),
		array(
			'id'      => 'request_subcategories_border',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.request-subcategories.subcategory-listing ul li a' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#bfc3e0',
				'border-style'  => 'solid',
				'border-width'  => '2px'
			),
		),
		array(
			'id'             => 'request_subcategories_border_radius',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '6',
				'units' => 'px',
			)
		),
		array(
			'id'             => 'request_subcategories_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => false,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => true,
			'text-shadow'    => true,
			'default'        => array(
				'font-family'       => 'Poppins',
				'font-size'         => '14px',
				'font-weight'       => 600,
				'line-height'       => '21px',
				'text-transform'    => 'none',
				'shadow-color'      => '#abb0d1',
				'shadow-horizontal' => 0,
				'shadow-vertical'   => 0,
				'shadow-blur'       => 0,
			),
			'compiler' => array( '.request-subcategories.subcategory-listing ul li a' ),
		),
		array(
			'id'             => 'request_subcategories_padding',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Padding', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '8',
				'padding-right'  => '12',
				'padding-bottom' => '8',
				'padding-left'   => '12',
				'units'          => 'px',
			),
			'compiler'         => array( '.request-subcategories.subcategory-listing ul li a' ),
		),
		array(
			'id'             => 'request_subcategories_margin',
			'type'           => 'spacing',
			'mode'           => 'margin',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Margin', 'wpjobster' ),
			'default'        => array(
				'margin-top'    => '0',
				'margin-right'  => '6',
				'margin-bottom' => '6',
				'margin-left'   => '0',
				'units'          => 'px',
			),
			'compiler'         => array( '.request-subcategories.subcategory-listing ul li' ),
		),
	)
) );