<?php /* User Account */

Redux::setSection( $opt_name, array(
	'title'      => __( 'User Account', 'wpjobster' ),
	'id'         => 'user-account-settings',
	'subsection' => true,
	'fields'     => array(

/* GRAPH */

		array(
			'id'       => 'user-account-graph-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Graph', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'user_account_graph_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.user-graph-wrapper'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#f1f3f8',
			'color_alpha' => true,
		),
		array(
			'id'      => 'user_account_graph_border',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.user-graph-wrapper' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color' => '#d8dcea',
				'border-style' => 'solid',
				'border-width' => '1px'
			),
		),
		array(
			'id'             => 'user_account_labels_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Labels font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => true,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => true,
			'text-shadow'    => true,
			'default'        => array(
				'font-family'       => 'Poppins',
				'font-size'         => '13px',
				'font-weight'       => 700,
				'color'             => '#898eb4',
				'line-height'       => '24px',
				'text-transform'    => 'uppercase',
				'shadow-color'      => '#898eb4',
				'shadow-horizontal' => 0,
				'shadow-vertical'   => 0,
				'shadow-blur'       => 0,
			),
			'compiler' => array( '.user-graph-table-wrapper.ui.list .label' ),
		),
		array(
			'id'             => 'user_account_numbers_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Numbers font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => true,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => true,
			'text-shadow'    => true,
			'default'        => array(
				'font-family'       => 'Poppins',
				'font-size'         => '24px',
				'font-weight'       => 700,
				'color'             => '#20c497',
				'line-height'       => '29px',
				'text-transform'    => 'uppercase',
				'shadow-color'      => '#20c497',
				'shadow-horizontal' => 0,
				'shadow-vertical'   => 0,
				'shadow-blur'       => 0,
			),
			'compiler' => array( '.user-graph-table-wrapper.ui.list .value' ),
		),
		array(
			'id'       => 'user_account_icon_name',
			'type'     => 'text',
			'title'    => __( 'Icon name', 'wpjobster' ),
			'default'  => 'chart line',
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' )
		),
		array(
			'id'             => 'user_account_icon_font_size',
			'type'           => 'typography',
			'title'          => esc_html__( 'Icon font size', 'wpjobster' ),
			'google'         => false,
			'line-height'    => false,
			'color'          => false,
			'word-spacing'   => false,
			'letter-spacing' => false,
			'font-family'    => false,
			'font-style'     => false,
			'font-weight'    => false,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => false,
			'text-shadow'    => false,
			'default'        => array(
				'font-size' => '18px'
			),
			'compiler' => array( '.user-chart-wrapper .graph-link i' ),
		),
		array(
			'id'      => 'user_account_icon_colour',
			'type'    => 'link_color',
			'title'   => __( 'Icon colour', 'wpjobster' ),
			'focus'   => false,
			'active'  => false,
			'visited' => false,
			'default' => array(
				'regular' => '#898eb4',
				'hover'   => '#898eb4'
			),
			'color_alpha' => true,
			'compiler'    => array( '.user-chart-wrapper .graph-link i' ),
		),

/* SIDEBAR */

		array(
			'id'       => 'user-account-sidebar-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Sidebar', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'user_account_sidebar_style',
			'type'     => 'select',
			'title'    => esc_html__( 'Header style', 'wpjobster' ),
			'options'  => array(
				'inline' => esc_attr__( 'Inline', 'wpjobster' ),
				'block'  => esc_attr__( 'Block', 'wpjobster' ),
			),
			'default'  => 'inline',
		),
		array(
			'id'          => 'user_account_sidebar_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.user-sidebars-wrapper .user-info-sidebar-wrapper'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#f6f7fa',
			'color_alpha' => true,
		),
		array(
			'id'      => 'user_account_sidebar_border',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.user-sidebars-wrapper .user-info-sidebar-wrapper' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color' => '#d8dcea',
				'border-style' => 'solid',
				'border-width' => '1px'
			),
		),
		array(
			'id'      => 'user_account_sidebar_separators',
			'type'    => 'border',
			'all'     => true,
			'left'    => false,
			'bottom'  => false,
			'right'   => false,
			'compiler'  => array(
				'border-top' => '.user-productivity .row',
			),
			'title'   => esc_html__( 'Separators', 'wpjobster' ),
			'default' => array(
				'border-color' => '#d8dcea',
				'border-style' => 'solid',
				'border-width' => '1px'
			),
		),
		array(
			'id'             => 'user_account_sidebar_border_radius',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '6',
				'units' => 'px',
			)
		),
		array(
			'id'             => 'user_account_sidebar_header_spacing',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => 'px',
			'display_units'  => false,
			'title'          => __( 'Header spacing', 'wpjobster' ),
			'subtitle'       => __( 'For spacing you can use only px', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '25',
				'padding-right'  => '25',
				'padding-bottom' => '25',
				'padding-left'   => '25',
				'units'          => 'px',
			),
			'compiler'         => array( '.user-info-simple-wrapper' ),
		),
		array(
			'id'             => 'user_account_sidebar_header_username_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Header username font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => true,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => true,
			'text-shadow'    => true,
			'default'        => array(
				'font-family'       => 'Poppins',
				'font-size'         => '18px',
				'font-weight'       => 700,
				'color'             => '#313546',
				'line-height'       => '18px',
				'text-transform'    => 'none',
				'shadow-color'      => '#313546',
				'shadow-horizontal' => 0,
				'shadow-vertical'   => 0,
				'shadow-blur'       => 0,
			),
			'compiler' => array( '.user-info-simple-wrapper .user-info-simple-content .user-name' ),
		),
		array(
			'id'             => 'user_account_sidebar_header_rating_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Header rating messages font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => true,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => true,
			'text-shadow'    => false,
			'default'        => array(
				'font-family'       => 'Poppins',
				'font-size'         => '14px',
				'font-weight'       => 400,
				'color'             => '#313546',
				'line-height'       => '21px',
				'text-transform'    => 'none'
			),
			'compiler' => array( '.user-info-simple-content .user-stars span' ),
		),
		array(
			'id'             => 'user_account_sidebar_body_spacing',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => 'px',
			'display_units'  => false,
			'title'          => __( 'Body spacing', 'wpjobster' ),
			'subtitle'       => __( 'For spacing you can use only px', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '0',
				'padding-right'  => '0',
				'padding-bottom' => '0',
				'padding-left'   => '0',
				'units'          => 'px',
			),
			'compiler'         => array( '.user-productivity' ),
		),
		array(
			'id'             => 'user_account_sidebar_body_items_spacing',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => 'px',
			'display_units'  => false,
			'title'          => __( 'Body items spacing', 'wpjobster' ),
			'subtitle'       => __( 'For spacing you can use only px', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '10',
				'padding-right'  => '25',
				'padding-bottom' => '10',
				'padding-left'   => '25',
				'units'          => 'px',
			),
			'compiler'         => array( '.user-productivity .row' ),
		),
		array(
			'id'             => 'user_account_sidebar_body_items_title_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Body items title font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => true,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => true,
			'default'        => array(
				'font-family'       => 'Poppins',
				'font-size'         => '12px',
				'font-weight'       => 700,
				'color'             => '#898eb4',
				'line-height'       => '21px',
				'text-transform'    => 'uppercase'
			),
			'compiler' => array( '.user-productivity .row label' ),
		),
		array(
			'id'             => 'user_account_sidebar_body_items_value_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Body items value font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => true,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => false,
			'text-transform' => true,
			'default'        => array(
				'font-family'       => 'Poppins',
				'font-size'         => '14px',
				'font-weight'       => 400,
				'color'             => '#454a60',
				'line-height'       => '21px',
				'text-transform'    => 'none'
			),
			'compiler' => array( '.user-productivity .row .progress-wrapper .progress-percent' ),
		),
		array(
			'id'          => 'user_account_sidebar_progress_bar_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.user-sidebars-wrapper .user-productivity .progress-wrapper .ui.progress'
			),
			'title'       => __( 'Body progress bar colour', 'wpjobster' ),
			'default'     => 'rgba(0, 0, 0, 0.1)',
			'color_alpha' => true,
		),
		array(
			'id'          => 'user_account_sidebar_progress_bar_active_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.user-sidebars-wrapper .user-productivity .progress-wrapper .ui.progress .bar,
					.user-sidebars-wrapper .user-productivity .progress-wrapper .ui.progress.success .bar
				'
			),
			'title'       => __( 'Body active progress bar colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		)
	)
) );