<?php /* User */

Redux::setSection( $opt_name, array(
	'title'      => __( 'User', 'wpjobster' ),
	'id'         => 'user-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'           => 'no_image_icon_options_user',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'User - no image', 'wpjobster' ),
			'subtitle'     => __( 'After you change the image, please go to Dashboard -> Settings -> Discussion -> Avatars -> Default Avatar -> Select "Default WPJ Avatar" -> Save Changes.', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),
		array(
			'id'       => 'email_verified_icon_options_user',
			'type'     => 'text',
			'title'    => __( 'Email verified icon', 'wpjobster' ),
			'default'  => 'envelope outline',
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' )
		),
		array(
			'id'       => 'avatar-user-level-icons-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Avatar thumbnail - User level icons', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'           => 'level0_icon_options_user',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Level 0 - New', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),
		array(
			'id'           => 'level1_icon_options_user',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Level 1 - Rookie', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),
		array(
			'id'           => 'level2_icon_options_user',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Level 2 - Master', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),
		array(
			'id'           => 'level3_icon_options_user',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Level 3 - Top Rated', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),
	)
) );