<?php /* Currency */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Currency', 'wpjobster' ),
	'id'         => 'footer-currency-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'footer_currency_icon_name',
			'type'     => 'text',
			'title'    => __( 'Selector icon', 'wpjobster' ),
			'default'  => 'exchange',
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' )
		),
		array(
			'id'          => 'footer_currency_icon_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.footer-bottom .footer-col-currency .dropdown-menu .trigger-icon
				'
			),
			'title'       => __( 'Icon colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		),
		array(
			'id'          => 'footer_currency_icon_colour_hover',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.footer-wrapper .currency:hover .trigger-icon
				'
			),
			'title'       => __( 'Hover icon colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		),
		array(
			'id'          => 'footer_currency_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.footer-wrapper .currency .trigger-text
				'
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => 'rgba(0, 0, 0, 0.6)',
			'color_alpha' => true,
		),
		array(
			'id'          => 'footer_currency_text_colour_hover',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.footer-wrapper .currency:hover .trigger-text
				'
			),
			'title'       => __( 'Text hover colour', 'wpjobster' ),
			'default'     => 'rgba(0, 0, 0, 0.8)',
			'color_alpha' => true,
		),
		array(
			'id'          => 'footer_currency_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.footer-wrapper .dropdown-menu.currency
				'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#FFFFFF',
			'color_alpha' => true,
		),
		array(
			'id'          => 'footer_currency_bg_colour_hover',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.footer-wrapper .dropdown-menu.currency:hover
				'
			),
			'title'       => __( 'Background hover colour', 'wpjobster' ),
			'default'     => '#FFFFFF',
			'color_alpha' => true,
		),
		array(
			'id'      => 'currency_select_border_footer',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.footer-wrapper .currency' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => 'rgba(34, 36, 38, 0.15)',
				'border-style'  => 'solid',
				'border-width'  => '1px'
			),
		),
	)
) );