<?php /* Footer */

Redux::setSection( $opt_name, array(
	'title'  => __( 'Footer', 'wpjobster' ),
	'id'     => 'footer-settings',
	'icon'   => 'el el-chevron-down',
	'fields' => array(
		array(
			'id'       => 'footer_in_grid',
			'type'     => 'switch',
			'title'    => __( 'Footer in grid', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'select_number_cols',
			'type'     => 'select',
			'title'    => esc_html__( 'Footer columns number', 'wpjobster' ),
			'options'  => array(
				'2' => esc_attr__( '2 Columns', 'wpjobster' ),
				'3' => esc_attr__( '3 Columns', 'wpjobster' ),
				'4' => esc_attr__( '4 Columns', 'wpjobster' ),
				'5' => esc_attr__( '5 Columns', 'wpjobster' ),
				'6' => esc_attr__( '6 Columns', 'wpjobster' ),
			),
			'default'  => '5',
		),
		array(
			'id'       => 'footer_columns_same_row',
			'type'     => 'switch',
			'title'    => esc_html__( 'All columns in the same row', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'copyright_text',
			'type'     => 'text',
			'title'    => __( 'Copyright', 'wpjobster' ),
			'default'  => sprintf( esc_attr__( '&copy; %d ', 'wpjobster' ), date( 'Y' ) ) . '<a href="http://wpjobster.com">wpjobster.com</a>',
		),
		array(
			'id'       => 'footer-apps-links-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Mobile application', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'           => 'android_app_image',
			'type'         => 'media',
			'url'          => true,
			'title'        => __( 'Google Play - Image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),
		array(
			'id'       => 'android_app_link',
			'type'     => 'text',
			'title'    => __( 'Google Play - App Link', 'wpjobster' ),
			'subtitle' => __( 'Save the field as empty if you do not have applications or if you do not want this icon to appear in the footer.', 'wpjobster' ),
			'default'  => 'https://play.google.com/store/apps/details?id=com.wpjobster.demo&hl=en',
		),
		array(
			'id'           => 'iphone_app_image',
			'type'         => 'media',
			'url'          => true,
			'title'        => __( 'iTunes - Apple - Image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),
		array(
			'id'       => 'iphone_app_link',
			'type'     => 'text',
			'title'    => __( 'iTunes - Apple - App Link', 'wpjobster' ),
			'subtitle' => __( 'Save the field as empty if you do not have applications or if you do not want this icon to appear in the footer.', 'wpjobster' ),
			'default'  => 'https://itunes.apple.com/us/app/jobster-marketplace/id1447971619',
		),
		array(
			'id'       => 'footer-top-border-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Top border', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'footer_top_border',
			'type'     => 'switch',
			'title'    => __( 'Show footer top border', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'      => 'footer_top_border_colour',
			'type'    => 'border',
			'all'     => true,
			'left'    => false,
			'bottom'  => false,
			'right'   => false,
			'compiler'  => array(
				'border-top' => '.footer-wrapper',
			),
			'title'   => esc_html__( 'Footer top border', 'wpjobster' ),
			'default' => array(
				'border-color'  => 'rgba(34, 36, 38, 0.15)',
				'border-style'  => 'solid',
				'border-width'  => '3px'
			),
			'required'    => array( 'footer_top_border', '=', true )
		),
		array(
			'id'       => 'footer-bottom-border-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Bottom border', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'      => 'footer_bottom_border_colour',
			'type'    => 'border',
			'all'     => true,
			'left'    => false,
			'bottom'  => false,
			'right'   => false,
			'compiler'  => array(
				'border-top' => '.footer-bottom',
			),
			'title'   => esc_html__( 'Footer bottom border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#e8ebf6',
				'border-style'  => 'solid',
				'border-width'  => '1px'
			)
		),
		array(
			'id'       => 'footer-background-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Footer background', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'footer_background_type',
			'type'     => 'select',
			'title'    => esc_html__( 'Background type', 'wpjobster' ),
			'options'  => array(
				'colour' => esc_attr__( 'Colour', 'wpjobster' ),
				'image'  => esc_attr__( 'Image', 'wpjobster' ),
			),
			'default'  => 'colour',
		),
		array(
			'id'           => 'footer_background_image',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
			'required'     => array( 'footer_background_type', '=', 'image' )
		),
		array(
			'id'            => 'footer_background_image_overlay',
			'type'          => 'box_shadow',
			'title'         => __( 'Overlay', 'wpjobster' ),
			'units'         => 'px',
			'display_units' => false,
			'preview'       => false,
			'opacity'       => true,
			'rgba'          => true,
			'required'      => array( 'footer_background_type', '=', 'image' ),
			'default'       => array (
				'horizontal'   => '0px',
				'vertical'     => '0px',
				'blur'         => '0px',
				'spread'       => '2000px',
				'opacity'      => '.1',
				'shadow-color' => '#000000',
				'shadow-type'  => 'inset',
			),
			'compiler'        => array( '.footer-wrapper' )
		),
		array(
			'id'          => 'footer_top_background',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.footer-wrapper',
			),
			'title'       => esc_html__( 'Top background', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
			'required'     => array( 'footer_background_type', '=', 'colour' )
		),
		array(
			'id'          => 'footer_bottom_background',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.footer-bottom',
			),
			'title'       => esc_html__( 'Bottom background', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
			'required'     => array( 'footer_background_type', '=', 'colour' )
		)
	)
) );