<?php /* Scroll to TOP */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Scroll to Top', 'wpjobster' ),
	'id'         => 'scroll-to-top-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'scroll_to_top_enable',
			'type'     => 'switch',
			'title'    => __( 'Enable button', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'          => 'scroll_to_top_background',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.scroll-to-top-wrapper .scrollToTop'
			),
			'title'       => esc_html__( 'Background colour', 'wpjobster' ),
			'default'     => 'transparent',
			'color_alpha' => true,
			'required'    => array( 'scroll_to_top_enable', '=', true )
		),
		array(
			'id'      => 'scroll_icon_color',
			'type'    => 'link_color',
			'title'   => __( 'Icon colour', 'wpjobster' ),
			'active'  => false,
			'visited' => false,
			'default' => array(
				'regular' => '#c1c1c1',
				'hover'   => '#20c497',
			),
			'compiler' => array( '.scroll-to-top-wrapper .scrollToTop' ),
			'required' => array( 'scroll_to_top_enable', '=', true )
		),
		array(
			'id'       => 'scroll_to_top_border',
			'type'     => 'border',
			'title'    => esc_html__( 'Border', 'wpjobster' ),
			'compiler'   => array( '.scroll-to-top-wrapper .scrollToTop' ),
			'default'  => array(
				'border-color'  => '#737B88',
				'border-style'  => 'solid',
				'border-top'    => '0px',
				'border-right'  => '0px',
				'border-bottom' => '0px',
				'border-left'   => '0px',
			),
			'required' => array( 'scroll_to_top_enable', '=', true )
		)
	)
) );