<?php /* Social Media */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Social Media', 'wpjobster' ),
	'id'         => 'footer-social-media-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'           => 'social_media_list',
			'type'         => 'repeater',
			'title'        => __( 'Add new social media', 'wpjobster' ),
			'item_name'    => __( 'icon', 'wpjobster' ),
			'group_values' => true,
			'fields'       => array(
				array(
					'id'       => 'social_media_icon_name',
					'type'     => 'text',
					'title'    => __( 'Icon name', 'wpjobster' ),
					'subtitle' => sprintf( __( 'Example: facebook, twitter square, google plus g, instagram.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' ),
					'default'  => 'facebook f'
				),
				array(
					'id'       => 'social_media_link',
					'type'     => 'text',
					'title'    => __( 'Link', 'wpjobster' ),
					'default'  => '#'
				),
			)
		),
		array(
			'id'          => 'social_media_colour_options_footer',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.footer-start-content .footer-col-social-media ul li a'
			),
			'title'       => __( 'Colour', 'wpjobster' ),
			'default'     => '#898eb4',
			'color_alpha' => true,
		),
		array(
			'id'          => 'social_media_hover_colour_options_footer',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.footer-start-content .footer-col-social-media ul li:hover a i
				'
			),
			'title'       => __( 'Hover colour', 'wpjobster' ),
			'default'     => '#898eb4',
			'color_alpha' => true,
		),
		array(
			'id'          => 'social_media_bg_colour_options_footer',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.footer-start-content .footer-col-social-media ul li a
				'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => 'transparent',
			'color_alpha' => true,
		),
		array(
			'id'          => 'social_media_bg_hover_colour_options_footer',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.footer-start-content .footer-col-social-media ul li:hover a
				'
			),
			'title'       => __( 'Background hover colour', 'wpjobster' ),
			'default'     => 'transparent',
			'color_alpha' => true,
		),
		array(
			'id'      => 'social_media_border_footer',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.footer-start-content .footer-col-social-media ul li a' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#898eb4',
				'border-style'  => 'solid',
				'border-width'  => '2px'
			),
		),
	)
) );