<?php /* General */

Redux::setSection( $opt_name, array(
	'title'  => __( 'General', 'wpjobster' ),
	'id'     => 'general-settings',
	'icon'   => 'el el-adjust-alt',
	'fields' => array(
		array(
			'id'       => 'site-layout-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Layout', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'             => 'site_width',
			'type'           => 'dimensions',
			'units'          => array( 'px', '%' ),
			'title'          => esc_html__( 'Site width', 'wpjobster' ),
			'height'         => false,
			'default'        => array(
				'width'  => 1400,
				'--width' => 1400
			),
			'compiler'         => array( 'body .main-content' )
		),
		array(
			'id'       => 'page-transition-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Page transition', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'site_page_transition',
			'type'     => 'select',
			'title'    => esc_html__( 'Transition', 'wpjobster' ),
			'options'  => array(
				'regular'   => esc_attr__( 'Regular', 'wpjobster' ),
				'animation' => esc_attr__( 'Animation', 'wpjobster' )
			),
			'default'  => 'animation',
		),
		array(
			'id'       => 'site_page_transition_effect',
			'type'     => 'select',
			'title'    => esc_html__( 'Effect', 'wpjobster' ),
			'options'  => array(
				'blind'     => esc_attr__( 'Blind', 'wpjobster' ),
				'bounce'    => esc_attr__( 'Bounce', 'wpjobster' ),
				'clip'      => esc_attr__( 'Clip', 'wpjobster' ),
				'drop'      => esc_attr__( 'Drop', 'wpjobster' ),
				'explode'   => esc_attr__( 'Explode', 'wpjobster' ),
				'fade'      => esc_attr__( 'Fade', 'wpjobster' ),
				'fold'      => esc_attr__( 'Fold', 'wpjobster' ),
				'highlight' => esc_attr__( 'Highlight', 'wpjobster' ),
				'puff'      => esc_attr__( 'Puff', 'wpjobster' ),
				'pulsate'   => esc_attr__( 'Pulsate', 'wpjobster' ),
				'scale'     => esc_attr__( 'Scale', 'wpjobster' ),
				'shake'     => esc_attr__( 'Shake', 'wpjobster' ),
				'size'      => esc_attr__( 'Size', 'wpjobster' ),
				'slide'     => esc_attr__( 'Slide', 'wpjobster' ),
			),
			'default'  => 'fade',
			'required' => array( 'site_page_transition', '=', 'animation' )
		),
		array(
			'id'       => 'site_page_transition_effect_direction',
			'type'     => 'select',
			'title'    => esc_html__( 'Direction', 'wpjobster' ),
			'options'  => array(
				'up'    => esc_attr__( 'Up', 'wpjobster' ),
				'down'  => esc_attr__( 'Down', 'wpjobster' ),
				'left'  => esc_attr__( 'Left', 'wpjobster' ),
				'right' => esc_attr__( 'Right', 'wpjobster' ),
			),
			'default'  => 'down',
			'required' => array( 'site_page_transition_effect', '=', array( 'blind', 'drop', 'shake', 'slide' ) )
		),
		array(
			'id'          => 'site_page_transition_effect_color',
			'type'        => 'color',
			'title'       => __( 'Colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
			'required' => array( 'site_page_transition_effect', '=', 'highlight' )
		),
		array(
			'id'       => 'loading-bar-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Loading bar', 'wpjobster' ),
			'indent'   => true
		),
		array(
			'id'      => 'loading_bar_style',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array(
				'border' => 'body .pace .pace-progress',
			),
			'title'   => esc_html__( 'Style', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#20c497',
				'border-style'  => 'solid',
				'border-width'  => '2px'
			)
		),
	)
) );