<?php /* Authentication buttons */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Authentication Buttons', 'wpjobster' ),
	'id'         => 'header-auth-buttons-settings',
	'subsection' => true,
	'fields'     => array(

/* LOGIN */

		array(
			'id'       => 'header-auth-buttons-login-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Login', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'login_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.home.without-header:not(.logged-in) .header-wrapper-top.fixed .login-link.text-button.text-button-simple,
					.header-wrapper-top .login-link.text-button.text-button-simple
				'
			),
			'title'       => __( 'Colour', 'wpjobster' ),
			'default'     => '#39496a',
			'color_alpha' => true,
		),
		array(
			'id'          => 'login_hover_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.home.without-header:not(.logged-in) .header-wrapper-top.fixed .login-link.text-button.text-button-simple:hover,
					.header-wrapper-top .login-link.text-button.text-button-simple:hover
				'
			),
			'title'       => __( 'Hover colour', 'wpjobster' ),
			'default'     => '#39496a',
			'color_alpha' => true,
		),
		array(
			'id'          => 'login_bg_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.home.without-header:not(.logged-in) .header-wrapper-top.fixed .login-link.text-button.text-button-simple,
					.header-wrapper-top .login-link.text-button.text-button-simple
				'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => 'rgba(255, 255, 255, 0)',
			'color_alpha' => true,
		),
		array(
			'id'          => 'login_bg_hover_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.home.without-header:not(.logged-in) .header-wrapper-top.fixed .login-link.text-button.text-button-simple:hover,
					.header-wrapper-top .login-link.text-button.text-button-simple:hover
				'
			),
			'title'       => __( 'Background hover colour', 'wpjobster' ),
			'default'     => 'rgba(255, 255, 255, 0)',
			'color_alpha' => true,
		),
		array(
			'id'      => 'login_border_header',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array(
				'.home.without-header:not(.logged-in) .header-wrapper-top.fixed .login-link.text-button.text-button-simple',
				'.header-wrapper-top .login-link.text-button.text-button-simple'
			),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => 'rgba(255, 255, 255, 0)',
				'border-style'  => 'solid',
				'border-width'  => '0px'
			),
		),
		array(
			'id'             => 'login_border_radius_header',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '6',
				'units' => 'px',
			)
		),
		array(
			'id'             => 'login_padding_header',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Padding', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '12',
				'padding-right'  => '25',
				'padding-bottom' => '12',
				'padding-left'   => '25',
				'units'          => 'px',
			),
			'compiler'  => array(
				'.home.without-header:not(.logged-in) .header-wrapper-top.fixed .login-link.text-button.text-button-simple',
				'.header-wrapper-top .login-link.text-button.text-button-simple'
			),
		),
		array(
			'id'             => 'login_margin_header',
			'type'           => 'spacing',
			'mode'           => 'margin',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Margin', 'wpjobster' ),
			'default'        => array(
				'margin-top'    => '0',
				'margin-right'  => '0',
				'margin-bottom' => '0',
				'margin-left'   => '0',
				'units'         => 'px',
			),
			'compiler'  => array(
				'.home.without-header:not(.logged-in) .header-wrapper-top.fixed .login-link.text-button.text-button-simple',
				'.header-wrapper-top .login-link.text-button.text-button-simple'
			),
		),

/* LOGIN - FRONT PAGE */

		array(
			'id'       => 'header-auth-buttons-login-front-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Login - Front page', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'login_front_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.home.without-header:not(.logged-in) .header-wrapper-top .login-link.text-button.text-button-simple'
			),
			'title'       => __( 'Colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'login_front_hover_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.home.without-header:not(.logged-in) .header-wrapper-top .login-link.text-button.text-button-simple:hover'
			),
			'title'       => __( 'Hover colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'login_front_bg_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.home.without-header:not(.logged-in) .header-wrapper-top .login-link.text-button.text-button-simple'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => 'rgba(255, 255, 255, 0)',
			'color_alpha' => true,
		),
		array(
			'id'          => 'login_front_bg_hover_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.home.without-header:not(.logged-in) .header-wrapper-top .login-link.text-button.text-button-simple:hover'
			),
			'title'       => __( 'Background hover colour', 'wpjobster' ),
			'default'     => 'rgba(255, 255, 255, 0)',
			'color_alpha' => true,
		),
		array(
			'id'      => 'login_front_border_header',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.home.without-header:not(.logged-in) .header-wrapper-top .login-link.text-button.text-button-simple' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => 'rgba(255, 255, 255, 0)',
				'border-style'  => 'solid',
				'border-width'  => '0px'
			),
		),
		array(
			'id'             => 'login_front_border_radius_header',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '6',
				'units' => 'px',
			)
		),
		array(
			'id'             => 'login_front_padding_header',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Padding', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '12',
				'padding-right'  => '25',
				'padding-bottom' => '12',
				'padding-left'   => '25',
				'units'          => 'px',
			),
			'compiler'  => array( '.home.without-header:not(.logged-in) .header-wrapper-top .login-link.text-button.text-button-simple' ),
		),
		array(
			'id'             => 'login_front_margin_header',
			'type'           => 'spacing',
			'mode'           => 'margin',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Margin', 'wpjobster' ),
			'default'        => array(
				'margin-top'    => '0',
				'margin-right'  => '0',
				'margin-bottom' => '0',
				'margin-left'   => '0',
				'units'         => 'px',
			),
			'compiler'  => array( '.home.without-header:not(.logged-in) .header-wrapper-top .login-link.text-button.text-button-simple' ),
		),

/* REGISTER */

		array(
			'id'       => 'header-auth-buttons-register-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Register', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'register_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.home.without-header:not(.logged-in) .header-wrapper-top.fixed .register-link.text-button,
					.header-wrapper-top .register-link.text-button
				'
			),
			'title'       => __( 'Colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'register_hover_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.home.without-header:not(.logged-in) .header-wrapper-top.fixed .register-link.text-button:hover,
					.header-wrapper-top .register-link.text-button:hover
				'
			),
			'title'       => __( 'Hover colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'register_bg_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.home.without-header:not(.logged-in) .header-wrapper-top.fixed .register-link.text-button,
					.header-wrapper-top .register-link.text-button
				'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		),
		array(
			'id'          => 'register_bg_hover_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.home.without-header:not(.logged-in) .header-wrapper-top.fixed .register-link.text-button:hover,
					.header-wrapper-top .register-link.text-button:hover
				'
			),
			'title'       => __( 'Background hover colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		),
		array(
			'id'      => 'register_border_header',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array(
				'.home.without-header:not(.logged-in) .header-wrapper-top.fixed .register-link.text-button',
				'.header-wrapper-top .register-link.text-button'
			),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#20c497',
				'border-style'  => 'solid',
				'border-width'  => '0px'
			),
		),
		array(
			'id'             => 'register_border_radius_header',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '6',
				'units' => 'px',
			)
		),
		array(
			'id'             => 'register_padding_header',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Padding', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '12',
				'padding-right'  => '25',
				'padding-bottom' => '12',
				'padding-left'   => '25',
				'units'          => 'px',
			),
			'compiler'  => array(
				'.home.without-header:not(.logged-in) .header-wrapper-top.fixed .register-link.text-button',
				'.header-wrapper-top .register-link.text-button'
			),
		),
		array(
			'id'             => 'register_margin_header',
			'type'           => 'spacing',
			'mode'           => 'margin',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Margin', 'wpjobster' ),
			'default'        => array(
				'margin-top'    => '0',
				'margin-right'  => '0',
				'margin-bottom' => '0',
				'margin-left'   => '0',
				'units'         => 'px',
			),
			'compiler'  => array(
				'.home.without-header:not(.logged-in) .header-wrapper-top.fixed .register-link.text-button',
				'.header-wrapper-top .register-link.text-button'
			),
		),

/* REGISTER - FRONT PAGE */

		array(
			'id'       => 'header-auth-buttons-register-front-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Register - Front page', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'register_front_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.home.without-header:not(.logged-in) .header-wrapper-top .register-link.text-button'
			),
			'title'       => __( 'Colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'register_front_hover_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.home.without-header:not(.logged-in) .header-wrapper-top .register-link.text-button:hover'
			),
			'title'       => __( 'Hover colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'register_front_bg_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.home.without-header:not(.logged-in) .header-wrapper-top .register-link.text-button'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		),
		array(
			'id'          => 'register_front_bg_hover_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.home.without-header:not(.logged-in) .header-wrapper-top .register-link.text-button:hover'
			),
			'title'       => __( 'Background hover colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		),
		array(
			'id'      => 'register_front_border_header',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.home.without-header:not(.logged-in) .header-wrapper-top .register-link.text-button' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#20c497',
				'border-style'  => 'solid',
				'border-width'  => '0px'
			),
		),
		array(
			'id'             => 'register_front_border_radius_header',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '6',
				'units' => 'px',
			)
		),
		array(
			'id'             => 'register_front_padding_header',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Padding', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '12',
				'padding-right'  => '25',
				'padding-bottom' => '12',
				'padding-left'   => '25',
				'units'          => 'px',
			),
			'compiler'  => array( '.home.without-header:not(.logged-in) .header-wrapper-top .register-link.text-button' ),
		),
		array(
			'id'             => 'register_front_margin_header',
			'type'           => 'spacing',
			'mode'           => 'margin',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Margin', 'wpjobster' ),
			'default'        => array(
				'margin-top'    => '0',
				'margin-right'  => '0',
				'margin-bottom' => '0',
				'margin-left'   => '0',
				'units'         => 'px',
			),
			'compiler'  => array( '.home.without-header:not(.logged-in) .header-wrapper-top .register-link.text-button.text-button-simple' ),
		)
	)
) );