<?php /* Balance */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Balance', 'wpjobster' ),
	'id'         => 'header-balance-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'          => 'balance_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.user-info-menu .header-user-credit
				'
			),
			'title'       => __( 'Colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'balance_hover_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.user-info-menu .header-user-credit:hover
				'
			),
			'title'       => __( 'Hover colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'balance_bg_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.user-info-menu .header-user-credit
				'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		),
		array(
			'id'          => 'balance_bg_hover_colour_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.user-info-menu .header-user-credit:hover
				'
			),
			'title'       => __( 'Background hover colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		),
		array(
			'id'      => 'balance_border_header',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.user-info-menu .header-user-credit' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#fff',
				'border-style'  => 'solid',
				'border-width'  => '2px'
			),
		),
		array(
			'id'             => 'balance_border_radius_header',
			'type'           => 'spacing',
			'mode'           => 'absolute',
			'all'            => true,
			'units'          => array( '%', 'px' ),
			'display_units'  => true,
			'title'          => __( 'Border radius', 'wpjobster' ),
			'default'        => array(
				'top'   => '10',
				'units' => 'px',
			)
		),
		array(
			'id'             => 'balance_font_header',
			'type'           => 'typography',
			'title'          => esc_html__( 'Font', 'wpjobster' ),
			'google'         => true,
			'line-height'    => true,
			'color'          => false,
			'word-spacing'   => true,
			'letter-spacing' => true,
			'font-style'     => false,
			'font-weight'    => true,
			'font-size'      => true,
			'subsets'        => false,
			'text-align'     => true,
			'text-transform' => true,
			'text-shadow'    => false,
			'default'        => array(
				'font-family'    => 'Poppins',
				'font-size'      => '11px',
				'font-weight'    => 600,
				'line-height'    => '11px',
				'text-align'     => 'center',
				'text-transform' => 'none',
				'letter-spacing' => '.5'
			),
			'compiler' => array( '.user-info-menu .header-user-credit' ),
		),
		array(
			'id'             => 'balance_padding_header',
			'type'           => 'spacing',
			'mode'           => 'padding',
			'all'            => false,
			'units'          => array( '%', 'in', 'cm', 'mm', 'em', 'rem', 'ex', 'pt', 'pc', 'px', 'vh', 'vw', 'vmin', 'vmax', 'ch' ),
			'display_units'  => true,
			'title'          => __( 'Padding', 'wpjobster' ),
			'default'        => array(
				'padding-top'    => '3',
				'padding-right'  => '5',
				'padding-bottom' => '3',
				'padding-left'   => '5',
				'units'          => 'px',
			),
			'compiler'         => array( '.user-info-menu .header-user-credit' ),
		),
	)
) );