<?php /* Currency */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Currency', 'wpjobster' ),
	'id'         => 'header-currency-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'header_currency_icon_name',
			'type'     => 'text',
			'title'    => __( 'Selector icon', 'wpjobster' ),
			'default'  => 'money bill alternate outline',
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' )
		),
		array(
			'id'          => 'header_currency_icon_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.header-wrapper .currency .trigger-icon
				'
			),
			'title'       => __( 'Icon colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_currency_icon_colour_hover',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.header-wrapper .currency:hover .trigger-icon
				'
			),
			'title'       => __( 'Hover icon colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_currency_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.header-wrapper .currency .trigger-text
				'
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => 'rgba(0, 0, 0, 0.6)',
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_currency_text_colour_hover',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '
					.header-wrapper .currency:hover .trigger-text
				'
			),
			'title'       => __( 'Text hover colour', 'wpjobster' ),
			'default'     => 'rgba(0, 0, 0, 0.8)',
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_currency_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.header-wrapper .dropdown-menu.currency
				'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => '#FFFFFF',
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_currency_bg_colour_hover',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.header-wrapper .dropdown-menu.currency:hover
				'
			),
			'title'       => __( 'Background hover colour', 'wpjobster' ),
			'default'     => '#FFFFFF',
			'color_alpha' => true,
		),
	)
) );