<?php /* Header */

Redux::setSection( $opt_name, array(
	'title'  => __( 'Header', 'wpjobster' ),
	'id'     => 'header-settings',
	'icon'   => 'el el-chevron-up',
	'fields' => array(
		array(
			'id'       => 'header_style',
			'type'     => 'select',
			'title'    => esc_html__( 'Header style', 'wpjobster' ),
			'options'  => array(
				'regular'      => esc_attr__( 'Regular', 'wpjobster' ),
				'fixed'        => esc_attr__( 'Fixed', 'wpjobster' ),
				'fixed_top'    => esc_attr__( 'Fixed only top part', 'wpjobster' ),
				'fixed_bottom' => esc_attr__( 'Fixed only bottom part', 'wpjobster' ),
			),
			'default'  => 'fixed_top',
		),
		array(
			'id'       => 'header_in_grid',
			'type'     => 'switch',
			'title'    => __( 'Header in grid', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'header_on_homepage',
			'type'     => 'switch',
			'title'    => __( 'Header on Front page', 'wpjobster' ),
			'subtitle' => __( 'Display on the front home page (users who are not logged in) the same header as the other pages', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false
		),
		array(
			'id'       => 'header-middle-border-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Middle border', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'header_middle_border',
			'type'     => 'switch',
			'title'    => __( 'Show header middle border', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'      => 'header_middle_border_colour',
			'type'    => 'border',
			'all'     => true,
			'left'    => false,
			'bottom'  => false,
			'right'   => false,
			'compiler'  => array(
				'border-top' => '.header-wrapper-menu.header-menu-border',
			),
			'title'   => esc_html__( 'Header middle border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#e8ebf6',
				'border-style'  => 'solid',
				'border-width'  => '1px'
			),
			'required'    => array( 'header_middle_border', '=', true )
		),
		array(
			'id'       => 'header_middle_border_front',
			'type'     => 'switch',
			'title'    => __( 'Show header middle border on Front page', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false
		),
		array(
			'id'      => 'header_middle_border_front_colour',
			'type'    => 'border',
			'all'     => true,
			'left'    => false,
			'bottom'  => false,
			'right'   => false,
			'compiler'  => array(
				'border-top' => '.home.without-header:not(.logged-in) .header-wrapper-menu.header-menu-border',
			),
			'title'   => esc_html__( 'Header middle border on Front page', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#ffffff',
				'border-style'  => 'solid',
				'border-width'  => '1px'
			),
			'required' => array( 'header_middle_border_front', '=', true )
		),
		array(
			'id'       => 'header-bottom-border-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Bottom border', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'header_bottom_border',
			'type'     => 'switch',
			'title'    => __( 'Show header bottom border', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'      => 'header_bottom_border_colour',
			'type'    => 'border',
			'all'     => true,
			'left'    => false,
			'top'     => false,
			'right'   => false,
			'compiler'  => array(
				'border-bottom' => '.header-wrapper-menu, .header-wrapper .fixed',
			),
			'title'   => esc_html__( 'Header bottom border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#f1f2f3',
				'border-style'  => 'solid',
				'border-width'  => '3px'
			),
			'required' => array( 'header_bottom_border', '=', true )
		),
		array(
			'id'       => 'header_bottom_border_front',
			'type'     => 'switch',
			'title'    => __( 'Show header bottom border on Front page', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false
		),
		array(
			'id'      => 'header_bottom_border_front_colour',
			'type'    => 'border',
			'all'     => true,
			'left'    => false,
			'top'     => false,
			'right'   => false,
			'compiler'  => array(
				'border-bottom' => '.home.without-header:not(.logged-in) .header-wrapper-menu, .home.without-header:not(.logged-in) .header-wrapper .fixed',
			),
			'title'   => esc_html__( 'Header bottom border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#ffffff',
				'border-style'  => 'solid',
				'border-width'  => '1px'
			),
			'required' => array( 'header_bottom_border_front', '=', true )
		),
		array(
			'id'       => 'header-background-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Header background', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'header_background_type',
			'type'     => 'select',
			'title'    => esc_html__( 'Background type', 'wpjobster' ),
			'options'  => array(
				'colour' => esc_attr__( 'Colour', 'wpjobster' ),
				'image'  => esc_attr__( 'Image', 'wpjobster' ),
			),
			'default'  => 'colour',
		),
		array(
			'id'           => 'header_background_image',
			'type'         => 'media',
			'url'          => true,
			'title'        => esc_html__( 'Image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
			'required'     => array( 'header_background_type', '=', 'image' )
		),
		array(
			'id'            => 'header_background_image_overlay',
			'type'          => 'box_shadow',
			'title'         => __( 'Overlay', 'wpjobster' ),
			'units'         => 'px',
			'display_units' => false,
			'preview'       => false,
			'opacity'       => true,
			'rgba'          => true,
			'required'      => array( 'header_background_type', '=', 'image' ),
			'default'       => array (
				'horizontal'   => '0px',
				'vertical'     => '0px',
				'blur'         => '0px',
				'spread'       => '2000px',
				'opacity'      => '0.1',
				'shadow-color' => '#000000',
				'shadow-type'  => 'inset',
			),
			'compiler'        => array( '
				.header-wrapper,
				.header-wrapper.fixed,
				.header-wrapper .fixed
			' ),
		),
		array(
			'id'          => 'header_top_background',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.header-wrapper-top, .header-wrapper .header-wrapper-top.fixed',
			),
			'title'       => esc_html__( 'Top background', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
			'required'     => array( 'header_background_type', '=', 'colour' )
		),
		array(
			'id'          => 'header_bottom_background',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.header-wrapper-menu, .header-mobile .header-wrapper-menu',
			),
			'title'       => esc_html__( 'Bottom background', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
			'required'     => array( 'header_background_type', '=', 'colour' )
		),
	)
) );