<?php /* Menu */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Menu', 'wpjobster' ),
	'id'         => 'header-menu-settings',
	'subsection' => true,
	'fields'     => array(

/* MAIN MENU */

		array(
			'id'       => 'main-menu-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Main menu', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'enable_long_menu_arrows',
			'type'     => 'switch',
			'title'    => __( 'Long menu arrows', 'wpjobster' ),
			'subtitle' => __( 'Displays a long menu, which instead of moving on to the next row, displays some arrows with which you can navigate left and right.<br>Warning: this type of menu does not support submenus', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => true,
		),
		array(
			'id'       => 'enable_categories_menu_not_loggedin',
			'type'     => 'switch',
			'title'    => __( 'Categories menu for not logged in users', 'wpjobster' ),
			'subtitle' => __( 'Display header categories menu for not logged in users', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false,
		),
		array(
			'id'       => 'enable_categories_menu_not_loggedin_front_page',
			'type'     => 'switch',
			'title'    => __( 'Categories menu for not logged in users - Front page', 'wpjobster' ),
			'subtitle' => __( 'Display header categories menu for not logged in users on front page', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false
		),
		array(
			'id'      => 'mainmenu_links_color',
			'type'    => 'link_color',
			'title'   => __( 'Menu links colour', 'wpjobster' ),
			'focus'   => true,
			'visited' => true,
			'default' => array(
				'regular' => '#333435',
				'hover'   => '#20c497',
				'active'  => '#20c497',
				'visited' => '#333435',
				'focus'   => '#20c497',
			),
			'color_alpha' => true,
			'compiler'    => array(
				'.main-menu-container .menu-list-with-children > li > a',
				'.main-menu-container.slider .arrows-wrapper a'
			),
		),
		array(
			'id'      => 'mainmenu_links_color_front_page',
			'type'    => 'link_color',
			'title'   => __( 'Menu links colour - Front page', 'wpjobster' ),
			'focus'   => true,
			'visited' => true,
			'default' => array(
				'regular' => '#ffffff',
				'hover'   => '#20c497',
				'active'  => '#20c497',
				'visited' => '#ffffff',
				'focus'   => '#20c497',
			),
			'color_alpha' => true,
			'compiler'    => array(
				'.home.without-header:not(.logged-in) .main-menu-container .menu-list-with-children > li > a',
				'.home.without-header:not(.logged-in) .main-menu-container.slider .arrows-wrapper a'
			)
		),
		array(
			'id'       => 'menu_style',
			'type'     => 'select',
			'title'    => esc_html__( 'Submenu style', 'wpjobster' ),
			'options'  => array(
				'1' => esc_attr__( '1 column', 'wpjobster' ),
				'2' => esc_attr__( '2 columns', 'wpjobster' ),
				'3' => esc_attr__( '3 columns', 'wpjobster' ),
				'4' => esc_attr__( '4 columns', 'wpjobster' ),
				'5' => esc_attr__( '5 columns', 'wpjobster' )
			),
			'default'  => '2',
		),
		array(
			'id'       => 'main_menu_submenu_items_alignment',
			'type'     => 'select',
			'title'    => esc_html__( 'Submenu alignment', 'wpjobster' ),
			'options'  => array(
				'left'      => esc_attr__( 'Left', 'wpjobster' ),
				'right'     => esc_attr__( 'Right', 'wpjobster' ),
				'leftright' => esc_attr__( 'By parent position', 'wpjobster' ),
			),
			'default'  => 'leftright',
		),
		array(
			'id'          => 'mainmenu_submenu_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.header-wrapper .categories-menu-list ul.sub-menu',
			),
			'title'       => esc_html__( 'Submenu background colour', 'wpjobster' ),
			'default'     => '#FFFFFF',
			'color_alpha' => true,
		),
		array(
			'id'      => 'mainmenu_submenu_border',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.header-wrapper .categories-menu-list ul.sub-menu' ),
			'title'   => esc_html__( 'Submenu border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#ffffff',
				'border-style'  => 'solid',
				'border-width'  => '0px'
			),
		),
		array(
			'id'            => 'mainmenu_submenu_box_shadow',
			'type'          => 'box_shadow',
			'title'         => __( 'Submenu box shadow', 'wpjobster' ),
			'units'         => 'px',
			'display_units' => false,
			'preview'       => false,
			'opacity'       => true,
			'rgba'          => true,
			'default'       => array (
				'horizontal'   => '0px',
				'vertical'     => '10px',
				'blur'         => '20px',
				'spread'       => '0px',
				'opacity'      => '0.15',
				'shadow-color' => '#37409d',
				'shadow-type'  => 'outside',
			),
			'compiler'      => array( '.header-wrapper .categories-menu-list ul.sub-menu' ),
		),
		array(
			'id'      => 'mainmenu_submenu_links_color',
			'type'    => 'link_color',
			'title'   => __( 'Submenu links colour', 'wpjobster' ),
			'focus'   => true,
			'visited' => true,
			'default' => array(
				'regular' => '#333435',
				'hover'   => '#20c497',
				'active'  => '#20c497',
				'visited' => '#333435',
				'focus'   => '#20c497',
			),
			'color_alpha' => true,
			'compiler'    => array( '.header-wrapper .main-menu-wrapper ul > li > ul > li > a' ),
		),

/* DROPDOWN */

		array(
			'id'       => 'dropdown-menu-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Dropdown menu', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'dropdown_menu_style',
			'type'     => 'select',
			'title'    => esc_html__( 'Menu style', 'wpjobster' ),
			'options'  => array(
				'1' => esc_attr__( '1 column', 'wpjobster' ),
				'2' => esc_attr__( '2 columns', 'wpjobster' )
			),
			'default'  => '2',
		),
		array(
			'id'          => 'dropdown_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color'    => '.user-info-menu .dropdown-menu-wrapper .nh-submenu',
				'border-bottom-color' => '.user-info-menu .dropdown-menu-wrapper .nh-submenu:after',
			),
			'title'       => esc_html__( 'Menu background colour', 'wpjobster' ),
			'default'     => '#FFFFFF',
			'color_alpha' => true,
		),
		array(
			'id'          => 'dropdown_border_colour',
			'type'        => 'color',
			'compiler'      => array(
				'border-color'        => '.user-info-menu .dropdown-menu-wrapper .nh-submenu',
				'border-bottom-color' => '.user-info-menu .dropdown-menu-wrapper .nh-submenu:before',
			),
			'title'       => esc_html__( 'Menu border colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'      => 'dropdown_links_color',
			'type'    => 'link_color',
			'title'   => __( 'Menu links colour', 'wpjobster' ),
			'focus'   => true,
			'visited' => true,
			'default' => array(
				'regular' => '#333435',
				'hover'   => '#20c497',
				'active'  => '#20c497',
				'visited' => '#333435',
				'focus'   => '#20c497',
			),
			'color_alpha' => true,
			'compiler'    => array( '.header-wrapper .dropdown-menu-wrapper ul > li > a' ),
		),
		array(
			'id'          => 'dropdown_submenu_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.user-info-menu .nh-submenu.nh-accordions .nh-accordion',
			),
			'title'       => esc_html__( 'Submenu background colour', 'wpjobster' ),
			'default'     => '#FFFFFF',
			'color_alpha' => true,
		),
		array(
			'id'      => 'dropdown_submenu_border',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.user-info-menu .nh-submenu.nh-accordions .nh-accordion' ),
			'title'   => esc_html__( 'Submenu border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#ffffff',
				'border-style'  => 'solid',
				'border-width'  => '0px'
			),
		),
		array(
			'id'            => 'dropdown_submenu_box_shadow',
			'type'          => 'box_shadow',
			'title'         => __( 'Submenu box shadow', 'wpjobster' ),
			'units'         => 'px',
			'display_units' => false,
			'preview'       => false,
			'opacity'       => true,
			'rgba'          => true,
			'default'       => array (
				'horizontal'   => '0px',
				'vertical'     => '0px',
				'blur'         => '0px',
				'spread'       => '0px',
				'opacity'      => '0',
				'shadow-color' => '#ffffff',
				'shadow-type'  => 'outside',
			),
			'compiler'        => array( '.user-info-menu .nh-submenu.nh-accordions .nh-accordion' ),
		),
		array(
			'id'      => 'dropdown_submenu_links_color',
			'type'    => 'link_color',
			'title'   => __( 'Submenu links colour', 'wpjobster' ),
			'focus'   => true,
			'visited' => true,
			'default' => array(
				'regular' => '#333435',
				'hover'   => '#20c497',
				'active'  => '#20c497',
				'visited' => '#333435',
				'focus'   => '#20c497',
			),
			'color_alpha' => true,
			'compiler'    => array( '.header-wrapper .dropdown-menu-wrapper .nh-accordion > ul > li > a' ),
		),

/* SECONDARY */

		array(
			'id'       => 'secondary-menu-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Secondary menu', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'      => 'secondarymenu_links_color',
			'type'    => 'link_color',
			'title'   => __( 'Menu links colour', 'wpjobster' ),
			'focus'   => true,
			'visited' => true,
			'default' => array(
				'regular' => '#39496a',
				'hover'   => '#20c497',
				'active'  => '#20c497',
				'visited' => '#39496a',
				'focus'   => '#20c497',
			),
			'color_alpha' => true,
			'compiler'    => array(
				'.header-wrapper .header-secondary-menu-wrapper ul > li > a',
				'.home.without-header:not(.logged-in) .header-wrapper .header-wrapper-top.fixed .header-secondary-menu-wrapper ul > li > a'
			),
		),
		array(
			'id'      => 'secondarymenu_front_links_color',
			'type'    => 'link_color',
			'title'   => __( 'Menu links colour - Front page', 'wpjobster' ),
			'focus'   => true,
			'visited' => true,
			'default' => array(
				'regular' => '#FFFFFF',
				'hover'   => '#20c497',
				'active'  => '#20c497',
				'visited' => '#FFFFFF',
				'focus'   => '#20c497',
			),
			'color_alpha' => true,
			'compiler'    => array( '.home.without-header:not(.logged-in) .header-wrapper .header-secondary-menu-wrapper > ul > li > a' ),
		),
		array(
			'id'       => 'secondarymenu_style',
			'type'     => 'select',
			'title'    => esc_html__( 'Submenu style', 'wpjobster' ),
			'options'  => array(
				'1' => esc_attr__( '1 column', 'wpjobster' ),
				'2' => esc_attr__( '2 columns', 'wpjobster' ),
				'3' => esc_attr__( '3 columns', 'wpjobster' ),
				'4' => esc_attr__( '4 columns', 'wpjobster' ),
				'5' => esc_attr__( '5 columns', 'wpjobster' )
			),
			'default'  => '2',
		),
		array(
			'id'          => 'secondarymenu_submenu_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.header-wrapper .header-secondary-menu-wrapper ul.sub-menu',
			),
			'title'       => esc_html__( 'Submenu background colour', 'wpjobster' ),
			'default'     => '#FFFFFF',
			'color_alpha' => true,
		),
		array(
			'id'      => 'secondarymenu_submenu_border',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.header-wrapper .header-secondary-menu-wrapper ul.sub-menu' ),
			'title'   => esc_html__( 'Submenu border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#ffffff',
				'border-style'  => 'solid',
				'border-width'  => '0px'
			),
		),
		array(
			'id'            => 'secondarymenu_submenu_box_shadow',
			'type'          => 'box_shadow',
			'title'         => __( 'Submenu box shadow', 'wpjobster' ),
			'units'         => 'px',
			'display_units' => false,
			'preview'       => false,
			'opacity'       => true,
			'rgba'          => true,
			'default'       => array (
				'horizontal'   => '0px',
				'vertical'     => '10px',
				'blur'         => '20px',
				'spread'       => '0px',
				'opacity'      => '0.15',
				'shadow-color' => '#37409d',
				'shadow-type'  => 'outside',
			),
			'compiler'        => array( '.header-wrapper .header-secondary-menu-wrapper ul.sub-menu' ),
		),
		array(
			'id'      => 'secondarymenu_submenu_links_color',
			'type'    => 'link_color',
			'title'   => __( 'Submenu links colour', 'wpjobster' ),
			'focus'   => true,
			'visited' => true,
			'default' => array(
				'regular' => '#333435',
				'hover'   => '#20c497',
				'active'  => '#20c497',
				'visited' => '#333435',
				'focus'   => '#20c497',
			),
			'color_alpha' => true,
			'compiler'    => array( '.header-wrapper .header-secondary-menu-wrapper ul > li > ul > li > a' ),
		),

/* MOBILE MENU */

		array(
			'id'       => 'mobile-menu-left-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Mobile menu - Left sidebar', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'enable_language_left_menu_not_loggedin',
			'type'     => 'switch',
			'title'    => __( 'Language selector', 'wpjobster' ),
			'subtitle' => __( 'Display language selector item for not logged-in users', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => true
		),
		array(
			'id'       => 'enable_language_left_menu_loggedin',
			'type'     => 'switch',
			'title'    => __( 'Language selector - logged-in', 'wpjobster' ),
			'subtitle' => __( 'Display language selector item for logged-in users', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => true
		),
		array(
			'id'       => 'enable_currency_left_menu_not_loggedin',
			'type'     => 'switch',
			'title'    => __( 'Currency selector', 'wpjobster' ),
			'subtitle' => __( 'Display currency selector item for not logged-in users', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => wpj_is_allowed( 'multi_currency' ) ? true : false,
			'disabled' => ! wpj_is_allowed( 'multi_currency' ) ? true : false
		),
		array(
			'id'       => 'enable_currency_left_menu_loggedin',
			'type'     => 'switch',
			'title'    => __( 'Currency selector - logged-in', 'wpjobster' ),
			'subtitle' => __( 'Display currency selector item for logged-in users', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => wpj_is_allowed( 'multi_currency' ) ? true : false,
			'disabled' => ! wpj_is_allowed( 'multi_currency' ) ? true : false
		),
		array(
			'id'       => 'enable_logout_left_menu_loggedin',
			'type'     => 'switch',
			'title'    => __( 'Logout item', 'wpjobster' ),
			'subtitle' => __( 'Display logout item for logged-in users', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => true
		),
		array(
			'id'           => 'left_mobile_menu_image_options_header',
			'type'         => 'media',
			'url'          => true,
			'title'        => __( 'Menu image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),
		array(
			'id'       => 'left_mobile_menu_icon_options_header',
			'type'     => 'text',
			'title'    => __( 'Menu icon name', 'wpjobster' ),
			'default'  => 'thick bars',
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' )
		),
		array(
			'id'          => 'left_mobile_menu_colour_icon_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'color'       => '.header-wrapper.header-mobile .menu-left .icon'
			),
			'title'       => esc_html__( 'Menu icon colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		),
		array(
			'id'          => 'left_mobile_menu_front_colour_icon_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'color'       => '.home.without-header:not(.logged-in) .header-mobile .header-wrapper-top:not(.fixed) .menu-left .icon'
			),
			'title'       => esc_html__( 'Menu icon colour - Front page', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'left_mobile_menu_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.ui.sidebar.inverted.vertical.left.menu',
			),
			'title'       => esc_html__( 'Background colour', 'wpjobster' ),
			'default'     => '#1B1C1D',
			'color_alpha' => true,
		),
		array(
			'id'      => 'left_mobile_menu_links_color',
			'type'    => 'link_color',
			'title'   => __( 'Links colour', 'wpjobster' ),
			'focus'   => true,
			'visited' => true,
			'default' => array(
				'regular' => 'rgba(255, 255, 255, 0.9)',
				'hover'   => 'rgba(255, 255, 255, 0.9)',
				'active'  => 'rgba(255, 255, 255, 0.9)',
				'visited' => 'rgba(255, 255, 255, 0.9)',
				'focus'   => 'rgba(255, 255, 255, 0.9)',
			),
			'color_alpha' => true,
			'compiler'    => array(
				'.ui.sidebar.inverted.vertical.left.menu .item',
				'.ui.sidebar.inverted.vertical.left.menu .nh-accordion-handler:after'
			),
		),
		array(
			'id'          => 'left_mobile_submenu_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.ui.sidebar.inverted.vertical.left.menu .nh-accordion',
			),
			'title'       => esc_html__( 'Submenu background colour', 'wpjobster' ),
			'default'     => 'rgba(255,255,255,.03)',
			'color_alpha' => true,
		),
		array(
			'id'      => 'left_mobile_submenu_links_color',
			'type'    => 'link_color',
			'title'   => __( 'Submenu links colour', 'wpjobster' ),
			'focus'   => true,
			'visited' => true,
			'default' => array(
				'regular' => 'rgba(255, 255, 255, 0.9)',
				'hover'   => 'rgba(255, 255, 255, 0.9)',
				'active'  => 'rgba(255, 255, 255, 0.9)',
				'visited' => 'rgba(255, 255, 255, 0.9)',
				'focus'   => 'rgba(255, 255, 255, 0.9)',
			),
			'color_alpha' => true,
			'compiler'    => array( '.ui.sidebar.inverted.vertical.left.menu .nh-accordion .item' ),
		),
		array(
			'id'       => 'mobile-menu-right-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Mobile menu - Right sidebar', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'enable_language_right_menu_not_loggedin',
			'type'     => 'switch',
			'title'    => __( 'Language selector', 'wpjobster' ),
			'subtitle' => __( 'Display language selector item for not logged-in users', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false
		),
		array(
			'id'       => 'enable_language_right_menu_loggedin',
			'type'     => 'switch',
			'title'    => __( 'Language selector - logged-in', 'wpjobster' ),
			'subtitle' => __( 'Display language selector item for logged-in users', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false
		),
		array(
			'id'       => 'enable_currency_right_menu_not_loggedin',
			'type'     => 'switch',
			'title'    => __( 'Currency selector', 'wpjobster' ),
			'subtitle' => __( 'Display currency selector item for not logged-in users', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false,
			'disabled' => ! wpj_is_allowed( 'multi_currency' ) ? true : false
		),
		array(
			'id'       => 'enable_currency_right_menu_loggedin',
			'type'     => 'switch',
			'title'    => __( 'Currency selector - logged-in', 'wpjobster' ),
			'subtitle' => __( 'Display currency selector item for logged-in users', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false,
			'disabled' => ! wpj_is_allowed( 'multi_currency' ) ? true : false
		),
		array(
			'id'       => 'enable_logout_right_menu_loggedin',
			'type'     => 'switch',
			'title'    => __( 'Logout item', 'wpjobster' ),
			'subtitle' => __( 'Display logout item for logged-in users', 'wpjobster' ),
			'on'       => __( 'Enabled', 'wpjobster' ),
			'off'      => __( 'Disabled', 'wpjobster' ),
			'default'  => false
		),
		array(
			'id'           => 'right_mobile_menu_image_options_header',
			'type'         => 'media',
			'url'          => true,
			'title'        => __( 'Menu image', 'wpjobster' ),
			'compiler'     => 'true',
			'preview_size' => 'full',
		),
		array(
			'id'       => 'right_mobile_menu_icon_options_header',
			'type'     => 'text',
			'title'    => __( 'Menu icon name', 'wpjobster' ),
			'default'  => 'th',
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' )
		),
		array(
			'id'          => 'right_mobile_menu_colour_icon_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.header-wrapper.header-mobile .menu-right .icon'
			),
			'title'       => esc_html__( 'Menu icon colour', 'wpjobster' ),
			'default'     => '#20c497',
			'color_alpha' => true,
		),
		array(
			'id'          => 'right_mobile_menu_front_colour_icon_options_header',
			'type'        => 'color',
			'compiler'      => array(
				'color'       => '.home.without-header:not(.logged-in) .header-mobile .header-wrapper-top:not(.fixed) .menu-right .icon'
			),
			'title'       => esc_html__( 'Menu icon colour - Front page', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'right_mobile_menu_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.ui.sidebar.vertical.right.inverted.menu',
			),
			'title'       => esc_html__( 'Background colour', 'wpjobster' ),
			'default'     => '#1B1C1D',
			'color_alpha' => true,
		),
		array(
			'id'      => 'right_mobile_menu_links_color',
			'type'    => 'link_color',
			'title'   => __( 'Links colour', 'wpjobster' ),
			'focus'   => true,
			'visited' => true,
			'default' => array(
				'regular' => 'rgba(255, 255, 255, 0.9)',
				'hover'   => 'rgba(255, 255, 255, 0.9)',
				'active'  => 'rgba(255, 255, 255, 0.9)',
				'visited' => 'rgba(255, 255, 255, 0.9)',
				'focus'   => 'rgba(255, 255, 255, 0.9)',
			),
			'color_alpha' => true,
			'compiler'      => array(
				'.ui.sidebar.vertical.right.inverted.menu .item',
				'.ui.sidebar.vertical.right.inverted.menu .nh-accordion-handler:after'
			),
		),
		array(
			'id'          => 'right_mobile_submenu_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.ui.sidebar.inverted.vertical.right.menu .nh-accordion',
			),
			'title'       => esc_html__( 'Submenu background colour', 'wpjobster' ),
			'default'     => 'rgba(255,255,255,.03)',
			'color_alpha' => true,
		),
		array(
			'id'      => 'right_mobile_submenu_links_color',
			'type'    => 'link_color',
			'title'   => __( 'Submenu links colour', 'wpjobster' ),
			'focus'   => true,
			'visited' => true,
			'default' => array(
				'regular' => 'rgba(255, 255, 255, 0.9)',
				'hover'   => 'rgba(255, 255, 255, 0.9)',
				'active'  => 'rgba(255, 255, 255, 0.9)',
				'visited' => 'rgba(255, 255, 255, 0.9)',
				'focus'   => 'rgba(255, 255, 255, 0.9)',
			),
			'color_alpha' => true,
			'compiler'    => array( '.ui.sidebar.inverted.vertical.right.menu .nh-accordion .item' ),
		),
		array(
			'id'          => 'right_mobile_search_text_color',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '#responsive-search, #responsive-search::-webkit-input-placeholder '
			),
			'title'       => esc_html__( 'Search text colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'right_mobile_search_icon_color',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.mobile-service-search .search-icon-wrapper .icon'
			),
			'title'       => esc_html__( 'Search icon colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'right_mobile_search_border_bottom_color',
			'type'        => 'color',
			'compiler'      => array(
				'border-bottom-color' => '.mobile-service-search'
			),
			'title'       => esc_html__( 'Search border bottom colour', 'wpjobster' ),
			'default'     => '#2d2e2f',
			'color_alpha' => true,
		),
	)
) );