<?php /* Message & Notifications */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Notify', 'wpjobster' ),
	'id'         => 'header-notify-settings',
	'subsection' => true,
	'fields'     => array(

/* Messages */
		array(
			'id'       => 'header-messages-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Messages', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'header_message_icon_name',
			'type'     => 'text',
			'title'    => __( 'Message icon name', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' )
		),
		array(
			'id'          => 'header_message_icon_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.user-notification-icon.messages-icon .icon',
			),
			'title'       => esc_html__( 'Message icon colour', 'wpjobster' ),
			'default'     => '#D9DAE8',
			'color_alpha' => true,
			'required'    => array( 'header_message_icon_name', '!=', '' )
		),
		array(
			'id'          => 'header_message_count_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background' => '.user-notification-icon.messages-icon .unread-label',
			),
			'title'       => esc_html__( 'Message count background colour', 'wpjobster' ),
			'default'     => '#ff6c61',
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_message_count_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.user-notification-icon.messages-icon .unread-label .messages_count',
			),
			'title'       => esc_html__( 'Message count text colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),

/* Notifications */
		array(
			'id'       => 'header-notifications-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Notifications', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'header_notification_icon_name',
			'type'     => 'text',
			'title'    => __( 'Notification icon name', 'wpjobster' ),
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' )
		),
		array(
			'id'          => 'header_notification_icon_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.user-notification-icon.notifications-icon .icon',
			),
			'title'       => esc_html__( 'Notification icon colour', 'wpjobster' ),
			'default'     => '#D9DAE8',
			'color_alpha' => true,
			'required'    => array( 'header_notification_icon_name', '!=', '' )
		),
		array(
			'id'          => 'header_notification_count_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background' => '.user-notification-icon.notifications-icon .unread-label',
			),
			'title'       => esc_html__( 'Notification count background colour', 'wpjobster' ),
			'default'     => '#ff6c61',
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_notification_count_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.user-notification-icon.notifications-icon .unread-label .messages_count',
			),
			'title'       => esc_html__( 'Notification count text colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),

/* Preview panel - Messages */
		array(
			'id'       => 'header-preview-panel-messages-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Preview panel - Messages', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'message_preview_panel_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color'    => '.nh-submenu.messages-icon-dropdown',
				'border-bottom-color' => '.nh-submenu.messages-icon-dropdown:after'
			),
			'title'       => esc_html__( 'Messages panel background colour', 'wpjobster' ),
			'default'     => '#FFFFFF',
			'color_alpha' => true,
		),
		array(
			'id'          => 'message_preview_panel_separator_colour',
			'type'        => 'color',
			'compiler'      => array(
				'border-bottom-color' => '.user-notification-icons .nh-submenu.messages-icon-dropdown .mCSB_container ul li'
			),
			'title'       => esc_html__( 'Message separator colour', 'wpjobster' ),
			'default'     => '#e8ebf6',
			'color_alpha' => true,
		),
		array(
			'id'          => 'message_preview_panel_read_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.user-notification-icons .nh-submenu.messages-icon-dropdown .mCSB_container ul li.read > a',
			),
			'title'       => esc_html__( 'Message read background colour', 'wpjobster' ),
			'default'     => '#FFFFFF',
			'color_alpha' => true,
		),
		array(
			'id'          => 'message_preview_panel_read_username_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.user-notification-icons .nh-submenu.messages-icon-dropdown li.read .nh-notification-username',
			),
			'title'       => esc_html__( 'Message read username text colour', 'wpjobster' ),
			'default'     => '#426195',
			'color_alpha' => true,
		),
		array(
			'id'          => 'message_preview_panel_read_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.user-notification-icons .nh-submenu.messages-icon-dropdown li.read .nh-notification-content',
			),
			'title'       => esc_html__( 'Message read text colour', 'wpjobster' ),
			'default'     => '#333435',
			'color_alpha' => true,
		),
		array(
			'id'          => 'message_preview_panel_read_date_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.user-notification-icons .nh-submenu.messages-icon-dropdown li.read .nh-notification-date',
			),
			'title'       => esc_html__( 'Message read date text colour', 'wpjobster' ),
			'default'     => '#898eb4',
			'color_alpha' => true,
		),
		array(
			'id'          => 'message_preview_panel_unread_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.user-notification-icons .nh-submenu.messages-icon-dropdown .mCSB_container ul li.unread > a,
					.user-notification-icons .nh-submenu.messages-icon-dropdown .mCSB_container ul li:hover > a
				',
			),
			'title'       => esc_html__( 'Message unread background colour', 'wpjobster' ),
			'default'     => '#f7f7f7',
			'color_alpha' => true,
		),
		array(
			'id'          => 'message_preview_panel_unread_username_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.user-notification-icons .nh-submenu.messages-icon-dropdown li.unread .nh-notification-username',
			),
			'title'       => esc_html__( 'Message unread username text colour', 'wpjobster' ),
			'default'     => '#426195',
			'color_alpha' => true,
		),
		array(
			'id'          => 'message_preview_panel_unread_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.user-notification-icons .nh-submenu.messages-icon-dropdown li.unread .nh-notification-content',
			),
			'title'       => esc_html__( 'Message unread text colour', 'wpjobster' ),
			'default'     => '#333435',
			'color_alpha' => true,
		),
		array(
			'id'          => 'message_preview_panel_unread_date_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.user-notification-icons .nh-submenu.messages-icon-dropdown li.unread .nh-notification-date',
			),
			'title'       => esc_html__( 'Message unread date text colour', 'wpjobster' ),
			'default'     => '#898eb4',
			'color_alpha' => true,
		),

/* Preview panel - Notifications */
		array(
			'id'       => 'header-preview-panel-notifications-section-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Preview panel - Notifications', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'          => 'notification_preview_panel_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color'    => '.user-notification-icons .nh-submenu.notifications-icon-dropdown',
				'border-bottom-color' => '.user-notification-icons .nh-submenu.notifications-icon-dropdown:after'
			),
			'title'       => esc_html__( 'Notifications panel background colour', 'wpjobster' ),
			'default'     => '#FFFFFF',
			'color_alpha' => true,
		),
		array(
			'id'          => 'notification_preview_panel_separator_colour',
			'type'        => 'color',
			'compiler'      => array(
				'border-bottom-color' => '.user-notification-icons .nh-submenu.notifications-icon-dropdown .mCSB_container ul li'
			),
			'title'       => esc_html__( 'Notification separator colour', 'wpjobster' ),
			'default'     => '#e8ebf6',
			'color_alpha' => true,
		),
		array(
			'id'          => 'notification_preview_panel_read_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.user-notification-icons .nh-submenu.notifications-icon-dropdown .mCSB_container ul li.read > a',
			),
			'title'       => esc_html__( 'Notification read background colour', 'wpjobster' ),
			'default'     => '#FFFFFF',
			'color_alpha' => true,
		),
		array(
			'id'          => 'notification_preview_panel_read_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.user-notification-icons .nh-submenu.notifications-icon-dropdown li.read .nh-notification-content',
			),
			'title'       => esc_html__( 'Notification read text colour', 'wpjobster' ),
			'default'     => '#333435',
			'color_alpha' => true,
		),
		array(
			'id'          => 'notification_preview_panel_read_date_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.user-notification-icons .nh-submenu.notifications-icon-dropdown li.read .nh-notification-date',
			),
			'title'       => esc_html__( 'Notification read date text colour', 'wpjobster' ),
			'default'     => '#898eb4',
			'color_alpha' => true,
		),
		array(
			'id'          => 'notification_preview_panel_unread_bg_colour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '
					.user-notification-icons .nh-submenu.notifications-icon-dropdown .mCSB_container ul li.unread > a,
					.user-notification-icons .nh-submenu.notifications-icon-dropdown .mCSB_container ul li:hover > a
				',
			),
			'title'       => esc_html__( 'Notification unread background colour', 'wpjobster' ),
			'default'     => '#f7f7f7',
			'color_alpha' => true,
		),
		array(
			'id'          => 'notification_preview_panel_unread_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.user-notification-icons .nh-submenu.notifications-icon-dropdown li.unread .nh-notification-content',
			),
			'title'       => esc_html__( 'Notification unread text colour', 'wpjobster' ),
			'default'     => '#333435',
			'color_alpha' => true,
		),
		array(
			'id'          => 'notification_preview_panel_unread_date_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.user-notification-icons .nh-submenu.notifications-icon-dropdown li.unread .nh-notification-date',
			),
			'title'       => esc_html__( 'Notification unread date text colour', 'wpjobster' ),
			'default'     => '#898eb4',
			'color_alpha' => true,
		)
	)
) );