<?php /* Search */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Search', 'wpjobster' ),
	'id'         => 'header-search-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'       => 'header_search_icon_name',
			'type'     => 'text',
			'title'    => __( 'Icon name', 'wpjobster' ),
			'default'  => 'search',
			'subtitle' => sprintf( __( 'Example: info, list alternate outline, address card outline, file outline, image outline, video, plus square outline, truck.<br />All icons: %s', 'wpjobster' ), '<a href="https://semantic-ui.com/elements/icon.html" target="_blank">https://semantic-ui.com/elements/icon.html</a>' )
		),
		array(
			'id'          => 'header_search_icon_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.header-service-search .hd-basic-search .ui.icon.input > i.icon'
			),
			'title'       => __( 'Icon colour', 'wpjobster' ),
			'default'     => '#898eb4',
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_search_placeholder_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.header-service-search .hd-basic-search .ui.input input::placeholder'
			),
			'title'       => __( 'Palceholder colour', 'wpjobster' ),
			'default'     => '#C7C7C7',
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_search_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.header-service-search .hd-basic-search .ui.input > input'
			),
			'title'       => __( 'Text colour', 'wpjobster' ),
			'default'     => 'rgba(0, 0, 0, 0.87)',
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_search_bgcolour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.header-service-search .hd-basic-search .ui.input > input'
			),
			'title'       => __( 'Background colour', 'wpjobster' ),
			'default'     => 'transparent',
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_search_button_text_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.header-service-search .hd-basic-search .ui.input button'
			),
			'title'       => __( 'Button text colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_search_button_text_hover_colour',
			'type'        => 'color',
			'compiler'      => array(
				'color' => '.header-service-search .hd-basic-search .ui.input button:hover'
			),
			'title'       => __( 'Button text hover colour', 'wpjobster' ),
			'default'     => '#ffffff',
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_search_button_bgcolour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.header-service-search .hd-basic-search .ui.input button',
				'border-color'     => '.header-service-search .hd-basic-search .ui.input button'
			),
			'title'       => __( 'Button background colour', 'wpjobster' ),
			'default'     => '#3a5583',
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_search_button_hover_bgcolour',
			'type'        => 'color',
			'compiler'      => array(
				'background-color' => '.header-service-search .hd-basic-search .ui.input button:hover',
				'border-color'     => '.header-service-search .hd-basic-search .ui.input button:hover'
			),
			'title'       => __( 'Button hover background colour', 'wpjobster' ),
			'default'     => '#3a5583',
			'color_alpha' => true,
		),
		array(
			'id'      => 'header_search_border',
			'type'    => 'border',
			'all'     => true,
			'compiler'  => array( '.header-service-search .hd-basic-search .ui.input > input' ),
			'title'   => esc_html__( 'Border', 'wpjobster' ),
			'default' => array(
				'border-color'  => '#e8ebf6',
				'border-style'  => 'solid',
				'border-width'  => '1px'
			),
		)
	)
) );