<?php /* Elements */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Footer', 'wpjobster' ),
	'id'         => 'footer-font-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'      => 'footer_links_color',
			'type'    => 'link_color',
			'title'   => __( 'Footer links colour', 'wpjobster' ),
			'focus'   => true,
			'visited' => true,
			'default' => array(
				'regular' => '#454a60',
				'hover'   => '#20c497',
				'active'  => '#20c497',
				'visited' => '#454a60',
				'focus'   => '#20c497',
			),
			'color_alpha' => true,
			'compiler'      => array(
				'.footer-wrapper a',
				'.footer-wrapper .footer-copyright a',
				'.footer-wrapper .footer-widgets-content a'
			),
		),
		array(
			'id'             => 'footer-font-settings',
			'type'           => 'typography',
			'title'          => esc_html__( 'Footer font', 'wpjobster' ),
			'google'         => true,
			'all-styles'     => true,
			'all-subsets'    => true,
			'units'          => 'px',
			'word-spacing'   => true,
			'letter-spacing' => true,
			'text-align'     => true,
			'text-transform' => true,
			'default'        => array(
				'color'       => '#999999',
				'font-size'   => '14px',
				'line-height' => '20px',
				'font-family' => 'Poppins',
				'font-weight' => '400',
			),
			'color_alpha' => true,
			'compiler'      => array( '
				.footer-wrapper div,
				.footer-wrapper p,
				.footer-wrapper span,
				.footer-wrapper .footer-copyright p,
				.footer-wrapper .footer-copyright a,
				.footer-wrapper .footer-col-social-media .social-media-widgets-area .widget-title
			' ),
		),
		array(
			'id'             => 'footer-titles-settings',
			'type'           => 'typography',
			'title'          => esc_html__( 'Footer titles', 'wpjobster' ),
			'google'         => true,
			'all-styles'     => true,
			'all-subsets'    => true,
			'units'          => 'px',
			'word-spacing'   => true,
			'letter-spacing' => true,
			'text-align'     => true,
			'text-transform' => true,
			'default'        => array(
				'color'          => '#898eb4',
				'font-size'      => '16px',
				'line-height'    => 'normal',
				'font-family'    => 'Poppins',
				'font-weight'    => '700',
				'letter-spacing' => '2px',
				'text-transform' => 'uppercase',
			),
			'color_alpha' => true,
			'compiler'      => array( '.footer-wrapper .chw-widget .chw-title' ),
		),
		array(
			'id'             => 'footer-menus-settings',
			'type'           => 'typography',
			'title'          => esc_html__( 'Footer menus', 'wpjobster' ),
			'google'         => true,
			'all-styles'     => true,
			'all-subsets'    => true,
			'units'          => 'px',
			'word-spacing'   => true,
			'letter-spacing' => true,
			'text-align'     => true,
			'text-transform' => true,
			'color'          => false,
			'default'        => array(
				'font-size'   => '14px',
				'font-family' => 'Poppins',
				'font-weight' => '600',
				'color'       => '#454a60',
			),
			'compiler' => array( '
				.footer-widgets-content a
			'),
		)
	)
) );