<?php /* Headings */

Redux::setSection( $opt_name, array(
	'title'      => __( 'Headings', 'wpjobster' ),
	'id'         => 'headings-font-settings',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'             => 'h1-font-settings',
			'type'           => 'typography',
			'title'          => esc_html__( 'H1 style', 'wpjobster' ),
			'subtitle'       => esc_html__( 'Define styles for H1 heading', 'wpjobster' ),
			'google'         => true,
			'all-styles'     => true,
			'all-subsets'    => true,
			'units'          => 'px',
			'word-spacing'   => true,
			'letter-spacing' => true,
			'text-align'     => true,
			'text-transform' => true,
			'default'        => array(
				'color'       => '#313546',
				'font-size'   => '32px',
				'line-height' => '38px',
				'font-family' => 'Poppins',
				'font-weight' => '700',
			),
			'compiler' => array( '
				h1,
				h1 > *,
				.ui.header,
				.landing-image-wrapper .ui.header.landing-image-title,
				.levels-wrapper .user-type,
				.how-it-works-wrapper .user-type
			' ),
		),
		array(
			'id'             => 'h2-font-settings',
			'type'           => 'typography',
			'title'          => esc_html__( 'H2 style', 'wpjobster' ),
			'subtitle'       => esc_html__( 'Define styles for H2 heading', 'wpjobster' ),
			'google'         => true,
			'all-styles'     => true,
			'all-subsets'    => true,
			'units'          => 'px',
			'word-spacing'   => true,
			'letter-spacing' => true,
			'text-align'     => true,
			'text-transform' => true,
			'default'        => array(
				'color'       => '#313546',
				'font-size'   => '24px',
				'line-height' => '32px',
				'font-family' => 'Poppins',
				'font-weight' => '600',
			),
			'compiler' => array( '
				h2,
				h2 > *:not(.user-info-icons-wrapper):not(i):not(span),
				.landing-image-wrapper .landing-image-subtitle
			' ),
		),
		array(
			'id'             => 'h3-font-settings',
			'type'           => 'typography',
			'title'          => esc_html__( 'H3 style', 'wpjobster' ),
			'subtitle'       => esc_html__( 'Define styles for H3 heading', 'wpjobster' ),
			'google'         => true,
			'all-styles'     => true,
			'all-subsets'    => true,
			'units'          => 'px',
			'word-spacing'   => true,
			'letter-spacing' => true,
			'text-align'     => true,
			'text-transform' => true,
			'default'        => array(
				'color'       => '#313546',
				'font-size'   => '18px',
				'line-height' => '26px',
				'font-family' => 'Poppins',
				'font-weight' => '700',
			),
			'compiler' => array( '
				h3,
				h3 > *,
				.ui.cards > .card > .content > .header,
				.ui.card > .content > .header,
				.ui.modal > .header,
				.levels-wrapper .item-title,
				.how-it-works-wrapper .item-title
			' ),
		),
		array(
			'id'             => 'h4-font-settings',
			'type'           => 'typography',
			'title'          => esc_html__( 'H4 style', 'wpjobster' ),
			'subtitle'       => esc_html__( 'Define styles for H4 heading', 'wpjobster' ),
			'google'         => true,
			'all-styles'     => true,
			'all-subsets'    => true,
			'units'          => 'px',
			'word-spacing'   => true,
			'letter-spacing' => true,
			'text-align'     => true,
			'text-transform' => true,
			'default'        => array(
				'color'       => '#313546',
				'font-size'   => '14px',
				'line-height' => '20px',
				'font-family' => 'Poppins',
				'font-weight' => '700',
				'text-transform' => 'uppercase',
				'letter-spacing' => '1px',
			),
			'compiler' => array( '
				h4,
				h4 > *:not(a)
			' ),
		),
		array(
			'id'             => 'h5-font-settings',
			'type'           => 'typography',
			'title'          => esc_html__( 'H5 style', 'wpjobster' ),
			'subtitle'       => esc_html__( 'Define styles for H5 heading', 'wpjobster' ),
			'google'         => true,
			'all-styles'     => true,
			'all-subsets'    => true,
			'units'          => 'px',
			'word-spacing'   => true,
			'letter-spacing' => true,
			'text-align'     => true,
			'text-transform' => true,
			'default'        => array(
				'color'       => '#313546',
				'font-size'   => '16px',
				'line-height' => '24px',
				'font-family' => 'Poppins',
				'font-weight' => '700',
			),
			'compiler' => array( '
				h5,
				h5 > *,
			' ),
		),
		array(
			'id'             => 'h6-font-settings',
			'type'           => 'typography',
			'title'          => esc_html__( 'H6 style', 'wpjobster' ),
			'subtitle'       => esc_html__( 'Define styles for H6 heading', 'wpjobster' ),
			'google'         => true,
			'all-styles'     => true,
			'all-subsets'    => true,
			'units'          => 'px',
			'word-spacing'   => true,
			'letter-spacing' => true,
			'text-align'     => true,
			'text-transform' => true,
			'default'        => array(
				'color'       => '#bfc3e0',
				'font-size'   => '14px',
				'line-height' => '18px',
				'font-family' => 'Poppins',
				'font-weight' => '700',
				'text-transform' => 'uppercase',
				'letter-spacing' => '4px',
			),
			'compiler' => array('
				h6,
				h6 > *,
			' ),
		)
	)
) );