<?php
class WPJ_Transactions extends \stdClass {
	public function getRowQuery( $rows_per_page = 10, $pageno = 1, $limited = false ) {
		global $wpdb;

		$user         = WPJ_Form::get( 'search_user' );
		$search_input = ctype_digit( $user ) || is_int( $user ) ? $user : '';

		if ( ! $search_input ) {
			$search_input = wpj_get_user( 'ID', ['user_login' => $user], 'var' );
		}

		$query = "SELECT * FROM {$wpdb->prefix}job_payment_transactions";

		if ( $search_input ) $query .= " WHERE uid = {$search_input} OR id = {$search_input} OR oid = {$search_input}";

		$query .= " ORDER BY id DESC";

		if ( $limited ) $query .= " LIMIT " . ( $pageno - 1 ) * $rows_per_page . ',' . $rows_per_page;

		return $query;
	}

	public function getOrderRow() {
		$r = [ 'all' => '', 'limited' => '', 'lastpage' => '', 'pageno' => '' ];

		global $wpdb;

		$rows_per_page = 20;

		if ( isset( $_GET['pj'] ) ) $pageno = $_GET['pj'];
		else $pageno = 1;

		$s1 = $this->getRowQuery( $rows_per_page, $pageno, false );
		$s  = $this->getRowQuery( $rows_per_page, $pageno, true );

		$nr       = count( $wpdb->get_results( $s1 ) );
		$lastpage = ceil( $nr / $rows_per_page );

		$r = [
			'all'      => $wpdb->get_results( $s ),
			'limited'  => $wpdb->get_results( $s1 ),
			'lastpage' => $lastpage,
			'pageno'   => $pageno,
			'count'    => $nr
		];

		return $r;
	}
}