<?php
function wpj_display_order_page_content() { $order_class = new WPJ_Orders(); ?>

	<div class="wrap">
		<h2 class="wpj-admin-title">Jobster - <?php _e( 'Orders', 'wpjobster' ); ?></h2>

		<?php
		$message_status = $order_class->changeOrderStatusMessage();
		if ( isset( $message_status['message'] ) ) { ?>

			<div class="notice notice-<?php echo $message_status['type']; ?> is-dismissible">
				<p><?php echo $message_status['message']; ?></p>
			</div>

		<?php }

		$order_class->changeOrderStatusAction(); $order_class->closeJob(); $order_class->clearJob(); $order_class->processPayRequest();

		do_action( 'wpj_before_admin_orders_content' ); ?>

		<div id="usual2" class="usual wpj-admin-table-wrapper">

			<?php if ( isset( $_GET['order_id'] ) && isset( $_GET['payment_type'] ) && isset( $_GET['order_view'] ) ) {
				$order_id     = WPJ_Form::get( 'order_id', '' );
				$payment_type = WPJ_Form::get( 'payment_type', '' );
				$order_view   = WPJ_Form::get( 'order_view', '' );

				if ( $order_view == 'order_single_page' ) {
					wpj_show_order_single_page( $order_id, $payment_type );
				}

			} else { ?>

				<div class="wpj-admin-header">
					<ul>
						<li><a href="#job-purchase"><?php _e( 'Job Purchase', 'wpjobster' ); ?></a></li>
						<li><a href="#feature"><?php _e( 'Job Feature', 'wpjobster' ); ?></a></li>
						<li><a href="#custom-extra"><?php _e( 'Custom extra', 'wpjobster' ); ?></a></li>
						<li><a href="#tips"><?php _e( 'Tips', 'wpjobster' ); ?></a></li>
						<li><a href="#subscription"><?php _e( 'Subscription', 'wpjobster' ); ?></a></li>
						<li><a href="#topup"><?php _e( 'Topup', 'wpjobster' ); ?></a></li>
						<li><a href="#badge"><?php _e( 'Badge', 'wpjobster' ); ?></a></li>
						<li><a href="#withdrawal"><?php _e( 'Withdrawal', 'wpjobster' ); ?></a></li>
					</ul>
				</div>

				<div id="job-purchase">

					<div class="wpj-admin-top-search-form-wrapper">
						<?php wpj_search_order_form( 'job-purchase' ); ?>
					</div>

					<?php
					wpj_filter_order_form( 'job-purchase' );
					wpj_list_orders_to_admin( 'job-purchase' ); ?>

				</div>

				<div id="feature">

					<div class="wpj-admin-top-search-form-wrapper">
						<?php wpj_search_order_form( 'feature' ); ?>
					</div>

					<?php
					wpj_filter_order_form( 'feature' );
					wpj_list_orders_to_admin( 'feature' ); ?>

				</div>

				<div id="custom-extra">

					<div class="wpj-admin-top-search-form-wrapper">
						<?php wpj_search_order_form( 'custom-extra' ); ?>
					</div>

					<?php wpj_filter_order_form( 'custom-extra' );
					wpj_list_orders_to_admin( 'custom-extra' ); ?>

				</div>

				<div id="tips">

					<div class="wpj-admin-top-search-form-wrapper">
						<?php wpj_search_order_form( 'tips' ); ?>
					</div>

					<?php
					wpj_filter_order_form( 'tips' );
					wpj_list_orders_to_admin( 'tips' ); ?>

				</div>

				<div id="subscription">

					<div class="wpj-admin-top-search-form-wrapper">
						<?php wpj_search_order_form( 'subscription' ); ?>
					</div>

					<?php
					wpj_filter_order_form( 'subscription' );
					wpj_list_orders_to_admin( 'subscription' ); ?>

				</div>

				<div id="topup">

					<div class="wpj-admin-top-search-form-wrapper">
						<?php wpj_search_order_form( 'topup' ); ?>
					</div>

					<?php
					wpj_filter_order_form( 'topup' );
					wpj_list_orders_to_admin( 'topup' ); ?>

				</div>

				<div id="badge">

					<div class="wpj-admin-top-search-form-wrapper">
						<?php wpj_search_order_form( 'badge' ); ?>
					</div>

					<?php
					wpj_filter_order_form( 'badge' );
					wpj_list_orders_to_admin( 'badge' ); ?>

				</div>

				<div id="withdrawal">

					<div class="wpj-admin-top-search-form-wrapper">
						<?php wpj_search_order_form( 'withdrawal' ); ?>
					</div>

					<?php
					wpj_filter_order_form( 'withdrawal' );
					wpj_list_orders_to_admin( 'withdrawal' ); ?>

				</div>

			<?php } ?>

		</div>

	</div>

<?php }

function wpj_list_orders_to_admin( $payment_type = '' ) { $order_class = new WPJ_Orders();

	$r = $order_class->getOrderRow( $payment_type, WPJ_Form::get( 'status', '' ) );

	if ( $r['all'] ) { ?>

		<form method="POST">
			<table width="100%" class="wp-list-table widefat fixed posts">
				<thead>
					<tr>

						<?php if ( $payment_type == 'withdrawal' && WPJ_Form::get( 'status', '' ) == 'pending' ) { ?>

							<th width="4%" >
								<?php _e( 'All', 'wpjobster' ); ?>
								<input type="checkbox" name="option1" value="mass_pay" onclick="for(c in document.getElementsByName( 'requests[]' ) ) document.getElementsByName( 'requests[]' ).item( c ).checked = this.checked">
							</th>

						<?php } ?>

						<th><?php _e( 'ID', 'wpjobster' ); ?></th>
						<th><?php _e( 'Details', 'wpjobster' ); ?></th>

						<?php if ( $payment_type == 'job-purchase' || $payment_type == 'custom-extra' || $payment_type == 'tips' ) { ?>

							<th width="15%"><?php _e( 'Job Title', 'wpjobster' ); ?></th>

						<?php } ?>

						<?php if ( $payment_type == 'badge' ) { ?>

							<th width="15%"><?php _e( 'Description', 'wpjobster' ); ?></th>

						<?php } ?>

						<th><?php _e( 'Amount', 'wpjobster' ); ?></th>
						<th><?php _e( 'Date', 'wpjobster' ); ?></th>

						<?php if ( $payment_type == 'job-purchase' || $payment_type == 'custom-extra' || $payment_type == 'tips' ) { ?>

							<th><?php _e( 'Buyer', 'wpjobster' ); ?></th>
							<th><?php _e( 'Seller', 'wpjobster' ); ?></th>

						<?php } else { ?>

							<th><?php _e( 'User', 'wpjobster' ); ?></th>

						<?php }

						if ( $payment_type == 'withdrawal' ) { ?>

							<th><?php _e( 'User Info', 'wpjobster' ); ?></th>

						<?php }

						if ( $payment_type == 'subscription' ) { ?>

							<th><?php _e( 'Level', 'wpjobster' ); ?></th>
							<th><?php _e( 'Plan', 'wpjobster' ); ?></th>

						<?php } ?>

						<th><?php _e( 'Gateway', 'wpjobster' ); ?></th>
						<th><?php _e( 'Payment Status', 'wpjobster' ); ?></th>

						<?php if ( $payment_type == 'job-purchase' ) { ?>

							<th><?php _e( 'Order Status', 'wpjobster' ); ?></th>

						<?php } ?>

						<th width="61"><?php _e( 'Actions', 'wpjobster' ); ?></th>

					</tr>
				</thead>

				<tbody>

					<?php if ( $r['all'] ) {
						foreach ( $r['all'] as $row ) { ?>

							<tr>

								<?php if ( $payment_type == 'withdrawal' && WPJ_Form::get( 'status', '' ) == 'pending' ) {

									$method = strtolower( trim( preg_replace( '/\s*\([^)]*\)/', '', $row->methods ) ) );

									if ( in_array( $method, wpj_get_withdrawals_payment_gateways() ) ) { ?>

										<td>
											<input type="checkbox" name="requests[]" value="<?php echo $row->id; ?>" />
										</td>

									<?php } else { ?>

										<td></td>

									<?php }

								}

								$values = $order_class->getRowValues( $payment_type, $row );
								
								foreach ( $values as $value ) { ?>

									<td><?php echo $value; ?></td>

								<?php } ?>

								<td><?php $order_class->showOrderActions( $payment_type, WPJ_Form::get( 'status', '' ), $row ); ?></td>

							</tr>

						<?php }

						if ( $payment_type == 'withdrawal' && WPJ_Form::get( 'status', '' ) == 'pending' ) { ?>

							<tfoot>
								<tr>
									<td colspan="10">

										<?php $paypal_appid = wpj_get_option( 'wpjobster_theme_appid' );
										$paypal_appsecret = wpj_get_option( 'wpjobster_theme_appsecret' );

										if ( ! empty( $paypal_appid ) && ! empty( $paypal_appsecret ) ) { ?>

											<input class="button-secondary" type="submit" value="<?php _e( 'Process PayPal Requests', 'wpjobster' ); ?>" name="processPayRequest" id="processPayRequest" />

										<?php }

										do_action( 'wpj_after_admin_orders_tfoot_buttons', $payment_type ); ?>

									</td>
								</tr>
							</tfoot>

						<?php }

					} ?>

				</tbody>
			</table>
		</form>

		<?php wpj_show_pagination_bar( $r, $order_class->getActiveTabInfo( $payment_type ) );

	} else { ?>

		<div style="padding:15px; background: #fff;"><?php _e( 'No orders yet.', 'wpjobster' ); ?></div>

	<?php }
}

function wpj_search_order_form( $payment_type = '' ) { $order_class = new WPJ_Orders(); ?>

	<form method="get" action="<?php bloginfo( 'url' ); ?>/wp-admin/admin.php" class="admin-small-search-form">

		<?php $page_info = $order_class->getActiveTabInfo( $payment_type );
		$status = WPJ_Form::get( 'status' ); ?>

		<input type="hidden" value="jobster-orders" name="page" />
		<input type="hidden" value="<?php echo $page_info['at']; ?>" name="active_tab" />
		<input type="hidden" value="<?php echo $status; ?>" name="status" />
		<input type="text" placeholder="<?php _e( 'Username or ID', 'wpjobster' ); ?>" value="<?php echo WPJ_Form::get( $page_info['inp'] ); ?>" name="<?php echo $page_info['inp']; ?>" size="20" />
		<input type="text" placeholder="<?php _e( 'Order ID', 'wpjobster' ); ?>" value="<?php echo WPJ_Form::get( $page_info['inp'] . '_id' ); ?>" name="<?php echo $page_info['inp'] . '_id'; ?>" size="20" />
		<input type="submit" class="button-secondary" name="<?php echo $page_info['sb']; ?>" value="<?php _e( 'Search', 'wpjobster' ); ?>"/>
	</form>

<?php }

function wpj_filter_order_form( $payment_type = '' ) { $order_class = new WPJ_Orders();

	$filters = $order_class->getOrderFilters( $payment_type ) ?>

	<ul class="order-status">

		<?php $numItems = count( $filters ); $i = 0;

		if ( $filters ) {

			foreach ( $filters as $key => $filter ) { ?>

				<li class="<?php echo strtolower( $key ); ?>">

					<a href="<?php echo bloginfo( 'url' ) . '/wp-admin/admin.php?page=jobster-orders&active_tab=' . $payment_type . '&status=' . strtolower( $key ); ?>">

						<?php
						$status = WPJ_Form::get( 'status', '' );

						if ( ( strtolower( $status ) == strtolower( $key ) ) || ( ! strtolower( $status ) && $key == 'all' ) ) { echo '<b>'; }

						echo ucfirst( $filter ) ?>&nbsp;<span class="count">(<?php echo $order_class->getCountOfOrders( $payment_type, $key ); ?>)</span>

						<?php if ( ( strtolower( $status ) == strtolower( $key ) ) || ( ! strtolower( $status ) && $key == 'all' ) ) { echo '</b>'; } ?>

					</a>

					<?php if ( ++$i !== $numItems) { echo ' |'; } ?>

				</li>

			<?php }

		} ?>

	</ul>

<?php }