<?php
function wpj_show_order_single_page( $order_id = '', $payment_type = '' ) { $order_class = new WPJ_Orders();

	if ( $order_id && $payment_type ) { ?>

		<div class="order-single-page">
			<button class="view-all-orders" onclick="location.href='<?php echo get_bloginfo( 'url' ) . '/wp-admin/admin.php?page=jobster-orders'; ?>'" type="button"><?php _e( 'View all orders', 'wpjobster' ); ?></button>

			<h2><?php echo ucwords( str_replace( "-", " ", $payment_type ) ) .' - '. sprintf( __( 'Order #%s', 'wpjobster' ), $order_id ); ?></h2>

			<!-- PAYMENT -->
			<div class="postbox">
				<h4 class="postbox-title">
					<span><?php _e( 'Payment Information', 'wpjobster' ); ?></span>
				</h4>

				<div class="postbox-title-content">

					<?php $order_class->listSingleJobValues( $order_id, $payment_type, 'payment' ); ?>

				</div>
			</div>

			<!-- ORDER -->
			<div class="postbox">
				<h4 class="postbox-title">
					<span><?php _e( 'Order Information', 'wpjobster' ); ?></span>
				</h4>

				<div class="postbox-title-content">

					<?php $order_class->listSingleJobValues( $order_id, $payment_type, 'order' ); ?>

				</div>
			</div>

			<!-- PRICE -->
			<?php if ( $payment_type != 'badge' ) { ?>

				<div class="postbox">
					<h4 class="postbox-title">
						<span><?php _e( 'Order Price Information', 'wpjobster' ); ?></span>
					</h4>

					<div class="postbox-title-content">

						<?php $order_class->listSingleJobValues( $order_id, $payment_type, 'price' ); ?>

					</div>
				</div>

			<?php }

			if ( $payment_type == 'job-purchase' ) { ?>

				<!-- EXTRAS -->
				<div class="postbox">
					<h4 class="postbox-title">
						<span><?php _e( 'Extra', 'wpjobster' ); ?></span>
					</h4>

					<div class="postbox-title-content">

						<?php $job_purchase_values = $order_class->getJobPurchaseOrderDetails( $order_id );
						if ( $job_purchase_values['extra'] ) { ?>

							<table>

								<?php foreach ( $job_purchase_values['extra'] as $extra_key => $extra_value ) {
									if ( $extra_key < 10 && $extra_value['extra' . ( $extra_key + 1 )]['enable'] == 1 ) { ?>

										<tr><td><p><?php _e( 'Extra', 'wpjobster' ) . ' #' . ( $extra_key + 1 ); ?></p></td></tr>

										<?php foreach ( $extra_value['extra' . ( $extra_key + 1 )] as $extra_key2 => $extra_value2 ) {
											if ( $extra_key2 != 'enable' ) { ?>

												<tr>
													<td><?php echo '<b>' . $extra_value2['label'] . ':  </b>'; ?></td>
													<td><?php echo $extra_value2['value']; ?></td>
												</tr>

											<?php }
										}
									}

									if ( $extra_key == 10 && $extra_value['extra_fast']['enable'] == 1 ) { ?>

										<tr><td><p><?php _e( 'Extra Fast Delivery', 'wpjobster' ); ?></p></td></tr>

										<?php foreach ( $extra_value['extra_fast'] as $extra_key_fast => $extra_value_fast ) {
											if ( $extra_key_fast != 'enable' ) { ?>

												<tr>
													<td><?php echo '<b>' . $extra_value_fast['label'] . ':  </b>'; ?></td>
													<td><?php echo $extra_value_fast['value']; ?></td>
												</tr>

											<?php }
										}
									}

									if ( $extra_key == 11 && $extra_value['extra_revision']['enable'] == 1 ) { ?>

										<tr><td><p><?php _e( 'Additional Revision', 'wpjobster' ); ?></p></td></tr>

										<?php foreach ( $extra_value['extra_revision'] as $extra_key_revision => $extra_value_revision ) {
											if ( $extra_key_revision != 'enable' ) { ?>

												<tr>
													<td><?php echo '<b>' . $extra_value_revision['label'] . ':  </b>'; ?></td>
													<td><?php echo $extra_value_revision['value']; ?></td>
												</tr>

											<?php }
										}
									}
								} ?>

							</table>

						<?php } else { ?>

							<p><?php _e( 'No extras for this order', 'wpjobster' ); ?></p>

						<?php } ?>

					</div>
				</div>

				<!-- CUSTOM EXTRAS -->
				<div class="postbox">
					<h4 class="postbox-title">
						<span><?php echo apply_filters( 'wpj_admin_custom_extra_string_filter', __( 'Custom Extra', 'wpjobster' ), $order_id ); ?></span>
					</h4>

					<div class="postbox-title-content">

						<?php $order_class->listSingleJobValues( $order_id, $payment_type, 'custom_extra' ); ?>

					</div>
				</div>

				<!-- TIPS -->
				<div class="postbox">
					<h4 class="postbox-title">
						<span><?php _e( 'Tips', 'wpjobster' ); ?></span>
					</h4>

					<div class="postbox-title-content">

						<?php $order_class->listSingleJobValues( $order_id, $payment_type, 'tips' ); ?>

					</div>
				</div>

				<!-- CANCELLATION AND MODIFICATIONS -->
				<div class="postbox">
					<h4 class="postbox-title">
						<span><?php _e( 'Cancellation & Modification', 'wpjobster' ); ?></span>
					</h4>

					<div class="postbox-title-content">

						<?php if ( $job_purchase_values['cancellation'] || $job_purchase_values['modification'] ) {
							$order_class->listSingleJobValues( $order_id, $payment_type, 'cancellation' );
							$order_class->listSingleJobValues( $order_id, $payment_type, 'modification' );

						} else { ?>

							<p><?php _e( 'No informations about order cancellation or modification', 'wpjobster' ); ?></p>

						<?php } ?>

					</div>
				</div>

				<!-- REVIEWS -->
				<div class="postbox">
					<h4 class="postbox-title">
						<span><?php _e( 'Reviews', 'wpjobster' ); ?></span>
					</h4>

					<div class="postbox-title-content">

						<?php $order_class->listSingleJobValues( $order_id, $payment_type, 'buyer_review' );
						$order_class->listSingleJobValues( $order_id, $payment_type, 'seller_review' ); ?>

					</div>
				</div>

				<!-- CHATBOX MESSAGES -->
				<div class="postbox">
					<h4 class="postbox-title">
						<span><?php _e( 'Messages', 'wpjobster' ); ?></span>
					</h4>

					<div class="postbox-title-content">

						<?php $order_class->listSingleJobValues( $order_id, $payment_type, 'chatbox_messages' ); ?>

					</div>
				</div>

			<?php } ?>

			<?php if ( $payment_type == 'subscription' ) { ?>

				<div class="postbox">
					<h4 class="postbox-title">
						<span><?php _e( 'Next Billing Information', 'wpjobster' ); ?></span>
					</h4>

					<div class="postbox-title-content">

						<?php $order_class->listSingleJobValues( $order_id, $payment_type, 'billing' ); ?>

					</div>
				</div>

			<?php } ?>

			<!-- GATEWAY RESPONSES -->
			<div class="postbox">
				<h4 class="postbox-title">
					<span><?php _e( 'Gateway Responses', 'wpjobster' ); ?></span>
				</h4>

				<div class="postbox-title-content">

					<?php $order_class->listSingleJobValues( $order_id, $payment_type, 'gateway_responses' ); ?>

				</div>
			</div>

		</div>

	<?php }
}