<?php
function wpj_display_resolution_center_page_content() { $resolution_center_class = new WPJ_Resolution_Center(); ?>

	<div class="wrap">
		<h2 class="wpj-admin-title">Jobster - <?php _e( 'Resolution Center', 'wpjobster' ); ?></h2>

		<div id="usual2" class="usual wpj-admin-table-wrapper">

			<div class="wpj-admin-header">
				<ul>
					<li><a href="#order-arbitration"><?php _e( 'Order Arbitration', 'wpjobster' ); ?></a></li>
				</ul>
			</div>

			<!-- Order Arbitration -->
			<div id="order-arbitration">

				<div class="wpj-admin-top-search-form-wrapper">
					<?php wpj_search_resolution_center_form(); ?>
				</div>

				<ul class="order-status">

					<?php $filters = [
						'all'              => __( 'All', 'wpjobster' ),
						'active'           => __( 'Active', 'wpjobster' ),
						'completed_buyer'  => __( 'Completed for buyer', 'wpjobster' ),
						'completed_seller' => __( 'Completed for seller', 'wpjobster' ),
						'completed'        => __( 'Completed', 'wpjobster' ),
						'aborted'          => __( 'Aborted', 'wpjobster' ),
					];

					$numItems = count( $filters ); $i = 0;

					if ( $filters ) {
						foreach ( $filters as $key => $filter ) { ?>

							<li class="<?php echo strtolower( $key ); ?>">

								<a href="<?php echo bloginfo( 'url' ) . '/wp-admin/admin.php?page=jobster-resolution-center&active_tab=order-arbitration&status=' . strtolower( $key ); ?>">

									<?php $status = WPJ_Form::get( 'status', '' );

									if ( ( strtolower( $status ) == strtolower( $key ) ) || ( ! strtolower( $status ) && $key == 'all' ) ) { echo '<b>'; }

										echo ucfirst( $filter ) ?>&nbsp;<span class="count">(<?php echo $resolution_center_class->getCountOfOrders( $key ); ?>)</span>

									<?php if ( ( strtolower( $status ) == strtolower( $key ) ) || ( ! strtolower( $status ) && $key == 'all' ) ) { echo '</b>'; } ?>

								</a>

								<?php if ( ++$i !== $numItems) { echo ' |'; } ?>

							</li>

						<?php }
					} ?>

				</ul>

				<?php
				$rows = $resolution_center_class->getOrderRow( WPJ_Form::get( 'status', '' ) );

				if ( $rows['count'] > 0 ) { ?>

					<table class="widefat post" cellspacing="0">
						<thead>
							<tr>
								<th><?php _e( 'ID', 'wpjobster' ); ?></th>
								<th><?php _e( 'Transaction', 'wpjobster' ); ?></th>
								<th><?php _e( 'Request From', 'wpjobster' ); ?></th>
								<th><?php _e( 'Request Date', 'wpjobster' ); ?></th>
								<th width="25%"><?php _e( 'Message to Support', 'wpjobster' ); ?></th>
								<th width="25%"><?php _e( 'Message from Support', 'wpjobster' ); ?></th>
								<th><?php _e( 'Status', 'wpjobster' ); ?></th>
								<th><?php _e( 'Arbitration Date', 'wpjobster' ); ?></th>
								<th><?php _e( 'Action', 'wpjobster' ); ?></th>
							</tr>
						</thead>

						<tbody>

							<?php foreach( $rows['all'] as $row ) {

								$textarea = false;
								if ( $row->buyer_arbitration == 1 ) {
									$status = __( 'Completed for buyer', 'wpjobster' );

								} elseif ( $row->seller_arbitration == 1 ) {
									$status = __( 'Completed for seller', 'wpjobster' );

								} elseif ( $row->request_from_buyer == 0 && $row->request_from_seller == 0 ) {
									$status = __( 'Aborted', 'wpjobster' );
									$textarea = false;

								} else {
									$status = __( 'Active', 'wpjobster' );
									$textarea = true;

								}

								if ( $row->request_from_buyer == 1 ) {
									$user_id = $row->uid;
								} elseif ( $row->request_from_seller == 1 ) {
									$user_id = wpj_get_seller_id( $row );
								} else {
									$user_id = '';
								}

								$user = $user_id ? get_userdata( $user_id ) : '';
								$username = $user ? wpj_get_user_display_type( $user->ID ) : '-';
								$message_from_support = $row->message_from_support ? $row->message_from_support : '-'; ?>

								<tr>
									<td><?php echo $row->arbitration_id; ?></td>
									<td><?php echo '<a href="' . wpj_get_order_link( $row->order_id ) . '">' . $row->order_id . '</a>'; ?></td>
									<td><?php echo $username; ?></td>
									<td><?php echo $row->date_request ? wpj_date( wpj_get_option( 'date_format' ) . ' ' . wpj_get_option( 'time_format' ), $row->date_request ) : ''; ?></td>
									<td><?php echo $row->message_to_support; ?></td>
									<td><?php echo $textarea ? '<textarea class="rc-message-textarea" name=""></textarea>' : $message_from_support; ?></td>
									<td><?php echo $status; ?></td>
									<td><?php echo $row->date_arbitration ? wpj_date( wpj_get_option( 'date_format' ) . ' ' . wpj_get_option( 'time_format' ), $row->date_arbitration ) : '-'; ?></td>
									<td>

										<?php if ( $textarea ) { ?>

											<a title="<?php _e( 'Mark completed in favor of a buyer', 'wpjobster' ); ?>" data-id="<?php echo $row->arbitration_id; ?>" data-action="completed_for_buyer" class="js-complete-arbitration awesome tltp_cls">
												<span class="rc-action-icon"><i class="user icon"></i></span>
											</a>

											<a title="<?php _e( 'Mark completed in favor of a seller', 'wpjobster' ); ?>" data-id="<?php echo $row->arbitration_id; ?>" data-action="completed_for_seller" class="js-complete-arbitration awesome tltp_cls">
												<span class="rc-action-icon"><i class="user outline square icon"></i></span>
											</a>

										<?php } elseif ( $row->request_from_buyer == 0 && $row->request_from_seller == 0 ) { ?>

											<a title="<?php _e( 'Aborted', 'wpjobster' ); ?>" class="awesome tltp_cls">
												<span class="rc-action-icon disabled"><i class="user icon"></i></span>
											</a>

											<a title="<?php _e( 'Aborted', 'wpjobster' ); ?>" class="awesome tltp_cls">
												<span class="rc-action-icon disabled"><i class="user outline square icon"></i></span>
											</a>

										<?php } else { ?>

											<a title="<?php _e( 'Marked already completed', 'wpjobster' ); ?>" class="awesome tltp_cls">
												<span class="rc-action-icon disabled"><i class="user icon"></i></span>
											</a>

											<a title="<?php _e( 'Marked already completed', 'wpjobster' ); ?>" class="awesome tltp_cls">
												<span class="rc-action-icon disabled"><i class="user outline square icon"></i></span>
											</a>

										<?php } ?>

									</td>
								</tr>

							<?php } ?>

						</tbody>
					</table>

					<?php wpj_show_pagination_bar( $rows );

				} else { ?>

					<div style="padding:15px; background: #fff;">
						<?php _e( 'There are no arbitrations yet!', 'wpjobster' ); ?>
					</div>

				<?php } ?>

			</div>
		</div>
	</div>

<?php }

function wpj_search_resolution_center_form() { ?>

	<form method="get" action="<?php bloginfo('url'); ?>/wp-admin/admin.php" class="admin-small-search-form">
		<input type="hidden" value="jobster-resolution-center" name="page" />
		<input type="hidden" value="order-arbitration" name="active_tab" />
		<i class="icon search"></i>
		<input type="text" value="<?php echo WPJ_Form::get( 'search_user' ); ?>" name="search_user" size="20" placeholder="<?php _e( 'Search by id, order id, user id or username', 'wpjobster' ); ?>" />
		<input type="submit" class="button-secondary" name="wpjobster_resolution_center_search" value="<?php _e( 'Search', 'wpjobster' ); ?>" />
	</form>

<?php }