<?php
function wpj_display_summary_page_content() { ?>

	<div class="wrap sales-report">

		<h2 class="wpj-admin-title">Jobster - <?php _e( 'Summary', 'wpjobster' ); ?></h2>

		<div id="usual2" class="usual">

			<div class="wpj-admin-header">
				<ul>
					<li><a href="#tabs1" class="sales-report-title"><?php _e( "Summary", 'wpjobster' ); ?></a></li>
					<li><a href="#tabs2" class="sales-report-title"><?php _e( "Job Purchase", 'wpjobster '); ?></a></li>
					<li><a href="#tabs3" class="sales-report-title"><?php _e( "Topup ", 'wpjobster' ); ?></a></li>
					<li><a href="#tabs4" class="sales-report-title"><?php _e( "Featured", 'wpjobster' ); ?></a></li>
					<li><a href="#tabs5" class="sales-report-title"><?php _e( "Refunded", 'wpjobster' ); ?></a></li>
					<li><a href="#tabs6" class="sales-report-title"><?php _e( "Withdrawal", 'wpjobster' ); ?></a></li>
					<li><a href="#tabs7" class="sales-report-title"><?php _e( "Custom Extra", 'wpjobster '); ?></a></li>
					<li><a href="#tabs8" class="sales-report-title"><?php _e( "Tips", 'wpjobster' ); ?></a></li>
					<li><a href="#tabs9" class="sales-report-title"><?php _e( "Subscription", 'wpjobster' ); ?></a></li>
					<li><a href="#badge" class="sales-report-title"><?php _e( "Badge", 'wpjobster' ); ?></a></li>
				</ul>
			</div>

			<form action="javascript://" id="form_sales_report" class="">
				<div class="cf">

					<table width="100%" class="wpj-admin-table">

						<tr>
							<td>
								<div id="reportrange">
									<i class="calendar alternate outline icon"></i>
									<span></span>
									<i class="caret down icon" style="margin:0"></i>
								</div>

								<select id="graph-range" name="graph-range">
									<option value="days"><?php _e( 'Days', 'wpjobster' ); ?></option>
									<option value="weeks"><?php _e( 'Weeks', 'wpjobster' ); ?></option>
									<option value="months"><?php _e( 'Months', 'wpjobster' ); ?></option>
								</select>
							</td>
						</tr>

						<tr>
							<td>
								<input type="hidden" id="sales_report_action" name="action">
								<input type="hidden" name="report_type" id="report_type" value="table" />
								<input type="hidden" name="from_date" id="from_date" value="" />
								<input type="hidden" name="to_date" id="to_date" value="" />

								<input type="text" id="user-id-or-username" name="userid" placeholder="<?php _e( "User ID/Username", "wpjobster" ); ?>">

								<input type="submit" class="button-secondary filter-summary-btn" name="submit" value="<?php _e( 'Filter', 'wpjobster' ); ?>" />
								<span id="user_error_report"></span>
							</td>
						</tr>

						<tr>
							<td>
								<select class="btn-right" name="csv-separator" id="csv-separator">
									<option value=",">,</option>
									<option value=";">;</option>
								</select>
								<span class="csv-separator"><?php _e( 'CSV Separator', 'wpjobster' ); ?>:</span>
							</td>
						</tr>

					</table>
				</div>

				<div id="tabs1">
					<button class="btn-right button-secondary" id="btn-summary-csv"><?php _e( 'Export Summary Report to CSV', 'wpjobster'  ); ?></button>

					<h2 class="report-title"><?php _e( "Summary Report", "wpjobster" ); ?></h2>
					<div id="summary-report-graph" class="report-graph">
						<div id="summary-report-graph-chart" class="graph-position"><i class="report-loader notched circle loading icon"></i></div>
					</div>
					<div id="summary-report-table" class="report-table">
						<i class="report-loader notched circle loading icon"></i>
					</div>
				</div>

				<div id="tabs2">
					<button class="btn-right button-secondary" id="btn-job-purchase-csv"><?php _e( 'Export Job Purchase Report to CSV', 'wpjobster' ); ?></button>

					<h2 class="report-title"><?php _e( "Job Purchase Report", "wpjobster" ); ?></h2>
					<div id="job-report-graph" class="report-graph">
						<div id="job-report-graph-chart" class="graph-position">
							<i class="report-loader notched circle loading icon"></i>
						</div>
					</div>
					<div id="job-report-table" class="report-table">
						<i class="report-loader notched circle loading icon"></i>
					</div>
				</div>

				<div id="tabs3">
					<button class="btn-right button-secondary" id="btn-topup-csv"><?php _e( 'Export Topup Report to CSV', 'wpjobster' ); ?></button>

					<h2 class="report-title"><?php _e( "Top up Report", "wpjobster" ); ?></h2>
					<div id="topup-report-graph" class="report-graph">
						<div id="topup-report-graph-chart" class="graph-position"><i class="report-loader notched circle loading icon"></i></div>
					</div>
					<div id="topup-report-table" class="report-table">
						<i class="report-loader notched circle loading icon"></i>
					</div>
				</div>

				<div id="tabs4">
					<button class="btn-right button-secondary" id="btn-featured-csv"><?php _e( 'Export Featured Report to CSV', 'wpjobster' ); ?></button>

					<h2 class="report-title"><?php _e( "Featured Report", "wpjobster" ); ?></h2>
					<div id="featured-report-graph" class="report-graph">
						<div id="featured-report-graph-chart" class="graph-position"><i class="report-loader notched circle loading icon"></i></div>
					</div>
					<div id="featured-report-table" class="report-table">
						<i class="report-loader notched circle loading icon"></i>
					</div>
				</div>

				<div id="tabs5">
					<button class="btn-right button-secondary" id="btn-refund-csv"><?php _e( 'Export Refund Report to CSV', 'wpjobster' ); ?></button>

					<h2 class="report-title"><?php _e( "Refund Report", "wpjobster" ); ?></h2>
					<div id="refund-report-graph" class="report-graph">
						<div id="refunded-report-graph-chart" class="graph-position"><i class="report-loader notched circle loading icon"></i></div>
					</div>
					<div id="refund-report-table" class="report-table">
						<i class="report-loader notched circle loading icon"></i>
					</div>
				</div>

				<div id="tabs6">
					<button class="btn-right button-secondary" id="btn-withdrawal-csv"><?php _e( 'Export Withdrawal Report to CSV', 'wpjobster' ); ?></button>

					<h2 class="report-title"><?php _e( "Withdrawal Report", "wpjobster" ); ?></h2>
					<div id="withdrawal-report-graph" class="report-graph">
						<div id="withdrawal-report-graph-chart" class="graph-position"><i class="report-loader notched circle loading icon"></i></div>
					</div>
					<div id="withdrawal-report-table" class="report-table">
						<i class="report-loader notched circle loading icon"></i>
					</div>
				</div>

				<div id="tabs7">
					<button class="btn-right button-secondary" id="btn-custom-extra-csv"><?php _e( 'Export Custom Extra Report to CSV', 'wpjobster' ); ?></button>

					<h2 class="report-title"><?php _e( "Custom Extra Report", "wpjobster" ); ?></h2>
					<div id="custom-extra-report-graph" class="report-graph">
						<div id="custom-extra-report-graph-chart" class="graph-position"><i class="report-loader notched circle loading icon"></i></div>
					</div>
					<div id="custom-extra-report-table" class="report-table">
						<i class="report-loader notched circle loading icon"></i>
					</div>
				</div>

				<div id="tabs8">
					<button class="btn-right button-secondary" id="btn-tips-csv"><?php _e( 'Export Tips Report to CSV', 'wpjobster' ); ?></button>

					<h2 class="report-title"><?php _e( "Tips Report", "wpjobster" ); ?></h2>
					<div id="tips-report-graph" class="report-graph">
						<div id="tips-report-graph-chart" class="graph-position"><i class="report-loader notched circle loading icon"></i></div>
					</div>
					<div id="tips-report-table" class="report-table">
						<i class="report-loader notched circle loading icon"></i>
					</div>
				</div>

				<div id="tabs9">
					<button class="btn-right button-secondary" id="btn-subscription-csv"><?php _e( 'Export Subscription Report to CSV', 'wpjobster' ); ?></button>

					<h2 class="report-title"><?php _e( "Subscription Report", "wpjobster" ); ?></h2>
					<div id="subscription-report-graph" class="report-graph">
						<div id="subscription-report-graph-chart" class="graph-position"><i class="report-loader notched circle loading icon"></i></div>
					</div>
					<div id="subscription-report-table" class="report-table">
						<i class="report-loader notched circle loading icon"></i>
					</div>
				</div>

				<div id="badge">
					<button class="btn-right button-secondary" id="btn-badge-csv"><?php _e( 'Export Badge Report to CSV', 'wpjobster' ); ?></button>

					<h2 class="report-title"><?php _e( "Badge Report", "wpjobster" ); ?></h2>
					<div id="badge-report-graph" class="report-graph">
						<div id="badge-report-graph-chart" class="graph-position"><i class="report-loader notched circle loading icon"></i></div>
					</div>
					<div id="badge-report-table" class="report-table">
						<i class="report-loader notched circle loading icon"></i>
					</div>
				</div>

			</form>

		</div>

	</div>

<?php }