<?php function wpj_display_transactions_page_content() { $transaction_class = new WPJ_Transactions(); ?>

	<div class="wrap">
		<h2 class="wpj-admin-title">Jobster - <?php _e( 'Transactions', 'wpjobster' ); ?></h2>

		<div id="usual2" class="usual wpj-admin-table-wrapper">

			<div class="wpj-admin-header">
				<ul>
					<li><a href="#tabs1"><?php _e( 'Transactions', 'wpjobster' ); ?></a></li>
				</ul>
			</div>

			<!-- Transactions -->
			<div id="tabs1">

				<div class="wpj-admin-top-search-form-wrapper">
					<?php wpj_search_user_transaction_form(); ?>
				</div>

				<?php $rows = $transaction_class->getOrderRow();

				if ( $rows['count'] > 0 ) { ?>

					<table class="widefat post fixed" cellspacing="0">
						<thead>
							<tr>
								<th width="10%"><?php _e( 'Transaction ID', 'wpjobster' ); ?></th>
								<th width="10%"><?php _e( 'Username', 'wpjobster' ); ?></th>
								<th width="40%"><?php _e( 'Comment/Description', 'wpjobster' ); ?></th>
								<th><?php _e( 'Date Made', 'wpjobster' ); ?></th>
								<th><?php _e( 'Amount', 'wpjobster' ); ?></th>
							</tr>
						</thead>

						<tbody>

							<?php foreach ( $rows['all'] as $row ) {

								$user = ( $row->uid ) ? get_userdata( $row->uid ) : '';
								$username = ( $user ) ? wpj_get_user_display_type( $user->ID ) : '';

								if ( $row->tp == 0 ) { $sign = '-'; $cl = 'color-ff6252'; }
								else { $sign = '+'; $cl = 'color-20c497'; }

								$t_id = $row->oid ? ' (#'.wpj_camouflage_oid( $row->oid ).')' : ''; ?>

								<tr>
									<td><?php echo $row->id . $t_id; ?></td>
									<td><?php echo $username; ?></td>
									<td><?php echo wpj_stripslashes( $row->reason ); ?></td>
									<td><?php echo wpj_date( wpj_get_option( 'date_format' ) . ' ' . wpj_get_option( 'time_format' ), $row->datemade ); ?></td>
									<td class="<?php echo $cl; ?>"><?php echo $sign . wpj_show_price_classic( $row->amount, 2 ); ?></td>
								</tr>

							<?php } ?>

						</tbody>
					</table>

					<?php wpj_show_pagination_bar( $rows );

				} else { ?>

					<div style="padding:15px;  background: #fff;"><?php _e( 'There are no transactions yet!', 'wpjobster' ); ?></div>

				<?php } ?>

			</div>
		</div>
	</div>

<?php }

function wpj_search_user_transaction_form() { ?>

	<form method="get" action="<?php bloginfo('url'); ?>/wp-admin/admin.php" class="admin-small-search-form">
		<input type="hidden" value="jobster-transactions" name="page" />
		<input type="hidden" value="tabs1" name="active_tab" />
		<i class="icon search"></i>
		<input type="text" value="<?php echo WPJ_Form::get( 'search_user', '' ); ?>" name="search_user" size="20" placeholder="<?php _e( 'Search by id, order id, user id or username', 'wpjobster' ); ?>" />
		<input type="submit" class="button-secondary" name="wpjobster_user_transaction_search" value="<?php _e( 'Search', 'wpjobster' ); ?>"/>
	</form>

<?php }
