<?php // Filter Settings

$character_filter_settings_array = array(
	'title'      => __( 'Filters', 'wpjobster' ),
	'desc'       => __( 'Filters Settings', 'wpjobster' ),
	'id'         => 'filters-settings',
	'subsection' => true,
	'fields'     => array(

/* BLOCKLISTED WORDS */
		array(
			'id'       => 'wpjobster_disable_filters',
			'type'     => 'switch',
			'title'    => esc_html__( 'Disable Filters', 'wpjobster' ),
			'subtitle' => esc_html__( 'Choose if you want to have filters or not.', 'wpjobster' ),
			'indent'   => true,
			'on'       => __( 'Yes', 'wpjobster' ),
			'off'      => __( 'No', 'wpjobster' ),
			'default'  => false
		),
		array(
			'id'       => 'filter-words-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Blocklisted Words', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'       => 'wpjobster_blacklisted_words_pm',
			'type'     => 'textarea',
			'title'    => esc_html__( 'Blocklisted Words', 'wpjobster' ),
			'default'  => "email\ntelephone\nskype"
		),
		array(
			'id'       => 'wpj_filter_words1',
			'type'     => 'select',
			'title'    => esc_html__( 'Where does it apply?', 'wpjobster' ),
			'subtitle' => esc_html__( 'Choose the places where you want the words from the blocklist to be filtered.', 'wpjobster' ),
			'multi'    => true,
			'options'  => array(
				'privatemessages'  => __( 'Private Messages', 'wpjobster' ),
				'transactionpages' => __( 'Transaction Pages', 'wpjobster' ),
				'joblistings'      => __( 'Job Listings', 'wpjobster' ),
				'requestlistings'  => __( 'Request Listings', 'wpjobster' ),
				'userprofiles'     => __( 'User Profiles', 'wpjobster' )
			),
			'default'  => array( 'privatemessages', 'transactionpages', 'joblistings', 'requestlistings', 'userprofiles' )
		),
		array(
			'id'       => 'wpjobster_blacklisted_words_pm_err',
			'type'     => 'textarea',
			'title'    => esc_html__( 'Blocklisted Words Error', 'wpjobster' ),
			'default'  => 'Providing your contact details in messages is against our terms of service!',
		),
		array(
			'id'       => 'wpjobster_blacklisted_words2_pm',
			'type'     => 'textarea',
			'title'    => esc_html__( 'Blocklisted Words 2', 'wpjobster' ),
			'default'  => "paypal\nstripe"
		),
		array(
			'id'       => 'wpj_filter_words2',
			'type'     => 'select',
			'title'    => esc_html__( 'Where does it apply?', 'wpjobster' ),
			'subtitle' => esc_html__( 'Choose the places where you want the words from the blocklist 2 to be filtered.', 'wpjobster' ),
			'multi'    => true,
			'options'  => array(
				'privatemessages'  => __( 'Private Messages', 'wpjobster' ),
				'transactionpages' => __( 'Transaction Pages', 'wpjobster' ),
				'joblistings'      => __( 'Job Listings', 'wpjobster' ),
				'requestlistings'  => __( 'Request Listings', 'wpjobster' ),
				'userprofiles'     => __( 'User Profiles', 'wpjobster' )
			),
			'default'  => array( 'privatemessages', 'transactionpages', 'joblistings', 'requestlistings', 'userprofiles' )
		),
		array(
			'id'       => 'wpjobster_blacklisted_words2_pm_err',
			'type'     => 'textarea',
			'title'    => esc_html__( 'Blocklisted Words 2 Error', 'wpjobster' ),
			'default'  => 'You cannot offer to pay directly to users.',
		),
		array(
			'id'       => 'wpjobster_blacklisted_words3_pm',
			'type'     => 'textarea',
			'title'    => esc_html__( 'Blocklisted Words 3', 'wpjobster' )
		),
		array(
			'id'       => 'wpj_filter_words3',
			'type'     => 'select',
			'title'    => esc_html__( 'Where does it apply?', 'wpjobster' ),
			'subtitle' => esc_html__( 'Choose the places where you want the words from the blocklist 3 to be filtered.', 'wpjobster' ),
			'multi'    => true,
			'options'  => array(
				'privatemessages'  => __( 'Private Messages', 'wpjobster' ),
				'transactionpages' => __( 'Transaction Pages', 'wpjobster' ),
				'joblistings'      => __( 'Job Listings', 'wpjobster' ),
				'requestlistings'  => __( 'Request Listings', 'wpjobster' ),
				'userprofiles'     => __( 'User Profiles', 'wpjobster' )
			),
			'default'  => array( 'privatemessages', 'transactionpages', 'joblistings', 'requestlistings', 'userprofiles' )
		),
		array(
			'id'       => 'wpjobster_blacklisted_words3_pm_err',
			'type'     => 'textarea',
			'title'    => esc_html__( 'Blocklisted Words 3 Error', 'wpjobster' )
		),
		array(
			'id'       => 'wpjobster_blacklisted_email',
			'type'     => 'textarea',
			'title'    => esc_html__( 'Email Error', 'wpjobster' ),
			'default'  => 'Providing your contact details in messages is against our terms of service!',
		),
		array(
			'id'       => 'wpj_filter_emails',
			'type'     => 'select',
			'title'    => esc_html__( 'Where does it apply?', 'wpjobster' ),
			'subtitle' => esc_html__( 'Choose the places where you want the emails to be filtered.', 'wpjobster' ),
			'multi'    => true,
			'options'  => array(
				'privatemessages'  => __( 'Private Messages', 'wpjobster' ),
				'transactionpages' => __( 'Transaction Pages', 'wpjobster' ),
				'joblistings'      => __( 'Job Listings', 'wpjobster' ),
				'requestlistings'  => __( 'Request Listings', 'wpjobster' ),
				'userprofiles'     => __( 'User Profiles', 'wpjobster' )
			),
			'default'  => array( 'privatemessages', 'transactionpages', 'joblistings', 'requestlistings', 'userprofiles' )
		),
		array(
			'id'          => 'wpjobster_blacklisted_prefixes_pm',
			'type'        => 'textarea',
			'title'       => esc_html__( 'Blocklisted Phone Prefixes', 'wpjobster' ),
			'placeholder' => "415\n+44"
		),
		array(
			'id'       => 'wpj_filter_phone_numbers',
			'type'     => 'select',
			'title'    => esc_html__( 'Where does it apply?', 'wpjobster' ),
			'subtitle' => esc_html__( 'Choose the places where you want the phone numbers to be filtered.', 'wpjobster' ),
			'multi'    => true,
			'options'  => array(
				'privatemessages'  => __( 'Private Messages', 'wpjobster' ),
				'transactionpages' => __( 'Transaction Pages', 'wpjobster' ),
				'joblistings'      => __( 'Job Listings', 'wpjobster' ),
				'requestlistings'  => __( 'Request Listings', 'wpjobster' ),
				'userprofiles'     => __( 'User Profiles', 'wpjobster' )
			),
			'default'  => array( 'privatemessages', 'joblistings', 'requestlistings', 'userprofiles' )
		),
		array(
			'id'       => 'wpjobster_blacklisted_phone',
			'type'     => 'textarea',
			'title'    => esc_html__( 'Phone Number Error', 'wpjobster' ),
			'default'  => 'Providing your contact details in messages is against our terms of service!'
		),
	)
);