<?php // Limit Settings

$character_limit_settings_array = array(
	'title'      => __( 'Limits', 'wpjobster' ),
	'desc'       => __( 'Character Limits Settings', 'wpjobster' ),
	'id'         => 'limits-settings',
	'subsection' => true,
	'fields'     => array(

/* JOB LIMITS */
		array(
			'id'       => 'job-limits-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Job Limits', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'            => 'wpj_job_title_character_limits',
			'type'          => 'slider',
			'title'         => esc_html__( 'Title', 'wpjobster' ),
			'subtitle'      => esc_html__( 'Set min and max character limit for job title', 'wpjobster' ),
			'default'       => array(
				1 => 5,
				2 => 80,
			),
			'min'           => 0,
			'step'          => 1,
			'max'           => 10000,
			'display_value' => 'text',
			'handles'       => 2,
		),
		array(
			'id'            => 'wpj_job_description_character_limits',
			'type'          => 'slider',
			'title'         => esc_html__( 'Description', 'wpjobster' ),
			'subtitle'      => esc_html__( 'Set min and max character limit for job description', 'wpjobster' ),
			'default'       => array(
				1 => 35,
				2 => 1000,
			),
			'min'           => 0,
			'step'          => 1,
			'max'           => 10000,
			'display_value' => 'text',
			'handles'       => 2,
		),
		array(
			'id'            => 'wpj_job_package_title_character_limits',
			'type'          => 'slider',
			'title'         => esc_html__( 'Package Title', 'wpjobster' ),
			'subtitle'      => esc_html__( 'Set min and max character limit for job package title', 'wpjobster' ),
			'default'       => array(
				1 => 5,
				2 => 120,
			),
			'min'           => 0,
			'step'          => 1,
			'max'           => 10000,
			'display_value' => 'text',
			'handles'       => 2,
			'disabled'      => ! wpj_is_allowed( 'packages' ) ? true : false,
		),
		array(
			'id'            => 'wpj_job_package_description_character_limits',
			'type'          => 'slider',
			'title'         => esc_html__( 'Package Description', 'wpjobster' ),
			'subtitle'      => esc_html__( 'Set min and max character limit for job package description', 'wpjobster' ),
			'default'       => array(
				1 => 5,
				2 => 1000,
			),
			'min'           => 0,
			'step'          => 1,
			'max'           => 10000,
			'display_value' => 'text',
			'handles'       => 2,
			'disabled'      => ! wpj_is_allowed( 'packages' ) ? true : false,
		),
		array(
			'id'            => 'wpj_job_instructions_character_limits',
			'type'          => 'slider',
			'title'         => esc_html__( 'Buyer Instructions', 'wpjobster' ),
			'subtitle'      => esc_html__( 'Set min and max character limit for job title', 'wpjobster' ),
			'default'       => array(
				1 => 35,
				2 => 500,
			),
			'min'           => 0,
			'step'          => 1,
			'max'           => 10000,
			'display_value' => 'text',
			'handles'       => 2,
		),
		array(
			'id'            => 'wpj_job_extra_description_character_limits',
			'type'          => 'slider',
			'title'         => esc_html__( 'Extra Description', 'wpjobster' ),
			'subtitle'      => esc_html__( 'Set min and max character limit for job extra description', 'wpjobster' ),
			'default'       => array(
				1 => 5,
				2 => 50,
			),
			'min'           => 0,
			'step'          => 1,
			'max'           => 10000,
			'display_value' => 'text',
			'handles'       => 2,
		),

/* REQUEST LIMITS */
		array(
			'id'       => 'request-limits-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Request Limits', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'            => 'wpj_request_title_character_limits',
			'type'          => 'slider',
			'title'         => esc_html__( 'Title', 'wpjobster' ),
			'subtitle'      => esc_html__( 'Set min and max character limit for request title', 'wpjobster' ),
			'default'       => array(
				1 => 5,
				2 => 80,
			),
			'min'           => 0,
			'step'          => 1,
			'max'           => 10000,
			'display_value' => 'text',
			'handles'       => 2,
		),
		array(
			'id'            => 'wpj_request_description_character_limits',
			'type'          => 'slider',
			'title'         => esc_html__( 'Description', 'wpjobster' ),
			'subtitle'      => esc_html__( 'Set min and max character limit for request description', 'wpjobster' ),
			'default'       => array(
				1 => 35,
				2 => 500,
			),
			'min'           => 0,
			'step'          => 1,
			'max'           => 10000,
			'display_value' => 'text',
			'handles'       => 2,
		),

/* ORDER LIMITS */
		array(
			'id'       => 'order-limits-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Order Limits', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'            => 'wpj_feedback_message_character_limits',
			'type'          => 'slider',
			'title'         => esc_html__( 'Feedback Message', 'wpjobster' ),
			'subtitle'      => esc_html__( 'Set min and max character limit for feedback message', 'wpjobster' ),
			'default'       => array(
				1 => 35,
				2 => 1000,
			),
			'min'           => 0,
			'step'          => 1,
			'max'           => 10000,
			'display_value' => 'text',
			'handles'       => 2,
		),
		array(
			'id'            => 'wpj_custom_extra_character_limits',
			'type'          => 'slider',
			'title'         => esc_html__( 'Custom Extra Description', 'wpjobster' ),
			'subtitle'      => esc_html__( 'Set min and max character limit for custom extra description', 'wpjobster' ),
			'default'       => array(
				1 => 5,
				2 => 500,
			),
			'min'           => 0,
			'step'          => 1,
			'max'           => 10000,
			'display_value' => 'text',
			'handles'       => 2,
		),

/* PM LIMITS */
		array(
			'id'       => 'pm-limits-settings',
			'type'     => 'section',
			'title'    => esc_html__( 'Private Message Limits', 'wpjobster' ),
			'indent'   => true,
		),
		array(
			'id'            => 'wpj_private_message_character_limits',
			'type'          => 'slider',
			'title'         => esc_html__( 'Private Message', 'wpjobster' ),
			'subtitle'      => esc_html__( 'Set min and max character limit for private message', 'wpjobster' ),
			'default'       => array(
				1 => 0,
				2 => 1200,
			),
			'min'           => 0,
			'step'          => 1,
			'max'           => 10000,
			'display_value' => 'text',
			'handles'       => 2,
		),

	)
);