<?php // Active Jobs Settings

$level_defaults        = array( 7, 10, 20, 30 );
$subscription_defaults = array( 7, 10, 20, 30 );

for ( $i = 0; $i < 4; $i++ ) {
	$level_active_jobs_fields[] = array(
		'id'       => 'wpjobster_get_level' . $i . '_active_jobs',
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_enable_active_jobs', '=', true ),
		'default'  => $level_defaults[$i]
	);

	$subscription_active_jobs_fields[] = array(
		'id'       => 'wpjobster_subscription_active_jobs_level' . $i,
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_subscription_active_jobs_enabled', '=', true ),
		'default'  => $subscription_defaults[$i]
	);
}

$feature_active_jobs_settings_array = array(
	'title'      => __( 'Active Jobs', 'wpjobster' ),
	'desc'       => __( 'Active Jobs Settings', 'wpjobster' ),
	'id'         => 'active-jobs-feature-settings',
	'subsection' => true,
	'fields'     => array_merge(

/* LEVEL */

		array(
			array(
				'id'       => 'level-active-jobs-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Level Settings', 'wpjobster' ),
				'indent'   => true
			),
			array(
				'id'       => 'wpjobster_enable_active_jobs',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'No. of active jobs allowed for each level.', 'wpjobster' ),
				'default'  => false
			)
		), $level_active_jobs_fields,

/* SUBSCRIPTION */

		array(
			array(
				'id'       => 'subscription-active-jobs-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Subscription Settings', 'wpjobster' ),
				'indent'   => true,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			),
			array(
				'id'       => 'wpjobster_subscription_active_jobs_enabled',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'No. of active jobs allowed for each level of subscription.', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			)
		), $subscription_active_jobs_fields
	)
);