<?php // Additional Revision Settings

$level_defaults        = array( 3, 5, 10, 20 );
$subscription_defaults = array( 3, 5, 10, 20 );

for ( $i = 0; $i < 4; $i++ ) {
	$level_additional_revision_fields[] = array(
		'id'       => 'wpjobster_get_level' . $i . '_add_rev_multiples',
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_enable_extra_additional_revision', '=', true ),
		'default'  => $level_defaults[$i]
	);

	$subscription_additional_revision_fields[] = array(
		'id'       => 'wpjobster_subscription_add_rev_multiples_level' . $i,
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_subscription_additional_revision_enabled', '=', true ),
		'default'  => $subscription_defaults[$i]
	);
}

$feature_additional_revision_settings_array = array(
	'title'      => __( 'Additional Revision', 'wpjobster' ),
	'desc'       => __( 'Additional Revision Settings', 'wpjobster' ),
	'id'         => 'additional-revision-feature-settings',
	'subsection' => true,
	'fields'     => array_merge(

/* LEVEL */

		array(
			array(
				'id'       => 'level-additional-revision-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Level Settings', 'wpjobster' ),
				'indent'   => true
			),
			array(
				'id'       => 'wpjobster_enable_extra_additional_revision',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'No. of additional revisions allowed for each level.', 'wpjobster' ),
				'default'  => false
			)
		), $level_additional_revision_fields,

/* SUBSCRIPTION */

		array(
			array(
				'id'       => 'subscription-additional-revision-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Subscription Settings', 'wpjobster' ),
				'indent'   => true,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			),
			array(
				'id'       => 'wpjobster_subscription_additional_revision_enabled',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'No. of additional revisions allowed for each level of subscription.', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			)
		), $subscription_additional_revision_fields
	)
);