<?php // Extra Fast Delivery Settings

$level_defaults        = array( 3, 5, 10, 20 );
$subscription_defaults = array( 3, 5, 10, 20 );

for ( $i = 0; $i < 4; $i++ ) {
	$level_extra_fast_delivery_fields[] = array(
		'id'       => 'wpjobster_get_level' . $i . '_fast_delivery_multiples',
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_enable_extra_fast_delivery', '=', true ),
		'disabled' => ! wpj_is_allowed( 'fast_del_multiples' ) ? true : false,
		'default'  => $level_defaults[$i]

	);

	$subscription_extra_fast_delivery_fields[] = array(
		'id'       => 'wpjobster_subscription_fast_del_multiples_level' . $i,
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_subscription_ex_fast_delivery_enabled', '=', true ),
		'disabled' => ! wpj_is_allowed( 'fast_del_multiples' ) ? true : false,
		'default'  => $subscription_defaults[$i]
	);
}

$feature_extra_fast_delivery_settings_array = array(
	'title'      => __( 'Extra Fast Delivery', 'wpjobster' ),
	'desc'       => __( 'Extra Fast Delivery Settings', 'wpjobster' ),
	'id'         => 'extra-fast-delivery-feature-settings',
	'subsection' => true,
	'fields'     => array_merge(

/* LEVEL */

		array(
			array(
				'id'       => 'level-extra-fast-delivery-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Level Settings', 'wpjobster' ),
				'indent'   => true
			),
			array(
				'id'       => 'wpjobster_enable_extra_fast_delivery',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'No. of extras fast delivery allowed for each level.', 'wpjobster' ),
				'default'  => false
			)
		), $level_extra_fast_delivery_fields,

/* SUBSCRIPTION */

		array(
			array(
				'id'       => 'subscription-extra-fast-delivery-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Subscription Settings', 'wpjobster' ),
				'indent'   => true,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			),
			array(
				'id'       => 'wpjobster_subscription_ex_fast_delivery_enabled',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'No. of extras fast delivery allowed for each level of subscription.', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_subscription_enabled', '=', true ),
				'disabled' => ! wpj_is_allowed( 'fast_del_multiples' ) ? true : false,
			)
		), $subscription_extra_fast_delivery_fields
	)
);