<?php // Extra Multiples Settings

$level_defaults        = array( 3, 5, 10, 20 );
$subscription_defaults = array( 3, 5, 10, 20 );

for ( $i = 0; $i < 4; $i++ ) {
	$level_extra_multiples_fields[] = array(
		'id'       => 'wpjobster_get_level' . $i . '_extramultiples',
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_enable_extra_multiples', '=', true ),
		'default'  => $level_defaults[$i]
	);

	$subscription_extra_multiples_fields[] = array(
		'id'       => 'wpjobster_subscription_extra_multiples_level' . $i,
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_subscription_extra_multiples_enabled', '=', true ),
		'default'  => $subscription_defaults[$i]
	);
}

$feature_extra_multiple_settings_array = array(
	'title'      => __( 'Extra Multiples', 'wpjobster' ),
	'desc'       => __( 'Extra Multiples Settings', 'wpjobster' ),
	'id'         => 'extra-multiples-feature-settings',
	'subsection' => true,
	'fields'     => array_merge(

/* LEVEL */

		array(
			array(
				'id'       => 'level-extra-multiples-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Level Settings', 'wpjobster' ),
				'indent'   => true
			),
			array(
				'id'       => 'wpjobster_enable_extra_multiples',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'No. of multiples allowed for each level.', 'wpjobster' ),
				'default'  => false
			)
		), $level_extra_multiples_fields,

/* SUBSCRIPTION */

		array(
			array(
				'id'       => 'subscription-extra-multiples-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Subscription Settings', 'wpjobster' ),
				'indent'   => true,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			),
			array(
				'id'       => 'wpjobster_subscription_extra_multiples_enabled',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'No. of multiples allowed for each level of subscription.', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			)
		), $subscription_extra_multiples_fields
	)
);