<?php // Extra Services Settings

$level_defaults        = array( 3, 3, 3, 3 );
$subscription_defaults = array( 3, 5, 7, 9 );

for ( $i = 0; $i < 4; $i++ ) {
	$level_extra_services_fields[] = array(
		'id'       => 'wpjobster_get_level' . $i . '_extras',
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_enable_extra', '=', true ),
		'default'  => $level_defaults[$i]
	);

	$subscription_extra_services_fields[] = array(
		'id'       => 'wpjobster_subscription_noof_extras_level' . $i,
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_subscription_noof_extras_enabled', '=', true ),
		'default'  => $subscription_defaults[$i]
	);
}

$feature_extra_service_settings_array = array(
	'title'      => __( 'Extra Services', 'wpjobster' ),
	'desc'       => __( 'Extra Services Settings', 'wpjobster' ),
	'id'         => 'extra-service-feature-settings',
	'subsection' => true,
	'fields'     => array_merge(

/* LEVEL */

		array(
			array(
				'id'       => 'level-extra-service-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Level Settings', 'wpjobster' ),
				'indent'   => true
			),
			array(
				'id'       => 'wpjobster_enable_extra',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'No. of extras allowed for each level (max 10).', 'wpjobster' ),
				'default'  => false
			)
		), $level_extra_services_fields,

/* SUBSCRIPTION */

		array(
			array(
				'id'       => 'subscription-extra-service-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Subscription Settings', 'wpjobster' ),
				'indent'   => true,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			),
			array(
				'id'       => 'wpjobster_subscription_noof_extras_enabled',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'No. of extras allowed for each level of subscription (max 10).', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			)
		), $subscription_extra_services_fields
	)
);