<?php // Fees to be Charged Settings

$defaults = array( 20, 15, 10, 5 );
for ( $i = 0; $i < 4; $i++ ) {
	$subscription_fees_fields[] = array(
		'id'       => 'wpjobster_subscription_fees_level' . $i,
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_fees_for_subscriber_enabled', '=', true ),
		'default'  => $defaults[$i]
	);
}

$feature_fees_charged_settings_array = array(
	'title'      => __( 'Fees to be Charged', 'wpjobster' ),
	'desc'       => __( 'Fees to be Charged Settings', 'wpjobster' ),
	'id'         => 'fees-to-be-charged-feature-settings',
	'subsection' => true,
	'fields'     => array_merge(
		array(

/* LEVEL */

			array(
				'id'       => 'level-fees-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Level Settings', 'wpjobster' ),
				'indent'   => true
			),
			array(
				'id'    => 'feature-info-1',
				'type'  => 'info',
				'title' => __( 'This section is only available when the subscription is activated.<br>To enable the subscription, go to Payment Type > Subscription > Enabled.<br>If the subscription is already enabled, fill in the fields below in the Subscription Settings section.<br>To set the level fees, go to Pricing Settings > Fees > Site Fees.', 'wpjobster' )
			),

/* SUBSCRIPTION */

			array(
				'id'       => 'subscription-fees-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Subscription Settings', 'wpjobster' ),
				'indent'   => true,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			),
			array(
				'id'       => 'wpjobster_fees_for_subscriber_enabled',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'Percentage fees will be charged from the seller for any sold job. This will override the default fees.', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			)
		), $subscription_fees_fields
	)
);