<?php // Icon URL Settings

for ( $i = 0; $i < 4; $i++ ) {
	$subscription_icon_url_fields[] = array(
		'id'       => 'wpjobster_subscription_icon_url_level' . $i,
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_subscription_icon_url_enabled', '=', true )
	);
}

$feature_icon_url_settings_array = array(
	'title'      => __( 'Icon URL', 'wpjobster' ),
	'desc'       => __( 'Icon URL Settings', 'wpjobster' ),
	'id'         => 'icon-url-feature-settings',
	'subsection' => true,
	'fields'     => array_merge(
		array(

/* LEVEL */

			array(
				'id'       => 'level-icon-url-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Level Settings', 'wpjobster' ),
				'indent'   => true
			),
			array(
				'id'    => 'feature-info-3',
				'type'  => 'info',
				'title' => __( 'This section is only available when the subscription is activated.<br>To enable the subscription, go to Payment Type > Subscription > Enabled.<br>If the subscription is already enabled, fill in the fields below in the Subscription Settings section.', 'wpjobster' )
			),

/* SUBSCRIPTION */

			array(
				'id'       => 'subscription-icon-url-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Subscription Settings', 'wpjobster' ),
				'indent'   => true,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			),
			array(
				'id'       => 'wpjobster_subscription_icon_url_enabled',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'Icon URL for each level.', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			)
		), $subscription_icon_url_fields
	)
);