<?php // Job Multiples Settings

$level_defaults        = array( 3, 5, 10, 20 );
$subscription_defaults = array( 3, 5, 10, 20 );

for ( $i = 0; $i < 4; $i++ ) {
	$level_job_multiples_fields[] = array(
		'id'       => 'wpjobster_get_level' . $i . '_jobmultiples',
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_enable_multiples', '=', true ),
		'disabled' => ! wpj_is_allowed( 'job_multiples' ) ? true : false,
		'default'  => $level_defaults[$i]
	);

	$subscription_job_multiples_fields[] = array(
		'id'       => 'wpjobster_subscription_job_multiples_level' . $i,
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_subscription_job_multiples_enabled', '=', true ),
		'disabled' => ! wpj_is_allowed( 'job_multiples' ) ? true : false,
		'default'  => $subscription_defaults[$i]
	);
}

$feature_job_multiple_settings_array = array(
	'title'      => __( 'Job Multiples', 'wpjobster' ),
	'desc'       => __( 'Job Multiples Settings', 'wpjobster' ),
	'id'         => 'job-multiples-feature-settings',
	'subsection' => true,
	'fields'     => array_merge(

/* LEVEL */

		array(
			array(
				'id'       => 'level-job-multiples-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Level Settings', 'wpjobster' ),
				'indent'   => true
			),
			array(
				'id'       => 'wpjobster_enable_multiples',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'No. of multiples allowed for each level.', 'wpjobster' ),
				'default'  => false,
				'disabled' => ! wpj_is_allowed( 'job_multiples' ) ? true : false
			)
		), $level_job_multiples_fields,

/* SUBSCRIPTION */

		array(
			array(
				'id'       => 'subscription-job-multiples-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Subscription Settings', 'wpjobster' ),
				'indent'   => true,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			),
			array(
				'id'       => 'wpjobster_subscription_job_multiples_enabled',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'No. of multiples allowed for each level of subscription.', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_subscription_enabled', '=', true ),
				'disabled' => ! wpj_is_allowed( 'job_multiples' ) ? true : false,
			)
		), $subscription_job_multiples_fields
	)
);