<?php // Job Packages Settings

for ( $i = 0; $i < 4; $i++ ) {
	$level_job_packges_fields[] = array(
		'id'       => 'wpjobster_get_level' . $i . '_packages',
		'type'     => 'switch',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'disabled' => ! wpj_is_allowed( 'packages' ) ? true : false,
		'default'  => wpj_is_allowed( 'packages' ) ? true : false,
	);

	$subscription_job_packges_fields[] = array(
		'id'       => 'wpjobster_subscription_packages_level' . $i,
		'type'     => 'switch',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_subscription_enabled', '=', true ),
		'disabled' => ! wpj_is_allowed( 'packages' ) ? true : false,
		'default'  => wpj_is_allowed( 'packages' ) ? true : false,
	);
}

$feature_job_package_settings_array = array(
	'title'      => __( 'Job Packages', 'wpjobster' ),
	'desc'       => __( 'Job Packages Settings', 'wpjobster' ),
	'id'         => 'job-packages-feature-settings',
	'subsection' => true,
	'fields'     => array_merge(

/* LEVEL */

		array(
			array(
				'id'       => 'level-packages-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Level Settings', 'wpjobster' ),
				'indent'   => true
			)
		), $level_job_packges_fields,

/* SUBSCRIPTION */

		array(
			array(
				'id'       => 'subscription-packages-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Subscription Settings', 'wpjobster' ),
				'indent'   => true,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			)
		), $subscription_job_packges_fields
	)
);