<?php // Profile Label Settings

for ( $i = 0; $i < 4; $i++ ) {
	$subscription_profile_label_fields[] = array(
		'id'       => 'wpjobster_subscription_profile_label_level' . $i,
		'type'     => 'text',
		'title'    => sprintf( __( 'Level %d', 'wpjobster' ), $i ),
		'required' => array( 'wpjobster_subscription_profile_label_enabled', '=', true ),
		'default'  => 'Subscription Level ' . $i,
	);
}

$feature_profile_label_settings_array = array(
	'title'      => __( 'Profile Label', 'wpjobster' ),
	'desc'       => __( 'Profile Label Settings', 'wpjobster' ),
	'id'         => 'profile-label-feature-settings',
	'subsection' => true,
	'fields'     => array_merge(
		array(

/* LEVEL */

			array(
				'id'       => 'level-profile-label-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Level Settings', 'wpjobster' ),
				'indent'   => true
			),
			array(
				'id'    => 'feature-info-2',
				'type'  => 'info',
				'title' => __( 'This section is only available when the subscription is activated.<br>To enable the subscription, go to Payment Type > Subscription > Enabled.<br>If the subscription is already enabled, fill in the fields below in the Subscription Settings section.', 'wpjobster' )
			),

/* SUBSCRIPTION */

			array(
				'id'       => 'subscription-profile-label-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Subscription Settings', 'wpjobster' ),
				'indent'   => true,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			),
			array(
				'id'       => 'wpjobster_subscription_profile_label_enabled',
				'type'     => 'switch',
				'title'    => __( 'Enabled', 'wpjobster' ),
				'subtitle' => __( 'Label displayed on hover for each level icon.', 'wpjobster' ),
				'default'  => false,
				'required' => array( 'wpjobster_subscription_enabled', '=', true )
			)
		), $subscription_profile_label_fields
	)
);